/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver.gui;

import com.rc.retroweaver.RefVerifier;
import com.rc.retroweaver.RetroWeaver;
import com.rc.retroweaver.Weaver;
import com.rc.retroweaver.event.VerifierListener;
import com.rc.retroweaver.event.WeaveListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.objectweb.asm.commons.EmptyVisitor;

public class RetroWeaverGui
extends JPanel
implements WeaveListener,
VerifierListener {
    private JButton transform;
    private JButton browse;
    private JTextField pathField;
    private JTextField refClassPath = new JTextField();
    private JComboBox targetCombo;
    private JLabel status;
    private JButton exit;
    private JTextArea messages;
    private int version;
    private File path;
    private JScrollPane messageScrollPane;
    private static final String READY = "Ready";
    private static final int INSET_SIZE = 3;
    private static final Insets INSETS = new Insets(3, 3, 3, 3);
    private static final int[] VERSION_NUMBERS = new int[]{48, 47, 46};
    private Thread runWeaverThread;

    public static void main(String[] args) {
        String defaultPath = "";
        if (args.length > 0) {
            if (args[0].equals("-console")) {
                String[] a = new String[args.length - 1];
                System.arraycopy(args, 1, a, 0, args.length - 1);
                Weaver.main(a);
                return;
            }
            defaultPath = args[0];
        }
        String version = Weaver.getVersion();
        RetroWeaverGui.showInJFrame("RetroWeaver " + version, new RetroWeaverGui(defaultPath));
    }

    private static void showInJFrame(String title, Component contents) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().add(contents);
        frame.setSize(400, 300);
        RetroWeaverGui.centerOnScreen(frame);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static void centerOnScreen(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        frame.setLocation(x, y);
    }

    public RetroWeaverGui(String defaultPath) {
        super(new BorderLayout());
        this.add(this.createParameterSection(), "North");
        this.add(this.createMessageArea(), "Center");
        this.add(this.createSouthSection(), "South");
        this.pathField.setText(defaultPath);
    }

    public void weavingStarted(String msg) {
        this.displayWeavingMessage(msg);
    }

    public void weavingPath(String sourcePath) {
        String pathAsString = this.path.getAbsolutePath();
        if (sourcePath.startsWith(pathAsString)) {
            sourcePath = sourcePath.substring(pathAsString.length());
        }
        this.displayWeavingMessage(sourcePath);
    }

    public void weavingError(String msg) {
        this.displayWeavingMessage(msg);
    }

    public void weavingCompleted(String msg) {
        this.displayWeavingMessage(msg);
    }

    private void displayWeavingMessage(String msg) {
        this.messages.append("[RetroWeaver] " + msg + "\n");
        this.messageScrollPane.getVerticalScrollBar().setValue(this.messageScrollPane.getVerticalScrollBar().getMaximum());
    }

    public void verifyPathStarted(String msg) {
        this.displayVerifierMessage(msg);
    }

    public void verifyClassStarted(String msg) {
        this.displayVerifierMessage(msg);
    }

    public void acceptWarning(String msg) {
        this.displayVerifierMessage(msg);
    }

    public void displaySummary(int warningCount) {
        this.displayVerifierMessage("Verification complete, " + warningCount + " warning(s).");
    }

    private void displayVerifierMessage(String msg) {
        this.messages.append("[RefVerifier] " + msg + "\n");
        this.messageScrollPane.getVerticalScrollBar().setValue(this.messageScrollPane.getVerticalScrollBar().getMaximum());
    }

    private Component createParameterSection() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.addAt(ret, 0, 0, new JLabel("Source:"));
        this.addAt(ret, 1, 0, 2, 2, 0.0, this.createPathField());
        this.addAt(ret, 3, 0, this.createBrowse());
        this.addAt(ret, 0, 1, new JLabel("Target:"));
        this.addAt(ret, 1, 1, this.createTargetChooser());
        this.addAt(ret, 2, 1, 2, 1, 1.0, new JPanel());
        this.addAt(ret, 0, 2, new JLabel("Ref Verify Classpath:"));
        this.addAt(ret, 1, 2, 2, 2, 0.0, this.refClassPath);
        this.addAt(ret, 3, 2, 2, 1, 1.0, new JPanel());
        return ret;
    }

    private Component createSouthSection() {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add(this.createActionButtons(), "Center");
        ret.add(this.createStatus(), "South");
        ret.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return ret;
    }

    private Component createActionButtons() {
        JPanel ret = new JPanel(new FlowLayout(2));
        ret.add(this.createTransform());
        ret.add(this.createExit());
        return ret;
    }

    private Component createPathField() {
        this.pathField = new JTextField();
        this.pathField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                RetroWeaverGui.this.doPathChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                RetroWeaverGui.this.doPathChanged();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        return this.pathField;
    }

    private Component createBrowse() {
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RetroWeaverGui.this.doBrowse();
            }
        });
        return this.browse;
    }

    private Component createTargetChooser() {
        this.targetCombo = new JComboBox<String>(new String[]{"1.4", "1.3", "1.2"});
        this.targetCombo.setSelectedIndex(0);
        this.targetCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RetroWeaverGui.this.status.setText(RetroWeaverGui.READY);
            }
        });
        return this.targetCombo;
    }

    private Component createTransform() {
        this.transform = new JButton("Transform");
        this.transform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RetroWeaverGui.this.doTransform();
            }
        });
        return this.transform;
    }

    private Component createExit() {
        this.exit = new JButton("Exit");
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RetroWeaverGui.this.doExit();
            }
        });
        return this.exit;
    }

    private Component createStatus() {
        this.status = new JLabel(READY);
        return this.status;
    }

    private Component createMessageArea() {
        JPanel ret = new JPanel(new BorderLayout());
        ret.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.messages = new JTextArea();
        this.messageScrollPane = new JScrollPane(this.messages);
        ret.add((Component)this.messageScrollPane, "Center");
        return ret;
    }

    private void addAt(Container container, int x, int y, Component component) {
        this.addAt(container, x, y, 0, 1, 0.0, component);
    }

    private void addAt(Container container, int x, int y, int fill, int gridwidth, double weightx, Component component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.fill = fill;
        constraints.insets = INSETS;
        constraints.gridwidth = gridwidth;
        constraints.weightx = weightx;
        container.add(component, constraints);
    }

    private void doTransform() {
        if (this.runWeaverThread != null && this.runWeaverThread.isAlive()) {
            JOptionPane.showMessageDialog(this, "RetroWeaver is already running, wait until it has finished ");
            return;
        }
        this.path = new File(this.pathField.getText());
        if (!this.path.exists()) {
            this.status.setText("Error: Path \"" + this.path + "\" does not exist");
            return;
        }
        this.version = VERSION_NUMBERS[this.targetCombo.getSelectedIndex()];
        this.runWeaverThread = this.createWeaverThread();
        this.runWeaverThread.start();
    }

    private void doBrowse() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.pathField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        this.status.setText(READY);
    }

    private void doExit() {
        JFrame frame = (JFrame)this.getTopLevelAncestor();
        frame.dispose();
    }

    private void doPathChanged() {
        this.status.setText(READY);
    }

    private Thread createWeaverThread() {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Cursor oldCursor = RetroWeaverGui.this.getTopLevelAncestor().getCursor();
                RetroWeaverGui.this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    RetroWeaverGui.this.status.setText("Running");
                    RetroWeaver weaver = new RetroWeaver(RetroWeaverGui.this.version);
                    RetroWeaverGui.this.messages.setText("");
                    weaver.setListener(RetroWeaverGui.this);
                    String refCp = RetroWeaverGui.this.refClassPath.getText();
                    if (refCp.length() != 0) {
                        ArrayList<String> classpath = new ArrayList<String>();
                        StringTokenizer st = new StringTokenizer(refCp, File.pathSeparator);
                        while (st.hasMoreTokens()) {
                            classpath.add(st.nextToken());
                        }
                        RefVerifier verifier = new RefVerifier(RetroWeaverGui.this.version, new EmptyVisitor(), classpath, RetroWeaverGui.this);
                        weaver.setVerifier(verifier);
                    }
                    weaver.weave(RetroWeaverGui.this.path);
                    RetroWeaverGui.this.status.setText("Done");
                }
                catch (Exception ex) {
                    RetroWeaverGui.this.status.setText("Error: " + ex.getMessage());
                }
                finally {
                    RetroWeaverGui.this.getTopLevelAncestor().setCursor(oldCursor);
                }
            }
        });
    }
}

