# A progress bar implemented using gdialog

package XMLTV::ProgressBar::GDialog;
use strict;

use FileHandle;

my $pid;
my $file_handle;
my $max_value;
my $current_value;

sub new {
        
        my $class = shift;
        my $self = {};
        
        bless $self, $class;
        
        $self->_init(@_);
        
}

sub _init {
        
        my $self = shift;
        
        # Term::ProgressBar V1 Compatibility
        if(@_==2) {
                
                return $self->_init({count      => $_[1], name => $_[0],
                      term_width => 50,    bar_width => 50,
                      major_char => '#',   minor_char => '',
                      lbrack     => '',    rbrack     => '',
                      term       => 0, })
                
        }
        
        my %params = %{$_[0]};
        
        my $text = $params{name};
        $max_value = $params{count};
        $current_value=0;
        
        $file_handle = new FileHandle;
        
        $pid = open($file_handle, "| gdialog --title 'Please Wait' --gauge '$text' 10 20 0") or die "Couldn't run gdialog";
        
        return $self;
        
}

sub update {
        
        my $self = shift;
        my $set_to_value = shift;
        
        if( not $set_to_value ) {
                
                $set_to_value = $current_value+1;
                
        }
        
        # Send the percentage to gdialog and terminate with \x0a since \n
        # doesn't seem to work.
        printf $file_handle "%d\x0a", (100*$set_to_value/$max_value);
        
        $current_value = $set_to_value;
        
}

sub finish {

        # Nasty hack since sending an EOF doesn't appear to work:
        my $num = kill "TERM", $pid;
        
        if(!$num) {
                print "sgddg\n";
                kill "KILL", $pid;
        }
        
        # Should be this, but doesn't work:
        #print $file_handle "\x04";
        #$file_handle->close() or die "Couldn't close gdialog window";
        #undef($file_handle);
        
}

1;
