# Copyright 2015 The ANGLE Project Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
    'variables':
    {
        'deqp_dir': 'third_party/deqp',
        'delibs_dir': 'third_party/deqp/framework/delibs',
        'libpng_dir': 'third_party/libpng',
        'zlib_dir': 'third_party/zlib',
        'deqp_msvs_disabled_warnings':
        [
            '4100',
            '4127', # conditional expression constant
            '4244', # possible loss of data
            '4245', # argument signed/unsigned mismatch
            '4389', # signed/unsigned mismatch
            '4510', # default constructor could not be generated
            '4512',
            '4610', # cannot be instantiated
            '4611', # setjmp interaction non-portable
            '4701', # potentially uninit used
            '4702', # unreachable code
            '4706',
            '4996', # deprecated
        ],
        'deqp_defines':
        [
            'DEQP_SUPPORT_GLES3=1',
            'DEQP_SUPPORT_GLES2=1',
            'DEQP_SUPPORT_EGL=1',
            'DEQP_TARGET_NAME="angle"',
            'DEQP_GLES3_RUNTIME_LOAD=1',
            'DEQP_GLES2_RUNTIME_LOAD=1',
            'QP_SUPPORT_PNG=1',
        ],
        'deqp_include_dirs':
        [
            'third_party/libpng',
            'third_party/zlib',
            '<(delibs_dir)/debase',
            '<(delibs_dir)/decpp',
            '<(delibs_dir)/depool',
            '<(delibs_dir)/dethread',
            '<(delibs_dir)/deutil',
            '<(delibs_dir)/destream',
            '<(deqp_dir)/framework/common',
            '<(deqp_dir)/framework/qphelper',
            # TODO(jmadill): other platforms
            '<(deqp_dir)/framework/platform/win32',
            '<(deqp_dir)/framework/egl',
            '<(deqp_dir)/framework/egl/wrapper',
            '<(deqp_dir)/framework/opengl',
            '<(deqp_dir)/framework/opengl/wrapper',
            '<(deqp_dir)/framework/referencerenderer',
            '<(deqp_dir)/framework/opengl/simplereference',
            '<(deqp_dir)/framework/randomshaders',
            '<(deqp_dir)/modules/gles2',
            '<(deqp_dir)/modules/gles2/functional',
            '<(deqp_dir)/modules/gles2/accuracy',
            '<(deqp_dir)/modules/gles2/performance',
            '<(deqp_dir)/modules/gles2/stress',
            '<(deqp_dir)/modules/gles2/usecases',
            '<(deqp_dir)/modules/gles3',
            '<(deqp_dir)/modules/gles3/functional',
            '<(deqp_dir)/modules/gles3/accuracy',
            '<(deqp_dir)/modules/gles3/performance',
            '<(deqp_dir)/modules/gles3/stress',
            '<(deqp_dir)/modules/gles3/usecases',
            '<(deqp_dir)/modules/gles31',
            '<(deqp_dir)/modules/gles31/functional',
            '<(deqp_dir)/modules/gles31/stress',
            '<(deqp_dir)/modules/glshared',
            '<(deqp_dir)/modules/glusecases',
            '<(deqp_dir)/executor',
            '<(deqp_dir)/execserver',
        ],
        'deqp_gles2_sources':
        [
            '<(deqp_dir)/modules/gles2/accuracy/es2aAccuracyTests.cpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aAccuracyTests.hpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aTextureMipmapTests.cpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aTextureMipmapTests.hpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aVaryingInterpolationTests.cpp',
            '<(deqp_dir)/modules/gles2/accuracy/es2aVaryingInterpolationTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fApiCase.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fApiCase.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fAttribLocationTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fAttribLocationTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBlendTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBlendTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBooleanStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBooleanStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferObjectQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferObjectQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferTestUtil.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferTestUtil.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferWriteTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fBufferWriteTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fClippingTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fClippingTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fColorClearTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fColorClearTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDefaultVertexAttributeTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDefaultVertexAttributeTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthRangeTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthRangeTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthStencilClearTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthStencilClearTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthStencilTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthStencilTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDepthTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDitheringTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDitheringTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDrawTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fDrawTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboApiTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboApiTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboCompletenessTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboCompletenessTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboRenderTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboRenderTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFboStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFloatStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFloatStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFlushFinishTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFlushFinishTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFragOpInteractionTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFragOpInteractionTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFunctionalTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fFunctionalTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fImplementationLimitTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fImplementationLimitTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fIntegerStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fIntegerStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fLifetimeTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fLifetimeTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fLightAmountTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fLightAmountTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fMultisampleTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fMultisampleTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeBufferApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeBufferApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeFragmentApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeFragmentApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeShaderApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeShaderApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeStateApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeStateApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeTextureApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeTextureApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeVertexArrayApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fNegativeVertexArrayApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fPolygonOffsetTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fPolygonOffsetTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fPrerequisiteTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fPrerequisiteTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRandomFragmentOpTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRandomFragmentOpTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRandomShaderTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRandomShaderTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRasterizationTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRasterizationTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRboStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fRboStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fReadPixelsTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fReadPixelsTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fScissorTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fScissorTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderAlgorithmTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderAlgorithmTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderBuiltinVarTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderBuiltinVarTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderConstExprTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderConstExprTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderDiscardTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderDiscardTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderExecuteTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderExecuteTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderFragDataTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderFragDataTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderIndexingTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderIndexingTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderInvarianceTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderInvarianceTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderLoopTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderLoopTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderMatrixTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderMatrixTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderOperatorTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderOperatorTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderReturnTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderReturnTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderStructTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderStructTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderTextureFunctionTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fShaderTextureFunctionTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fStencilTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fStencilTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fStringQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fStringQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureCompletenessTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureCompletenessTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureFormatTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureFormatTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureMipmapTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureMipmapTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureSizeTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureSizeTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureSpecificationTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureSpecificationTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureUnitTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureUnitTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureWrapTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fTextureWrapTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fUniformApiTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fUniformApiTests.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fVertexArrayTest.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fVertexArrayTest.hpp',
            '<(deqp_dir)/modules/gles2/functional/es2fVertexTextureTests.cpp',
            '<(deqp_dir)/modules/gles2/functional/es2fVertexTextureTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pBlendTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pBlendTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pDrawCallBatchingTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pDrawCallBatchingTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pPerformanceTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pPerformanceTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pRedundantStateChangeTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pRedundantStateChangeTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderCompilationCases.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderCompilationCases.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderCompilerTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderCompilerTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderControlStatementTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderControlStatementTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderOperatorTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderOperatorTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderOptimizationTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pShaderOptimizationTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pStateChangeCallTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pStateChangeCallTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pStateChangeTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pStateChangeTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureCases.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureCases.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureCountTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureCountTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureFormatTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureFormatTests.hpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureUploadTests.cpp',
            '<(deqp_dir)/modules/gles2/performance/es2pTextureUploadTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sDrawTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sDrawTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sLongRunningTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sLongRunningTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sMemoryTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sMemoryTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sSpecialFloatTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sSpecialFloatTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sStressTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sStressTests.hpp',
            '<(deqp_dir)/modules/gles2/stress/es2sVertexArrayTests.cpp',
            '<(deqp_dir)/modules/gles2/stress/es2sVertexArrayTests.hpp',
            '<(deqp_dir)/modules/gles2/tes2CapabilityTests.cpp',
            '<(deqp_dir)/modules/gles2/tes2CapabilityTests.hpp',
            '<(deqp_dir)/modules/gles2/tes2Context.cpp',
            '<(deqp_dir)/modules/gles2/tes2Context.hpp',
            '<(deqp_dir)/modules/gles2/tes2InfoTests.cpp',
            '<(deqp_dir)/modules/gles2/tes2InfoTests.hpp',
            '<(deqp_dir)/modules/gles2/tes2TestCase.cpp',
            '<(deqp_dir)/modules/gles2/tes2TestCase.hpp',
            '<(deqp_dir)/modules/gles2/tes2TestCaseWrapper.cpp',
            '<(deqp_dir)/modules/gles2/tes2TestCaseWrapper.hpp',
            '<(deqp_dir)/modules/gles2/tes2TestPackage.cpp',
            '<(deqp_dir)/modules/gles2/tes2TestPackage.hpp',
            '<(deqp_dir)/modules/gles2/tes2TestPackageEntry.cpp',
        ],
        'deqp_gles3_sources':
        [
            '<(deqp_dir)/modules/gles3/accuracy/es3aAccuracyTests.cpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aAccuracyTests.hpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aTextureMipmapTests.cpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aTextureMipmapTests.hpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aVaryingInterpolationTests.cpp',
            '<(deqp_dir)/modules/gles3/accuracy/es3aVaryingInterpolationTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fApiCase.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fApiCase.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fASTCDecompressionCases.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fASTCDecompressionCases.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fAttribLocationTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fAttribLocationTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBlendTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBlendTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBooleanStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBooleanStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferCopyTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferCopyTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferMapTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferMapTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferObjectQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferObjectQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferWriteTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBufferWriteTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBuiltinPrecisionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fBuiltinPrecisionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fClippingTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fClippingTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fColorClearTest.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fColorClearTest.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fCompressedTextureTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fCompressedTextureTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDefaultVertexAttributeTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDefaultVertexAttributeTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthStencilClearTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthStencilClearTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthStencilTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthStencilTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDepthTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDitheringTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDitheringTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDrawTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fDrawTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboColorbufferTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboColorbufferTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboCompletenessTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboCompletenessTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboDepthbufferTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboDepthbufferTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboInvalidateTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboInvalidateTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboMultisampleTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboMultisampleTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboRenderTest.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboRenderTest.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboStencilbufferTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboStencilbufferTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboTestCase.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboTestCase.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboTestUtil.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFboTestUtil.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFloatStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFloatStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFlushFinishTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFlushFinishTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragDepthTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragDepthTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragmentOutputTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragmentOutputTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragOpInteractionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFragOpInteractionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFramebufferBlitTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFramebufferBlitTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFunctionalTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fFunctionalTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fImplementationLimitTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fImplementationLimitTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fIndexedStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fIndexedStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInstancedRenderingTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInstancedRenderingTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInteger64StateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInteger64StateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fIntegerStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fIntegerStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInternalFormatQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fInternalFormatQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fLifetimeTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fLifetimeTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fMultisampleTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fMultisampleTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeBufferApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeBufferApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeFragmentApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeFragmentApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeShaderApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeShaderApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeStateApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeStateApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeTextureApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeTextureApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeVertexArrayApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fNegativeVertexArrayApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fOcclusionQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fOcclusionQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPixelBufferObjectTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPixelBufferObjectTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPolygonOffsetTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPolygonOffsetTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPrerequisiteTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPrerequisiteTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPrimitiveRestartTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fPrimitiveRestartTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRandomFragmentOpTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRandomFragmentOpTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRandomShaderTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRandomShaderTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRasterizationTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRasterizationTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRasterizerDiscardTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRasterizerDiscardTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRboStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fRboStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fReadPixelsTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fReadPixelsTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSamplerObjectTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSamplerObjectTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSamplerStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSamplerStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fScissorTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fScissorTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderBuiltinVarTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderBuiltinVarTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderCommonFunctionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderCommonFunctionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderConstExprTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderConstExprTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderDerivateTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderDerivateTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderDiscardTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderDiscardTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderFragDataTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderFragDataTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderIndexingTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderIndexingTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderInvarianceTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderInvarianceTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderLoopTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderLoopTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderMatrixTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderMatrixTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderOperatorTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderOperatorTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderPackingFunctionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderPackingFunctionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderPrecisionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderPrecisionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderReturnTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderReturnTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderStructTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderStructTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderSwitchTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderSwitchTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderTextureFunctionTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fShaderTextureFunctionTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fStencilTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fStencilTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fStringQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fStringQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSyncTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fSyncTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureFormatTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureFormatTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureMipmapTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureMipmapTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureShadowTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureShadowTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSizeTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSizeTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSpecificationTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSpecificationTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureStateQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureStateQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSwizzleTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureSwizzleTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureUnitTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureUnitTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureWrapTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTextureWrapTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTransformFeedbackTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fTransformFeedbackTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fUniformApiTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fUniformApiTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fUniformBlockTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fUniformBlockTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexArrayObjectTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexArrayObjectTests.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexArrayTest.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexArrayTest.hpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexTextureTests.cpp',
            '<(deqp_dir)/modules/gles3/functional/es3fVertexTextureTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pBlendTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pBlendTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pBufferDataUploadTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pBufferDataUploadTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pDepthTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pDepthTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pPerformanceTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pPerformanceTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pRedundantStateChangeTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pRedundantStateChangeTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderCompilationCases.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderCompilationCases.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderCompilerTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderCompilerTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderControlStatementTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderControlStatementTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderOperatorTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderOperatorTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderOptimizationTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pShaderOptimizationTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pStateChangeCallTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pStateChangeCallTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pStateChangeTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pStateChangeTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureCases.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureCases.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureCountTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureCountTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureFilteringTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureFilteringTests.hpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureFormatTests.cpp',
            '<(deqp_dir)/modules/gles3/performance/es3pTextureFormatTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sDrawTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sDrawTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongRunningShaderTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongRunningShaderTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongRunningTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongRunningTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongShaderTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sLongShaderTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sMemoryTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sMemoryTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sOcclusionQueryTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sOcclusionQueryTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sSpecialFloatTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sSpecialFloatTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sStressTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sStressTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sSyncTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sSyncTests.hpp',
            '<(deqp_dir)/modules/gles3/stress/es3sVertexArrayTests.cpp',
            '<(deqp_dir)/modules/gles3/stress/es3sVertexArrayTests.hpp',
            '<(deqp_dir)/modules/gles3/tes3Context.cpp',
            '<(deqp_dir)/modules/gles3/tes3Context.hpp',
            '<(deqp_dir)/modules/gles3/tes3InfoTests.cpp',
            '<(deqp_dir)/modules/gles3/tes3InfoTests.hpp',
            '<(deqp_dir)/modules/gles3/tes3TestCase.cpp',
            '<(deqp_dir)/modules/gles3/tes3TestCase.hpp',
            '<(deqp_dir)/modules/gles3/tes3TestCaseWrapper.cpp',
            '<(deqp_dir)/modules/gles3/tes3TestCaseWrapper.hpp',
            '<(deqp_dir)/modules/gles3/tes3TestPackage.cpp',
            '<(deqp_dir)/modules/gles3/tes3TestPackage.hpp',
            '<(deqp_dir)/modules/gles3/tes3TestPackageEntry.cpp',
        ],
    },

    'conditions':
    [
        ['angle_standalone==1',
        {
            'conditions':
            [
                ['OS=="win"',
                {
                    'targets':
                    [
                        {
                            'target_name': 'angle_zlib',
                            'type': 'static_library',
                            'includes': [ '../../build/common_defines.gypi', ],
                            'include_dirs':
                            [
                                '<(zlib_dir)',
                            ],
                            'direct_dependent_settings':
                            {
                                'include_dirs':
                                [
                                    '<(zlib_dir)',
                                ],
                            },
                            'msvs_settings':
                            {
                                'VCCLCompilerTool':
                                {
                                    'AdditionalOptions':
                                    [
                                        '/wd4131', # old-style declarator
                                        '/wd4244', # Conversion from 'type1' to 'type2', possible loss of data
                                        '/wd4324', # structure was padded
                                        '/wd4701', # potentially uninit used
                                        '/wd4996', # deprecated
                                    ],
                                },
                            },
                            'sources':
                            [
                                '<(zlib_dir)/adler32.c',
                                '<(zlib_dir)/compress.c',
                                '<(zlib_dir)/crc32.c',
                                '<(zlib_dir)/crc32.h',
                                '<(zlib_dir)/deflate.c',
                                '<(zlib_dir)/deflate.h',
                                '<(zlib_dir)/gzclose.c',
                                '<(zlib_dir)/gzguts.h',
                                '<(zlib_dir)/gzlib.c',
                                '<(zlib_dir)/gzread.c',
                                '<(zlib_dir)/gzwrite.c',
                                '<(zlib_dir)/infback.c',
                                '<(zlib_dir)/inffast.c',
                                '<(zlib_dir)/inffast.h',
                                '<(zlib_dir)/inffixed.h',
                                '<(zlib_dir)/inflate.c',
                                '<(zlib_dir)/inflate.h',
                                '<(zlib_dir)/inftrees.c',
                                '<(zlib_dir)/inftrees.h',
                                '<(zlib_dir)/mozzconf.h',
                                '<(zlib_dir)/trees.c',
                                '<(zlib_dir)/trees.h',
                                '<(zlib_dir)/uncompr.c',
                                '<(zlib_dir)/x86.h',
                                '<(zlib_dir)/zconf.h',
                                '<(zlib_dir)/zlib.h',
                                '<(zlib_dir)/zutil.c',
                                '<(zlib_dir)/zutil.h',
                                '<(zlib_dir)/simd_stub.c',
                            ],
                        },

                        {
                            'target_name': 'angle_libpng',
                            'type': 'static_library',
                            'includes': [ '../../build/common_defines.gypi', ],
                            'dependencies':
                            [
                                'angle_zlib'
                            ],
                            'msvs_settings':
                            {
                                'VCCLCompilerTool':
                                {
                                    'AdditionalOptions':
                                    [
                                        '/wd4018', # signed/unsigned mismatch
                                        '/wd4028', # parameter differs from decl
                                        '/wd4101', # unreferenced local
                                        '/wd4189', # unreferenced but initted
                                        '/wd4244', # Conversion from 'type1' to 'type2', possible loss of data
                                    ],
                                },
                            },
                            'sources':
                            [
                                '<(libpng_dir)/png.c',
                                '<(libpng_dir)/pngerror.c',
                                '<(libpng_dir)/pngget.c',
                                '<(libpng_dir)/pngmem.c',
                                '<(libpng_dir)/pngpread.c',
                                '<(libpng_dir)/pngread.c',
                                '<(libpng_dir)/pngrio.c',
                                '<(libpng_dir)/pngrtran.c',
                                '<(libpng_dir)/pngrutil.c',
                                '<(libpng_dir)/pngset.c',
                                '<(libpng_dir)/pngtrans.c',
                                '<(libpng_dir)/pngwio.c',
                                '<(libpng_dir)/pngwrite.c',
                                '<(libpng_dir)/pngwtran.c',
                                '<(libpng_dir)/pngwutil.c',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_decpp',
                            'type': 'static_library',
                            'msvs_disabled_warnings':
                            [
                                '<@(deqp_msvs_disabled_warnings)',
                            ],
                            'msvs_settings':
                            {
                                'VCCLCompilerTool':
                                {
                                    'AdditionalOptions':
                                    [
                                        '/EHsc',   # dEQP requires exceptions
                                    ],
                                },
                            },
                            'defines': ['<@(deqp_defines)'],
                            'include_dirs': ['<@(deqp_include_dirs)'],
                            'direct_dependent_settings':
                            {
                                'msvs_disabled_warnings':
                                [
                                    '<@(deqp_msvs_disabled_warnings)',
                                ],
                                'msvs_settings':
                                {
                                    'VCCLCompilerTool':
                                    {
                                        'AdditionalOptions':
                                        [
                                            '/EHsc',   # dEQP requires exceptions
                                        ],
                                    },
                                    'VCLinkerTool':
                                    {
                                        'AdditionalDependencies':
                                        [
                                            'dbghelp.lib',
                                            'gdi32.lib',
                                            'user32.lib',
                                            'ws2_32.lib',
                                        ],
                                    },
                                },
                                'include_dirs': ['<@(deqp_include_dirs)'],
                                'defines': ['<@(deqp_defines)'],
                            },
                            'sources':
                            [
                                '<(deqp_dir)/framework/delibs/decpp/deArrayBuffer.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deBlockBuffer.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deCommandLine.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deDefs.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deDirectoryIterator.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deDynamicLibrary.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deFilePath.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deMemPool.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deMutex.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/dePoolArray.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/dePoolString.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deProcess.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deRandom.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deRingBuffer.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deSemaphore.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deSharedPtr.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deSocket.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deSTLUtil.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deStringUtil.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deThread.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deThreadLocal.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deThreadSafeRingBuffer.cpp',
                                '<(deqp_dir)/framework/delibs/decpp/deUniquePtr.cpp',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_libtester',
                            'type': 'static_library',
                            'dependencies':
                            [
                                'angle_deqp_decpp',
                                'angle_libpng',
                                '<(angle_path)/src/angle.gyp:libEGL',
                            ],
                            'include_dirs':
                            [
                                '<(angle_path)/include',
                            ],
                            'direct_dependent_settings':
                            {
                                'include_dirs':
                                [
                                    '<(angle_path)/include',
                                ],
                            },
                            'msvs_settings':
                            {
                                'VCCLCompilerTool':
                                {
                                    'AdditionalOptions':
                                    [
                                        '/bigobj', # needed for glsBuiltinPrecisionTests.cpp
                                    ],
                                },
                            },
                            'export_dependent_settings':
                            [
                                'angle_deqp_decpp',
                            ],
                            'sources':
                            [
                                '<(deqp_dir)/execserver/xsDefs.cpp',
                                '<(deqp_dir)/execserver/xsExecutionServer.cpp',
                                '<(deqp_dir)/execserver/xsPosixFileReader.cpp',
                                '<(deqp_dir)/execserver/xsPosixTestProcess.cpp',
                                '<(deqp_dir)/execserver/xsProtocol.cpp',
                                '<(deqp_dir)/execserver/xsTcpServer.cpp',
                                '<(deqp_dir)/execserver/xsTestDriver.cpp',
                                '<(deqp_dir)/execserver/xsTestProcess.cpp',
                                '<(deqp_dir)/executor/xeBatchExecutor.cpp',
                                '<(deqp_dir)/executor/xeBatchResult.cpp',
                                '<(deqp_dir)/executor/xeCallQueue.cpp',
                                '<(deqp_dir)/executor/xeCommLink.cpp',
                                '<(deqp_dir)/executor/xeContainerFormatParser.cpp',
                                '<(deqp_dir)/executor/xeDefs.cpp',
                                '<(deqp_dir)/executor/xeLocalTcpIpLink.cpp',
                                '<(deqp_dir)/executor/xeTcpIpLink.cpp',
                                '<(deqp_dir)/executor/xeTestCase.cpp',
                                '<(deqp_dir)/executor/xeTestCaseListParser.cpp',
                                '<(deqp_dir)/executor/xeTestCaseResult.cpp',
                                '<(deqp_dir)/executor/xeTestLogParser.cpp',
                                '<(deqp_dir)/executor/xeTestLogWriter.cpp',
                                '<(deqp_dir)/executor/xeTestResultParser.cpp',
                                '<(deqp_dir)/executor/xeXMLParser.cpp',
                                '<(deqp_dir)/executor/xeXMLWriter.cpp',
                                '<(deqp_dir)/framework/common/tcuApp.cpp',
                                '<(deqp_dir)/framework/common/tcuBilinearImageCompare.cpp',
                                '<(deqp_dir)/framework/common/tcuCommandLine.cpp',
                                '<(deqp_dir)/framework/common/tcuCompressedTexture.cpp',
                                '<(deqp_dir)/framework/common/tcuCPUWarmup.cpp',
                                '<(deqp_dir)/framework/common/tcuDefs.cpp',
                                '<(deqp_dir)/framework/common/tcuEither.cpp',
                                '<(deqp_dir)/framework/common/tcuFactoryRegistry.cpp',
                                '<(deqp_dir)/framework/common/tcuFloatFormat.cpp',
                                '<(deqp_dir)/framework/common/tcuFunctionLibrary.cpp',
                                '<(deqp_dir)/framework/common/tcuFuzzyImageCompare.cpp',
                                '<(deqp_dir)/framework/common/tcuImageCompare.cpp',
                                '<(deqp_dir)/framework/common/tcuImageIO.cpp',
                                '<(deqp_dir)/framework/common/tcuInterval.cpp',
                                '<(deqp_dir)/framework/common/tcuPlatform.cpp',
                                '<(deqp_dir)/framework/common/tcuRandomValueIterator.cpp',
                                '<(deqp_dir)/framework/common/tcuRenderTarget.cpp',
                                '<(deqp_dir)/framework/common/tcuResource.cpp',
                                '<(deqp_dir)/framework/common/tcuResultCollector.cpp',
                                '<(deqp_dir)/framework/common/tcuRGBA.cpp',
                                '<(deqp_dir)/framework/common/tcuStringTemplate.cpp',
                                '<(deqp_dir)/framework/common/tcuSurface.cpp',
                                '<(deqp_dir)/framework/common/tcuTestCase.cpp',
                                '<(deqp_dir)/framework/common/tcuTestCaseWrapper.cpp',
                                '<(deqp_dir)/framework/common/tcuTestContext.cpp',
                                '<(deqp_dir)/framework/common/tcuTestExecutor.cpp',
                                '<(deqp_dir)/framework/common/tcuTestLog.cpp',
                                '<(deqp_dir)/framework/common/tcuTestPackage.cpp',
                                '<(deqp_dir)/framework/common/tcuTexCompareVerifier.cpp',
                                '<(deqp_dir)/framework/common/tcuTexLookupVerifier.cpp',
                                '<(deqp_dir)/framework/common/tcuTexture.cpp',
                                '<(deqp_dir)/framework/common/tcuTextureUtil.cpp',
                                '<(deqp_dir)/framework/common/tcuTexVerifierUtil.cpp',
                                '<(deqp_dir)/framework/common/tcuThreadUtil.cpp',
                                '<(deqp_dir)/framework/common/tcuSeedBuilder.cpp',
                                '<(deqp_dir)/framework/delibs/debase/deDefs.c',
                                '<(deqp_dir)/framework/delibs/debase/deFloat16.c',
                                '<(deqp_dir)/framework/delibs/debase/deInt32.c',
                                '<(deqp_dir)/framework/delibs/debase/deInt32Test.c',
                                '<(deqp_dir)/framework/delibs/debase/deMath.c',
                                '<(deqp_dir)/framework/delibs/debase/deMemory.c',
                                '<(deqp_dir)/framework/delibs/debase/deRandom.c',
                                '<(deqp_dir)/framework/delibs/debase/deString.c',
                                '<(deqp_dir)/framework/delibs/deimage/deImage.c',
                                '<(deqp_dir)/framework/delibs/deimage/deTarga.c',
                                '<(deqp_dir)/framework/delibs/depool/deMemPool.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolArray.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolHashArray.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolHash.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolHashSet.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolHeap.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolMultiSet.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolSet.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolStringBuilder.c',
                                '<(deqp_dir)/framework/delibs/depool/dePoolTest.c',
                                '<(deqp_dir)/framework/delibs/destream/deFileStream.c',
                                '<(deqp_dir)/framework/delibs/destream/deRingbuffer.c',
                                '<(deqp_dir)/framework/delibs/destream/deStreamCpyThread.c',
                                '<(deqp_dir)/framework/delibs/destream/deThreadStream.c',
                                '<(deqp_dir)/framework/delibs/dethread/deAtomic.c',
                                '<(deqp_dir)/framework/delibs/dethread/deSingleton.c',
                                '<(deqp_dir)/framework/delibs/dethread/deThreadTest.c',
                                # TODO(jmadill): other platforms
                                '<(deqp_dir)/framework/delibs/dethread/win32/deMutexWin32.c',
                                '<(deqp_dir)/framework/delibs/dethread/win32/deSemaphoreWin32.c',
                                '<(deqp_dir)/framework/delibs/dethread/win32/deThreadLocalWin32.c',
                                '<(deqp_dir)/framework/delibs/dethread/win32/deThreadWin32.c',
                                #'<(deqp_dir)/framework/delibs/dethread/unix/deMutexUnix.c',
                                #'<(deqp_dir)/framework/delibs/dethread/unix/deNamedSemaphoreUnix.c',
                                #'<(deqp_dir)/framework/delibs/dethread/unix/deSemaphoreUnix.c',
                                #'<(deqp_dir)/framework/delibs/dethread/unix/deThreadLocalUnix.c',
                                #'<(deqp_dir)/framework/delibs/dethread/unix/deThreadUnix.c',
                                '<(deqp_dir)/framework/delibs/deutil/deClock.c',
                                '<(deqp_dir)/framework/delibs/deutil/deCommandLine.c',
                                '<(deqp_dir)/framework/delibs/deutil/deDynamicLibrary.c',
                                '<(deqp_dir)/framework/delibs/deutil/deFile.c',
                                '<(deqp_dir)/framework/delibs/deutil/deProcess.c',
                                '<(deqp_dir)/framework/delibs/deutil/deSocket.c',
                                '<(deqp_dir)/framework/delibs/deutil/deTimer.c',
                                '<(deqp_dir)/framework/delibs/deutil/deTimerTest.c',
                                '<(deqp_dir)/framework/egl/egluCallLogWrapper.cpp',
                                '<(deqp_dir)/framework/egl/egluConfigFilter.cpp',
                                '<(deqp_dir)/framework/egl/egluConfigInfo.cpp',
                                '<(deqp_dir)/framework/egl/egluDefs.cpp',
                                '<(deqp_dir)/framework/egl/egluGLContextFactory.cpp',
                                '<(deqp_dir)/framework/egl/egluGLFunctionLoader.cpp',
                                '<(deqp_dir)/framework/egl/egluGLFunctionLoader.cpp',
                                '<(deqp_dir)/framework/egl/egluGLUtil.cpp',
                                '<(deqp_dir)/framework/egl/egluNativeDisplay.cpp',
                                '<(deqp_dir)/framework/egl/egluNativePixmap.cpp',
                                '<(deqp_dir)/framework/egl/egluNativeWindow.cpp',
                                '<(deqp_dir)/framework/egl/egluPlatform.cpp',
                                '<(deqp_dir)/framework/egl/egluStaticESLibrary.cpp',
                                '<(deqp_dir)/framework/egl/egluStrUtil.cpp',
                                '<(deqp_dir)/framework/egl/egluUnique.cpp',
                                '<(deqp_dir)/framework/egl/egluUtil.cpp',
                                '<(deqp_dir)/framework/egl/wrapper/eglwDefs.cpp',
                                '<(deqp_dir)/framework/egl/wrapper/eglwFunctions.cpp',
                                '<(deqp_dir)/framework/egl/wrapper/eglwLibrary.cpp',
                                '<(deqp_dir)/framework/opengl/gluCallLogWrapper.cpp',
                                '<(deqp_dir)/framework/opengl/gluContextFactory.cpp',
                                '<(deqp_dir)/framework/opengl/gluContextInfo.cpp',
                                '<(deqp_dir)/framework/opengl/gluDefs.cpp',
                                '<(deqp_dir)/framework/opengl/gluDrawUtil.cpp',
                                '<(deqp_dir)/framework/opengl/gluDummyRenderContext.cpp',
                                '<(deqp_dir)/framework/opengl/gluES3PlusWrapperContext.cpp',
                                '<(deqp_dir)/framework/opengl/gluFboRenderContext.cpp',
                                '<(deqp_dir)/framework/opengl/gluObjectWrapper.cpp',
                                '<(deqp_dir)/framework/opengl/gluPixelTransfer.cpp',
                                '<(deqp_dir)/framework/opengl/gluPlatform.cpp',
                                '<(deqp_dir)/framework/opengl/gluProgramInterfaceQuery.cpp',
                                '<(deqp_dir)/framework/opengl/gluRenderConfig.cpp',
                                '<(deqp_dir)/framework/opengl/gluRenderContext.cpp',
                                '<(deqp_dir)/framework/opengl/gluShaderProgram.cpp',
                                '<(deqp_dir)/framework/opengl/gluShaderUtil.cpp',
                                '<(deqp_dir)/framework/opengl/gluStateReset.cpp',
                                '<(deqp_dir)/framework/opengl/gluStrUtil.cpp',
                                '<(deqp_dir)/framework/opengl/gluTexture.cpp',
                                '<(deqp_dir)/framework/opengl/gluTextureUtil.cpp',
                                '<(deqp_dir)/framework/opengl/gluVarType.cpp',
                                '<(deqp_dir)/framework/opengl/gluVarTypeUtil.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrContext.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrContextUtil.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrContextWrapper.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrGLContext.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrReferenceContext.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrReferenceUtils.cpp',
                                '<(deqp_dir)/framework/opengl/simplereference/sglrShaderProgram.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwDefs.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwFunctions.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwInitES20Direct.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwInitES30Direct.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwInitFunctions.cpp',
                                '<(deqp_dir)/framework/opengl/wrapper/glwWrapper.cpp',
                                '<(deqp_dir)/framework/platform/tcuMain.cpp',
                                # TODO(jmadill): other platforms
                                '<(deqp_dir)/framework/platform/win32/tcuWin32Window.cpp',
                                '<(deqp_dir)/framework/qphelper/qpCrashHandler.c',
                                '<(deqp_dir)/framework/qphelper/qpDebugOut.c',
                                '<(deqp_dir)/framework/qphelper/qpInfo.c',
                                '<(deqp_dir)/framework/qphelper/qpTestLog.c',
                                '<(deqp_dir)/framework/qphelper/qpWatchDog.c',
                                '<(deqp_dir)/framework/qphelper/qpXmlWriter.c',
                                '<(deqp_dir)/framework/randomshaders/rsgBinaryOps.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgBuiltinFunctions.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgDefs.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgExecutionContext.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgExpression.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgExpressionGenerator.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgFunctionGenerator.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgGeneratorState.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgNameAllocator.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgParameters.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgPrettyPrinter.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgProgramExecutor.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgProgramGenerator.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgSamplers.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgShader.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgShaderGenerator.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgStatement.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgToken.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgUtils.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgVariable.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgVariableManager.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgVariableType.cpp',
                                '<(deqp_dir)/framework/randomshaders/rsgVariableValue.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrDefs.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrFragmentOperations.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrMultisamplePixelBufferAccess.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrPrimitivePacket.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrRasterizer.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrRenderer.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrShaders.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrShadingContext.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrVertexAttrib.cpp',
                                '<(deqp_dir)/framework/referencerenderer/rrVertexPacket.cpp',
                                '<(deqp_dir)/modules/glshared/glsAttributeLocationTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsBufferTestUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsBuiltinPrecisionTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsCalibration.cpp',
                                '<(deqp_dir)/modules/glshared/glsDrawTest.cpp',
                                '<(deqp_dir)/modules/glshared/glsFboCompletenessTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsFboUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsFragmentOpUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsFragOpInteractionCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsInteractionTestUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsLifetimeTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsLongStressCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsLongStressTestUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsMemoryStressCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsRandomShaderCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsRandomShaderProgram.cpp',
                                '<(deqp_dir)/modules/glshared/glsRandomUniformBlockCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsRasterizationTestUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsSamplerObjectTest.cpp',
                                '<(deqp_dir)/modules/glshared/glsScissorTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderConstExprTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderExecUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderLibraryCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderLibrary.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderPerformanceCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderPerformanceMeasurer.cpp',
                                '<(deqp_dir)/modules/glshared/glsShaderRenderCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsStateQueryUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsStateChangePerfTestCases.cpp',
                                '<(deqp_dir)/modules/glshared/glsTextureBufferCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsTextureStateQueryTests.cpp',
                                '<(deqp_dir)/modules/glshared/glsTextureTestUtil.cpp',
                                '<(deqp_dir)/modules/glshared/glsUniformBlockCase.cpp',
                                '<(deqp_dir)/modules/glshared/glsVertexArrayTests.cpp',
                                # TODO(jmadill): other platforms
                                'deqp_support/tcuANGLEWin32NativeDisplayFactory.cpp',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_libgles2',
                            'type': 'shared_library',
                            'dependencies':
                            [
                                'angle_deqp_libtester',
                            ],
                            'defines':
                            [
                                'ANGLE_DEQP_GLES2_TESTS',
                            ],
                            'sources':
                            [
                                '<@(deqp_gles2_sources)',
                                'deqp_support/angle_deqp_libtester_main.cpp',
                                'deqp_support/tcuANGLEWin32Platform.cpp',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_libgles3',
                            'type': 'shared_library',
                            'dependencies':
                            [
                                'angle_deqp_libtester',
                            ],
                            'defines':
                            [
                                'ANGLE_DEQP_GLES3_TESTS',
                            ],
                            'sources':
                            [
                                '<@(deqp_gles3_sources)',
                                'deqp_support/angle_deqp_libtester_main.cpp',
                                'deqp_support/tcuANGLEWin32Platform.cpp',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_gles2_tests',
                            'type': 'executable',
                            'defines':
                            [
                                # Hard-code the path to dEQP. This lets the
                                # app locate the data folder without need
                                # for a copy. gyp recursive copies are not
                                # implemented properly on Windows.
                                'ANGLE_DEQP_DIR="<(DEPTH)/src/tests/<(deqp_dir)"',
                            ],
                            'dependencies':
                            [
                                'angle_deqp_libgles2',
                            ],
                            'sources':
                            [
                                'deqp_support/angle_deqp_tests_main.cpp',
                            ],
                        },

                        {
                            'target_name': 'angle_deqp_gles3_tests',
                            'type': 'executable',
                            'defines':
                            [
                                # Hard-code the path to dEQP. This lets the
                                # app locate the data folder without need
                                # for a copy. gyp recursive copies are not
                                # implemented properly on Windows.
                                'ANGLE_DEQP_DIR="<(DEPTH)/src/tests/<(deqp_dir)"',
                            ],
                            'dependencies':
                            [
                                'angle_deqp_libgles3',
                            ],
                            'sources':
                            [
                                'deqp_support/angle_deqp_tests_main.cpp',
                            ],
                        },
                    ], # targets
                }], # OS == "win"
            ], # conditions
        }], # angle_standalone
    ],
}
