/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.TextField;
import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.handlers.DisplayItemMapper;
import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCActionTable;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class DeploymentHandler {
    public static final String FORCE = "force";
    public static final String DEFAULT_FORCE = "true";
    public static final String CASCADE = "cascade";
    public static final String DEFAULT_CASCADE = "false";
    public static final String VERIFY = "verify";
    public static final String DEFAULT_VERIFY = "false";
    public static final String PRECOMPILE_JSP = "precompilejsp";
    public static final String ENABLE = "enable";
    public static final String CONTEXT_ROOT = "contextRoot";
    public static final String ARCHIVE_NAME = "archiveName";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TARGET = "target";
    public static final String LOCATION = "location";
    public static final String REDEPLOY = "redeploy";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final int APP_UNKNOWN = -3;
    public static final int APP_NO_TARGET = -2;
    public static final int APP_ALL_ENABLED = -1;
    public static final int APP_ALL_DISABLED = 0;

    public void deploy(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        String displayValue;
        String libraries;
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("view is not DescriptorContainerView", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        Properties dProps = new Properties();
        ViewDescriptor vd = descView.getViewDescriptor();
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNames = (ArrayList)handlerCtx.getInputValue("attributeNames");
        for (int i = 0; i < displayNames.size(); ++i) {
            String displayValue2 = (String)descView.getDisplayFieldValue((String)displayNames.get(i));
            if (displayValue2 == null) continue;
            dProps.setProperty((String)modelNames.get(i), displayValue2);
        }
        String jws = dProps.getProperty("java-web-start-enabled");
        if (jws != null) {
            dProps.setProperty("X-DeploymentMgr.JavaWebStartEnabled", jws);
            dProps.remove("java-web-start-enabled");
        }
        if ((libraries = dProps.getProperty("libraries")) != null) {
            dProps.setProperty("X-DeploymentMgr.Libraries", libraries);
            dProps.remove("libraries");
        }
        dProps.setProperty(FORCE, "false");
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        String type = (String)handlerCtx.getInputValue("appType");
        if (isTargetSupported != null && !isTargetSupported.booleanValue() && (type.equals("war") || type.equals("ear"))) {
            displayValue = (String)descView.getDisplayFieldValue("virtualservers");
            dProps.setProperty("virtualservers", displayValue);
        }
        if ((type.equals("war") || type.equals("ear") || type.equals("jar")) && isTargetSupported != null && isTargetSupported.booleanValue()) {
            displayValue = (String)descView.getDisplayFieldValue("availabilityEnabled");
            dProps.setProperty("availabilityenabled", displayValue);
        }
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        String location = (String)descView.getDisplayFieldValue(LOCATION);
        Object raConfig = null;
        if (type.equals("rar")) {
            ArrayList params = (ArrayList)handlerCtx.getInputValue("resourceAdapterParams");
            ArrayList types = (ArrayList)handlerCtx.getInputValue("resourceAdapterTypes");
            try {
                raConfig = this.createResourceAdapter("com.sun.appserv:type=resources,category=config", "createResourceAdapterConfig", params, types);
            }
            catch (Exception ex) {
                Util.logINFO("Deployment Handler createResourceConfig failed. " + ex.getMessage());
            }
        }
        try {
            DeploymentHandler.invokeDeploymentFacility(targets, dProps, location);
        }
        catch (Exception ex) {
            if (raConfig != null) {
                String key = (String)MBeanUtil.getAttribute(raConfig.toString(), "resource-adapter-name");
                String[] types = new String[]{"java.lang.String"};
                Object[] params = new Object[]{key};
                try {
                    MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "removeResourceAdapterConfigByResourceAdapterName", params, types);
                }
                catch (Exception ex1) {
                    Util.logINFO("Deployment Handler removeResourceAdapterConfig failed. " + ex1.getMessage());
                }
            }
            throw ex;
        }
        if (raConfig != null) {
            String registryType = (String)handlerCtx.getInputValue("registryType");
            String propName = null;
            if (registryType.equals("uddi")) {
                propName = "com.sun.appserv.registry.uddi";
            } else if (registryType.equals("ebxml")) {
                propName = "com.sun.appserv.registry.ebxml";
            }
            if (propName != null) {
                Attribute attr = new Attribute(propName, DEFAULT_FORCE);
                String[] types = new String[]{"javax.management.Attribute"};
                Object[] params = new Object[]{attr};
                MBeanUtil.invoke((ObjectName)raConfig, "setProperty", params, types);
            }
        }
    }

    public static boolean invokeDeploymentFacility(String[] targets, Properties props, String archivePath) throws Exception {
        if (archivePath == null) {
            throw new FrameworkException("archivePath is null");
        }
        if (DEFAULT_FORCE.equals(props.getProperty(FORCE))) {
            boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
            targets = isTargetSupported ? new String[]{"domain"} : new String[]{"server"};
        }
        if (targets == null || targets.length == 0) {
            targets = new String[]{"server"};
        }
        archivePath = archivePath.replace('\\', '/');
        AbstractArchive archive = new ArchiveFactory().openArchive(archivePath);
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        JESProgressObject progressObject = null;
        progressObject = df.deploy(df.createTargets(targets), (Archive)archive, null, (Map)props);
        DeploymentStatus status = null;
        do {
            if ((status = progressObject.getCompletedStatus()) != null) continue;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (status == null);
        boolean ret = DeploymentHandler.checkDeployStatus(status, "deployment.warning");
        return ret;
    }

    private static boolean checkDeployStatus(DeploymentStatus status, String warningIndex) throws FrameworkException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DeploymentStatus.parseDeploymentStatus((DeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        if (status != null && status.getStatus() == 0) {
            throw new FrameworkException(statusString);
        }
        if (status != null && status.getStatus() == 1 && warningIndex != null) {
            Util.logINFO(Util.getMessage(bundle, warningIndex, null));
        }
        return true;
    }

    public void descriptorDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String fileName = (String)ctx.getRequest().getAttribute("fileName");
        String objectName = (String)ctx.getRequest().getAttribute("objectName");
        View view = handlerCtx.getView();
        DisplayField descriptorField = (DisplayField)view;
        String descriptors = (String)MBeanUtil.invoke(objectName, "getDeploymentDescriptor", new Object[]{fileName}, new String[]{"java.lang.String"});
        descriptorField.setValue((Object)descriptors);
    }

    public void beginDescriptorTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String fileName = (String)handlerCtx.getInputValue("filename");
        if (fileName != null) {
            File f = new File(fileName);
            fileName = f.getName();
        }
        tag.setPageTitleText(fileName);
    }

    public void beginUploadPageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String appType = (String)handlerCtx.getInputValue("applicationType");
        Boolean redeploy = (Boolean)handlerCtx.getInputValue(REDEPLOY);
        String key = null;
        key = redeploy != false ? "redeploy.PageTitle" : "upload.PageTitle";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("war", Util.getMessage("upload.WebModule"));
        map.put("ear", Util.getMessage("upload.EnterpriseApplication"));
        map.put("jar", Util.getMessage("upload.EJBModule"));
        map.put("rar", Util.getMessage("upload.ConnectorModule"));
        map.put("all", Util.getMessage("upload.AppclientModule"));
        map.put("mbean", Util.getMessage("upload.CustomMBean"));
        String mappedValue = (String)map.get(appType);
        String titleText = Util.getMessage(key, new Object[]{mappedValue});
        tag.setPageTitleText(titleText);
        if (appType.equals("all")) {
            appType = "jar";
        }
        String helpText = "";
        helpText = appType.equals("mbean") ? Util.getMessage("createCustomMBean.pageHelp") : Util.getMessage("uploadPageHelp", new Object[]{appType, mappedValue});
        tag.setPageTitleHelpMessage(helpText);
    }

    public void extractJarFile(RequestContext ctx, HandlerContext handlerCtx) {
        String fileName = (String)handlerCtx.getInputValue("fileName");
        String domainRoot = (String)handlerCtx.getInputValue("domainRoot");
        if (fileName == null || domainRoot == null) {
            throw new FrameworkException("fileName, or domainRoot is null DeploymentHandlers.extractJarFile");
        }
        try {
            FileUtil.extractMbeanJarFile(domainRoot, fileName);
        }
        catch (IOException ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    public void saveThreadPool(RequestContext ctx, HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue(NAME);
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String threadPool = (String)handlerCtx.getInputValue("threadPoolId");
        if (objectName == null) {
            throw new FrameworkException("'objectName' is null in DeploymentHandler.saveThreadPool");
        }
        try {
            Attribute attr = new Attribute("thread-pool-ids", threadPool);
            MBeanUtil.setAttribute(objectName, attr);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void getVirtualservers(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String childName = (String)handlerCtx.getInputValue("childName");
        TextField textFieldChild = (TextField)descView.getChild(childName);
        String objectName = (String)handlerCtx.getInputValue("vsObjectName");
        String vsMethodName = (String)handlerCtx.getInputValue("vsMethodName");
        String vsList = "";
        Object[] vsObjectName = (Object[])MBeanUtil.invoke(objectName, vsMethodName, null, null);
        String attributeName = "id";
        if (vsObjectName != null) {
            for (int i = 0; i < vsObjectName.length; ++i) {
                String virtualservers = (String)MBeanUtil.getAttribute(vsObjectName[i].toString(), attributeName);
                if (virtualservers == null || virtualservers.equals("__asadmin")) continue;
                vsList = vsList + virtualservers + ",";
            }
        }
        if (vsList.length() > 0) {
            vsList = vsList.substring(0, vsList.length() - 1);
            textFieldChild.setValue((Object)vsList);
        }
    }

    public void setThreadPoolID(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)view.getParent();
        String editKey = (String)descView.getDisplayFieldValue("editKey");
        String adapterObjectName = "com.sun.appserv:type=resource-adapter-config,category=config,resource-adapter-name=" + editKey;
        try {
            String threadPool = (String)MBeanUtil.getAttribute(adapterObjectName, "thread-pool-ids");
            ((TextField)view).setValue((Object)threadPool);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void loadResourceAdapterProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view);
            desc = descView.getViewDescriptor();
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        ((DefaultModel)model).clear();
        Object properties = handlerCtx.getInputValue("properties");
        if (properties == null) {
            if (Util.isLoggableFINER()) {
                Util.logFINER("NO ATTRS FOUND!!");
            }
            return;
        }
        if (properties instanceof AttributeList) {
            this.loadResourceAdapterProperties((AttributeList)properties, model);
        } else if (properties instanceof Map) {
            this.loadResourceAdapterProperties((Map)properties, model);
        } else {
            throw new FrameworkException("Unknown instance properties", desc, view);
        }
    }

    private void loadResourceAdapterProperties(AttributeList attrs, CCActionTableModelInterface model) throws ModelControlException {
        Attribute attr;
        int rowNo;
        StringBuffer buf = new StringBuffer();
        for (rowNo = 0; rowNo < attrs.size(); ++rowNo) {
            attr = (Attribute)attrs.get(rowNo);
            buf.append("!!! name = " + attr.getName() + " , value = " + attr.getValue() + "\n");
        }
        if (Util.isLoggableFINER()) {
            Util.logFINER(buf.toString());
        }
        model.setRowSelectionType("none");
        model.beforeFirst();
        for (rowNo = 0; rowNo < attrs.size(); ++rowNo) {
            model.appendRow();
            attr = (Attribute)attrs.get(rowNo);
            model.setValue(PROPERTY_NAME, (Object)attr.getName());
            model.setValue(PROPERTY_VALUE, attr.getValue());
        }
    }

    private void loadResourceAdapterProperties(Map properties, CCActionTableModelInterface model) throws ModelControlException {
        Set s = properties.keySet();
        Iterator iter = s.iterator();
        model.setRowSelectionType("none");
        model.beforeFirst();
        while (iter.hasNext()) {
            Object key = iter.next();
            model.appendRow();
            model.setValue(PROPERTY_NAME, key);
            model.setValue(PROPERTY_VALUE, properties.get(key));
        }
    }

    public void getResourceAdapterProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String location = (String)handlerCtx.getInputValue(LOCATION);
        if (location == null) {
            handlerCtx.setOutputValue("properties", null);
            return;
        }
        try {
            Map props = ConnectorRuntime.getRuntime().getResourceAdapterBeanProperties(location);
            Set s = props.keySet();
            HashMap newMap = new HashMap();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                newMap.put(iter.next(), "");
            }
            handlerCtx.setOutputValue("properties", newMap);
        }
        catch (Exception ex) {
            Util.logSEVERE("Error in getting ResourceAdapter Properties ", ex);
            handlerCtx.setOutputValue("properties", null);
            return;
        }
    }

    public void getResourceAdapterPropertiesForEdit(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        Object objectName = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("'objectName' is null in DeploymentHandler.getResourceAdpaterPropertiesForEdit");
        }
        String methodName = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null) {
            throw new FrameworkException("'methodName' is null in DeploymentHandler.getResourceAdpaterPropertiesForEdit");
        }
        Object returnValue = null;
        try {
            returnValue = MBeanUtil.invoke(objectName.toString(), methodName, null, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        handlerCtx.setOutputValue("value", returnValue);
    }

    public void createResourceAdapter(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        Object objectName = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("'objectName' is null in CommonHandlers.invokeMBean");
        }
        String methodName = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null) {
            throw new FrameworkException("'methodName' is null in CommonHandlers.invokeMBean");
        }
        ArrayList types = (ArrayList)handlerCtx.getInputValue("types");
        ArrayList params = (ArrayList)handlerCtx.getInputValue("params");
        this.createResourceAdapter(objectName, methodName, params, types);
    }

    private Object createResourceAdapter(Object objectName, String methodName, ArrayList params, ArrayList types) {
        Object[] paramsAndTypes = MBeanUtil.getParamsAndTypes(params, types);
        try {
            return MBeanUtil.invoke(objectName.toString(), methodName, (Object[])paramsAndTypes[0], (String[])paramsAndTypes[1]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setResourceAdapterProperties(String name) {
        String objectName = "com.sun.appserv:type=resource-adapter-config,category=config,resource-adapter-name=" + name;
        Properties props = null;
        try {
            props = ConnectorRuntime.getRuntime().getResourceAdapterConfigProps(name);
        }
        catch (Exception e) {
            Util.logINFO("Deployment Handler setResourceAdapterProperties:" + e.getMessage());
            return;
        }
        Enumeration<?> ee = props.propertyNames();
        while (ee.hasMoreElements()) {
            Object key = ee.nextElement();
            String[] type = new String[]{"javax.management.Attribute"};
            Attribute attr = new Attribute(key.toString(), props.getProperty(key.toString()).toString());
            Object[] params = new Object[]{attr};
            MBeanUtil.invoke(objectName, "setProperty", params, type);
        }
    }

    public void applicationRefAction(RequestContext ctx, HandlerContext handlerCtx) {
        String tableChildName;
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(tableChildName = (String)handlerCtx.getInputValue("tableChildName"));
        if (tableDescriptor == null) {
            throw new FrameworkException("tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("tableDescriptor is of wrong type", tableDescriptor, view);
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        if (model == null) {
            throw new FrameworkException("PropertiesHandler.getModel: Parameter 'propertiesModel' not specified");
        }
        String editKeyValue = (String)handlerCtx.getInputValue("editKeyValue");
        String action = (String)handlerCtx.getInputValue("action");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                String objectName = (String)model.getValue("objectName");
                String target = (String)MBeanUtil.getAttribute(objectName, NAME);
                DeploymentHandler.changeEnableStatus(editKeyValue, new String[]{target}, action);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            Util.logFINER("Error while enabling: " + vd.getName());
            throw new FrameworkException((Throwable)ex);
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }

    public void actionClicked(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String childName = (String)vd.getParameter("tableChildName");
        if (childName == null) {
            throw new FrameworkException("childName not specified", vd, view);
        }
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
        if (tableDescriptor == null) {
            throw new FrameworkException("tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("tableDescriptor is of wrong type", tableDescriptor, view);
        }
        String buttonClicked = (String)handlerCtx.getInputValue("ClickedAction");
        try {
            if (buttonClicked.equalsIgnoreCase("undeploy")) {
                String type = (String)handlerCtx.getInputValue("AppType");
                this.undeploy(((CCActionTableDescriptor)tableDescriptor).getModel(), tableDescriptor, type);
            } else {
                this.doAction(((CCActionTableDescriptor)tableDescriptor).getModel(), tableDescriptor, buttonClicked);
            }
        }
        catch (FrameworkException ex) {
            throw new FrameworkException("Error while deleting from: '" + tableDescriptor.getName() + "'", (Throwable)ex, tableDescriptor, (View)descView);
        }
    }

    private void doAction(CCActionTableModelInterface model, ViewDescriptor vd, String buttonClicked) {
        RequestContext ctx = RequestManager.getRequestContext();
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        String defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        Object progressObject = null;
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                this.enableDisableAll((String)model.getValue(NAME), buttonClicked);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while " + buttonClicked + " : '" + vd.getName() + "'", (Throwable)ex, vd, null);
        }
        View view = vd.getView(ctx).getParent();
        ContainerViewBase descView = (ContainerViewBase)view;
        descView.removeChild(vd.getName());
        ((DefaultModel)model).clear();
    }

    private void enableDisableAll(String appsName, String action) {
        RequestContext ctx = RequestManager.getRequestContext();
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        boolean targetSupported = isTargetSupported == null ? false : isTargetSupported;
        String defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        if (targetSupported) {
            Object[] params = new String[]{appsName};
            String[] types = new String[]{"java.lang.String"};
            ObjectName[] refs = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "listReferencees", params, types);
            int size = refs == null ? 0 : refs.length;
            String[] targetList = new String[size];
            for (int i = 0; i < size; ++i) {
                targetList[i] = (String)MBeanUtil.getAttribute(refs[i], NAME);
            }
            DeploymentHandler.changeEnableStatus(appsName, targetList, action);
        } else {
            DeploymentHandler.changeEnableStatus(appsName, new String[]{defaultTarget}, action);
        }
    }

    public static void changeEnableStatus(String appsName, String[] targetList, String action) {
        if (targetList == null) {
            return;
        }
        Object[] params = new String[]{appsName};
        Integer type = (Integer)MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getModuleType", params, new String[]{"java.lang.String"});
        if (type != null && type == DisplayItemMapper.MODULE_MBEAN) {
            DeploymentHandler.changeEnableStatusForMbean(appsName, targetList, action);
            return;
        }
        boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        JESProgressObject progressObject = null;
        if (action.equals(ENABLE) || action.equals(DEFAULT_FORCE)) {
            if (isTargetSupported && DeploymentHandler.getAppStatus(appsName, "domain").equals("false")) {
                String[] newTargetList = new String[targetList.length + 1];
                for (int i = 0; i < targetList.length; ++i) {
                    newTargetList[i] = targetList[i];
                }
                newTargetList[targetList.length] = "domain";
                targetList = newTargetList;
            }
            progressObject = df.enable(df.createTargets(targetList), appsName);
        } else {
            progressObject = df.disable(df.createTargets(targetList), appsName);
        }
        DeploymentStatus status = df.waitFor(progressObject);
        DeploymentHandler.checkDeployStatus(status, null);
    }

    private static void changeEnableStatusForMbean(String appsName, String[] targetList, String action) {
        boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        if ((action.equals(ENABLE) || action.equals(DEFAULT_FORCE)) && DeploymentHandler.getAppStatus(appsName, "domain").equals("false")) {
            MBeanUtil.setAttribute("com.sun.appserv:type=mbean,category=config,name=" + appsName, new Attribute("enabled", DEFAULT_FORCE));
        }
        String status = action.equals(DEFAULT_FORCE) || action.equals(ENABLE) ? DEFAULT_FORCE : "false";
        Attribute attr = new Attribute("enabled", status);
        for (int i = 0; i < targetList.length; ++i) {
            String objname = "com.sun.appserv:type=application-ref,category=config,ref=" + appsName + ",server=" + targetList[i];
            MBeanUtil.setAttribute(objname, attr);
        }
    }

    private void undeploy(CCActionTableModelInterface model, ViewDescriptor vd, String type) {
        boolean targetSupported;
        RequestContext ctx = RequestManager.getRequestContext();
        String deleteKey = (String)vd.getParameter("deleteKey");
        String objectName = (String)vd.getParameter("rowObjectName");
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        boolean bl = targetSupported = isTargetSupported == null ? false : isTargetSupported;
        if (deleteKey == null) {
            throw new FrameworkException("No delete key specified");
        }
        if (objectName == null) {
            throw new FrameworkException("No ObjectName  specified");
        }
        model.setRowSelectionType("multiple");
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                String componentName = model.getValue(deleteKey).toString();
                if (type.equals("rar")) {
                    try {
                        String defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
                        String key = model.getValue(deleteKey).toString();
                        Object[] params = new Object[]{key, defaultTarget};
                        String[] types = new String[]{"java.lang.String", "java.lang.String"};
                        String resourceMethodName = "deleteResourceAdapterConfig";
                        String resourceObjectName = "com.sun.appserv:type=resources,category=config";
                        MBeanUtil.invoke(resourceObjectName, resourceMethodName, params, types);
                    }
                    catch (Exception ex) {
                        Util.logINFO("Deployment Handler deleteResourceAdapter Failed:" + ex.getMessage());
                    }
                }
                JESProgressObject progressObject = null;
                String[] targetNames = null;
                targetNames = targetSupported ? this.getApplicationTargets(model.getValue(deleteKey).toString(), objectName) : new String[]{ConfigProperties.getInstance().getDefaultTarget()};
                progressObject = df.undeploy(df.createTargets(targetNames), componentName, null);
                model.setRowSelected(false);
                DeploymentStatus status = df.waitFor(progressObject);
                DeploymentHandler.checkDeployStatus(status, null);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while undeploying: '" + vd.getName() + "'", (Throwable)ex, vd, null);
        }
        View view = vd.getView(ctx).getParent();
        ContainerViewBase descView = (ContainerViewBase)view;
        descView.removeChild(vd.getName());
        ((DefaultModel)model).clear();
    }

    private String[] getApplicationTargets(String name, String objectName) throws Exception {
        ObjectName[] returnValue = null;
        Vector<Object> targets = new Vector<Object>();
        returnValue = (ObjectName[])MBeanUtil.invoke(objectName, "listReferencees", new Object[]{name}, new String[]{"java.lang.String"});
        for (int i = 0; returnValue != null && i < returnValue.length; ++i) {
            targets.add(MBeanUtil.getAttribute(returnValue[i], NAME));
        }
        if (targets.size() == 0) {
            String defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
            targets.add(defaultTarget);
        }
        return targets.toArray(new String[targets.size()]);
    }

    public void createAppReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String[] targetNames = (String[])handlerCtx.getInputValue("targets");
        if (targetNames != null && targetNames.length > 0) {
            String key = (String)handlerCtx.getInputValue("key");
            DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
            JESProgressObject progressObject = null;
            Properties dProps = new Properties();
            progressObject = df.createAppRef(df.createTargets(targetNames), key, (Map)dProps);
            DeploymentStatus status = df.waitFor(progressObject);
            DeploymentHandler.checkDeployStatus(status, null);
        }
    }

    public void deleteAppReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String[] targetNames = (String[])handlerCtx.getInputValue("targets");
        if (targetNames != null && targetNames.length > 0) {
            String key = (String)handlerCtx.getInputValue("key");
            DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
            JESProgressObject progressObject = null;
            progressObject = df.deleteAppRef(df.createTargets(targetNames), key, null);
            DeploymentStatus status = df.waitFor(progressObject);
            DeploymentHandler.checkDeployStatus(status, null);
        }
    }

    public void loadDescriptorTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        String appName = (String)ctx.getRequest().getAttribute("editKeyValue");
        if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
            ViewDescriptor desc = view instanceof DescriptorContainerView ? ((DescriptorContainerView)view).getViewDescriptor() : (ViewDescriptor)null;
            throw new FrameworkException("This handler is for 'beforeCreate' handlers only!", desc, view);
        }
        ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        if (!(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Table model expected here", desc, view);
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        String type = (String)handlerCtx.getInputValue("value");
        if (type == null) {
            throw new FrameworkException("'type' is null in DeploymentHandlers.loadDescriptorTableModel");
        }
        Object standardDescriptor = null;
        Object sunSpecificDescriptor = null;
        String[] descriptors = null;
        if (appName != null) {
            String[] modules;
            descriptors = this.getDescriptors(appName, null);
            for (int j = 0; descriptors != null && j < descriptors.length; ++j) {
                model.appendRow();
                model.setValue((String)displayNamesList.get(0), (Object)appName);
                int index = descriptors[j].lastIndexOf(File.separator) + 1;
                model.setValue((String)displayNamesList.get(1), (Object)descriptors[j].substring(index));
                model.setValue(LOCATION, (Object)descriptors[j]);
            }
            if (type.equals("j2ee-application") && (modules = (String[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getModuleComponents", new Object[]{appName}, new String[]{"java.lang.String"})) != null) {
                for (int i = 0; i < modules.length; ++i) {
                    try {
                        String subComponentName = new ObjectName(modules[i]).getKeyProperty(NAME);
                        descriptors = this.getDescriptors(appName, subComponentName);
                        for (int j = 0; descriptors != null && j < descriptors.length; ++j) {
                            model.appendRow();
                            model.setValue((String)displayNamesList.get(0), (Object)subComponentName);
                            int index = descriptors[j].lastIndexOf(File.separator) + 1;
                            model.setValue((String)displayNamesList.get(1), (Object)descriptors[j].substring(index));
                            model.setValue(LOCATION, (Object)descriptors[j]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private String[] getDescriptors(String appName, String subComponent) {
        String[] descriptors = (String[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getDeploymentDescriptorLocations", new Object[]{appName, subComponent}, new String[]{"java.lang.String", "java.lang.String"});
        return descriptors;
    }

    private static String getAppStatus(String appName, String target) {
        Object status = MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getStatus", (Object[])new String[]{appName, target}, new String[]{"java.lang.String", "java.lang.String"});
        return status.toString();
    }

    public void getAppStatus2(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("status", (Object)DeploymentHandler.getAppStatus((String)handlerCtx.getInputValue("appName"), (String)handlerCtx.getInputValue(TARGET)));
    }

    public void loadDeploymentTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
            ViewDescriptor desc = view instanceof DescriptorContainerView ? ((DescriptorContainerView)view).getViewDescriptor() : (ViewDescriptor)null;
            throw new FrameworkException("This handler is for 'beforeCreate' handlers only!", desc, view);
        }
        ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        if (!(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Table model expected here", desc, view);
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        ((DefaultModel)model).clear();
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        String[] modelNames = modelNamesList.toArray(new String[modelNamesList.size()]);
        Object[] keys = (Object[])handlerCtx.getInputValue("keys");
        if (keys == null) {
            return;
        }
        for (int rowNo = 0; rowNo < keys.length; ++rowNo) {
            int i;
            String objectType = null;
            String type = null;
            ObjectName currentObjName = null;
            try {
                currentObjName = new ObjectName(keys[rowNo].toString());
                type = currentObjName.getKeyProperty(TYPE);
            }
            catch (Exception ex) {
                throw new FrameworkException((Throwable)ex, (ViewDescriptor)ccDesc, view);
            }
            boolean isApp = false;
            boolean isAppRef = false;
            boolean isResource = false;
            boolean isResourceRef = false;
            if (type != null) {
                if (type.equals("application-ref")) {
                    isAppRef = true;
                } else if (type.equals("resource-ref")) {
                    isResourceRef = true;
                } else if (type.equals("j2ee-application") || type.equals("ejb-module") || type.equals("web-module") || type.equals("connector-module")) {
                    isApp = true;
                    objectType = (String)MBeanUtil.getAttribute(currentObjName, "object-type");
                    if (objectType != null && !objectType.equalsIgnoreCase("user")) {
                        continue;
                    }
                } else if (type.equals("appclient-module") || type.equals("lifecycle-module") || type.equals("mbean")) {
                    isApp = true;
                } else {
                    isResource = true;
                }
            }
            boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
            AttributeList attrList = new AttributeList();
            for (i = 0; i < modelNames.length; ++i) {
                int statusSummary;
                String attrValue = (String)MBeanUtil.getAttribute(keys[rowNo].toString(), modelNames[i]);
                if (!"enabled".equals(modelNames[i])) {
                    attrList.add(new Attribute(modelNames[i], attrValue));
                    continue;
                }
                String realStatus = "";
                if (isApp) {
                    statusSummary = this.getAppStatusSummary(keys[rowNo].toString());
                    realStatus = this.convertStatusSummary(statusSummary);
                }
                if (isAppRef) {
                    String appsName = currentObjName.getKeyProperty("ref");
                    realStatus = this.getRealTargetStatus(appsName, currentObjName);
                }
                if (isResourceRef) {
                    realStatus = this.getRealResourceTargetStatus(currentObjName);
                }
                if (isResource) {
                    statusSummary = this.getResourceStatusSummary(currentObjName);
                    realStatus = this.convertStatusSummary(statusSummary);
                }
                attrList.add(new Attribute(modelNames[i], realStatus));
            }
            model.appendRow();
            int colNo = 0;
            for (i = 0; i < attrList.size(); ++i) {
                Attribute attr = (Attribute)attrList.get(i);
                while (colNo < modelNames.length && !attr.getName().equals(modelNames[colNo])) {
                    ++colNo;
                }
                if (colNo >= modelNames.length) continue;
                if (attr.getName().equals("java-web-start-enabled")) {
                    String attrValue = "false".equals(attr.getValue()) ? Util.getMessage("common.Disabled") : Util.getMessage("common.Enabled");
                    model.setValue((String)displayNamesList.get(colNo), (Object)attrValue);
                    continue;
                }
                model.setValue((String)displayNamesList.get(colNo), attr.getValue());
            }
            String objn = currentObjName.toString();
            model.setValue("objectName", (Object)objn);
            model.setValue("objectType", (Object)type);
        }
    }

    public void loadSubcomponents(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = ((DescriptorCCActionTable)view).getViewDescriptor();
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        try {
            String[] modules = (String[])MBeanUtil.invoke(objectName, methodName, new Object[]{moduleName}, new String[]{"java.lang.String"});
            for (int i = 0; i < modules.length; ++i) {
                ObjectName on = new ObjectName(modules[i]);
                model.appendRow();
                model.setValue("componentName", (Object)on.getKeyProperty(NAME));
                model.setValue("componentType", (Object)on.getKeyProperty("j2eeType"));
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Exception thrown while attempting to get Modules List.", (Throwable)ex, (ViewDescriptor)ccDesc, view);
        }
    }

    public void displayDeployPageChild(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        String propertyName = (String)handlerCtx.getInputValue(PROPERTY_NAME);
        ViewDescriptor propertySheetDescriptor = descView.getViewDescriptor();
        if (propertyName == null) {
            throw new FrameworkException("displayVirtualserver: propertySheetName is null", propertySheetDescriptor, view);
        }
        if (propertySheetDescriptor == null) {
            throw new FrameworkException("displaVirtualServer: propertySheetDescriptor is null", propertySheetDescriptor, view);
        }
        if (!(propertySheetDescriptor instanceof CCPropertySheetDescriptor)) {
            throw new FrameworkException("displayVirtualServer: propertySheetDescriptor is of wrong type", propertySheetDescriptor, view);
        }
        CCPropertySheetModelInterface model = ((CCPropertySheetDescriptor)propertySheetDescriptor).getModel();
        if (isTargetSupported != null && isTargetSupported.booleanValue()) {
            model.setVisible(propertyName, false);
            handlerCtx.setOutputValue("value", (Object)DEFAULT_FORCE);
        } else {
            model.setVisible(propertyName, true);
            handlerCtx.setOutputValue("value", (Object)"false");
        }
    }

    public String endExecuteLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        View bean = handlerCtx.getView();
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = ev.getContent();
        String isWebService = (String)handlerCtx.getInputValue("isWebService");
        String appName = (String)handlerCtx.getInputValue("appName");
        String port = null;
        try {
            port = this.getPortForApplication(appName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String serverName = ctx.getRequest().getServerName();
        String ctxtRoot = (String)handlerCtx.getInputValue("ctxtRoot");
        if (ctxtRoot == null || ctxtRoot.length() == 0) {
            ctxtRoot = "/";
        }
        if (ctxtRoot.indexOf("/") != 0) {
            ctxtRoot = "/" + ctxtRoot;
        }
        String text = this.removeProp(content, "onclick");
        content = port != null ? (isWebService == null ? this.addProp(this.removeProp(text, "href"), "href=\"http://" + serverName + ":" + port + ctxtRoot + "\" target=\"_blank\"") : this.addProp(text, "onClick=\"window.open('http://" + serverName + ":" + port + ctxtRoot + "');document.Form.target='_self'\"")) : (isWebService == null ? this.addProp(this.removeProp(text, "href"), "href=\"" + ctxtRoot + "\" target=\"_blank\"") : this.addProp(text, "onClick=\"window.open('" + ctxtRoot + "');document.Form.target='_self'\""));
        return content;
    }

    public void getLaunchURLPath(RequestContext ctx, HandlerContext handlerCtx) {
        View bean = handlerCtx.getView();
        String appclientName = (String)handlerCtx.getInputValue("appclientName");
        String applicationName = (String)handlerCtx.getInputValue("applicationName");
        if (Util.isEmpty(appclientName)) {
            throw new FrameworkException("Deployment.getLaunchURLPath(), appclientName is NULL");
        }
        try {
            String path;
            String jwsEnabled = Util.isEmpty(applicationName) ? (String)MBeanUtil.getAttribute("com.sun.appserv:type=appclient-module,category=config,name=" + appclientName, "java-web-start-enabled") : (String)MBeanUtil.getAttribute("com.sun.appserv:type=j2ee-application,category=config,name=" + applicationName, "java-web-start-enabled");
            if ("false".equals(jwsEnabled)) {
                handlerCtx.setOutputValue("isEnabled", (Object)Boolean.FALSE);
                return;
            }
            NamingConventions nc = new NamingConventions();
            String string = path = Util.isEmpty(applicationName) ? nc.getLaunchURLPath(appclientName) : nc.getLaunchURLPath(applicationName, appclientName);
            if (!Util.isEmpty(path)) {
                handlerCtx.setOutputValue("path", (Object)path);
                handlerCtx.setOutputValue("isEnabled", (Object)Boolean.TRUE);
            } else {
                handlerCtx.setOutputValue("isEnabled", (Object)Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            Util.logFINE(ex);
            ex.printStackTrace();
            handlerCtx.setOutputValue("isEnabled", (Object)Boolean.FALSE);
        }
    }

    public void getAppClientLinkPE(RequestContext ctx, HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appId");
        String port = null;
        try {
            port = this.getPortForApplication(appName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String serverName = ctx.getRequest().getServerName();
        String appendUrl = (String)handlerCtx.getInputValue("appendUrl");
        if (port != null) {
            appendUrl = "http://" + serverName + ":" + port + appendUrl;
        }
        handlerCtx.setOutputValue("appClientLink", (Object)appendUrl);
    }

    public void getAppClientLinks(RequestContext ctx, HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("appId");
        String appendUrl = (String)handlerCtx.getInputValue("appendUrl");
        if (appendUrl != null) {
            appendUrl = appendUrl.startsWith("/") ? appendUrl.substring(1) : appendUrl;
        }
        List urls = this.getURLs(id, this.getWebAppReferencees(id));
        String[] values = new String[urls.size()];
        for (int i = 0; i < urls.size(); ++i) {
            values[i] = (String)urls.get(i) + appendUrl;
        }
        handlerCtx.setOutputValue("appClientLinks", (Object)values);
    }

    public void populateRadioButtons(RequestContext ctx, HandlerContext handlerCtx) {
        SelectableGroup radioButtonChild = (SelectableGroup)handlerCtx.getView();
        DescriptorContainerView parent = (DescriptorContainerView)radioButtonChild.getParent();
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(radioButtonChild.getName());
        String[] appClientLinks = (String[])handlerCtx.getInputValue("appClientLinks");
        OptionList options = new OptionList(appClientLinks, appClientLinks);
        radioButtonChild.setOptions(options);
        radioButtonChild.setValue((Object)appClientLinks[0]);
    }

    private String getNonAdminVirtualServer() {
        String vsId = null;
        ObjectName[] vsObjectNames = (ObjectName[])MBeanUtil.invoke("ias:type=configs,category=config", "listVirtualServers", new Object[]{null}, new String[]{"java.lang.String"});
        if (vsObjectNames != null) {
            for (int i = 0; i < vsObjectNames.length; ++i) {
                String id = (String)MBeanUtil.getAttribute(vsObjectNames[i], "id");
                if (id.equals("__asadmin")) continue;
                vsId = id;
                break;
            }
        }
        return vsId;
    }

    private String getPortForApplication(String appName) {
        String listener;
        ObjectName appRef = (ObjectName)MBeanUtil.invoke("ias:type=server,name=server,category=config", "getApplicationRefByRef", new Object[]{appName}, new String[]{"java.lang.String"});
        String vsId = null;
        if (appRef == null) {
            vsId = this.getNonAdminVirtualServer();
        } else {
            vsId = (String)MBeanUtil.getAttribute(appRef, "virtual-servers");
            if (vsId == null || vsId.length() == 0) {
                vsId = this.getNonAdminVirtualServer();
            } else if (vsId.indexOf(",") > 0) {
                vsId = vsId.substring(0, vsId.indexOf(","));
            }
        }
        if (vsId == null) {
            return null;
        }
        String port = null;
        ObjectName vsObjectName = (ObjectName)MBeanUtil.invoke("ias:type=configs,category=config", "getVirtualServer", new Object[]{vsId, null}, new String[]{"java.lang.String", "java.lang.String"});
        if (vsObjectName != null && (listener = (String)MBeanUtil.getAttribute(vsObjectName, "http-listeners")) != null) {
            if (listener.indexOf(",") > 0) {
                listener = listener.substring(0, listener.indexOf(","));
            }
            ObjectName listenerObjectName = (ObjectName)MBeanUtil.invoke("ias:type=configs,category=config", "getHttpListener", new Object[]{listener, null}, new String[]{"java.lang.String", "java.lang.String"});
            port = (String)MBeanUtil.getAttribute(listenerObjectName, "port");
        }
        return port;
    }

    private String addProp(String tag, String addText) {
        int i = tag.indexOf(32);
        if (i < 0) {
            return tag;
        }
        String text = tag.substring(0, i) + " " + addText + tag.substring(i, tag.length());
        return text;
    }

    private String removeProp(String tag, String prop) {
        int i = tag.indexOf(prop);
        if (i < 0) {
            return tag;
        }
        int j = tag.indexOf(34, i + 2 + prop.length());
        if (j < 0) {
            return tag;
        }
        String text = "";
        text = prop.equals("onclick") ? tag.substring(0, i) + tag.substring(j + 1, tag.length()) : tag.substring(0, i) + tag.substring(j + 2, tag.length());
        return text;
    }

    public static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    protected String getHost(ObjectName serverInstance) {
        String nodeAgentRef = (String)MBeanUtil.getAttribute(serverInstance, "node-agent-ref");
        if (nodeAgentRef == null || nodeAgentRef.equals("")) {
            return DeploymentHandler.getDefaultHostName();
        }
        ObjectName jmxConnector = (ObjectName)MBeanUtil.invoke("com.sun.appserv:type=node-agent,name=" + nodeAgentRef + ",category=config", "getJmxConnector", null, null);
        if (jmxConnector == null) {
            return DeploymentHandler.getDefaultHostName();
        }
        AttributeList properties = (AttributeList)MBeanUtil.invoke(jmxConnector, "getProperties", null, null);
        String hostName = null;
        for (Attribute att : properties) {
            if (!att.getName().equals("client-hostname")) continue;
            hostName = (String)att.getValue();
            break;
        }
        if (hostName == null || hostName.equals("") || hostName.equals("0.0.0.0")) {
            return DeploymentHandler.getDefaultHostName();
        }
        return hostName;
    }

    protected String replaceTokens(ObjectName serverInstance, String src) {
        int idx = src.lastIndexOf("${");
        if (idx < 0) {
            return src;
        }
        Properties sysProp = (Properties)MBeanUtil.invoke(serverInstance, "listSystemProperties", new Object[]{new Boolean(DEFAULT_FORCE)}, new String[]{"boolean"});
        while (idx > -1) {
            String newString;
            int endIdx = src.indexOf("}", idx + 2);
            src = newString = src.substring(0, idx) + sysProp.getProperty(src.substring(idx + 2, endIdx)) + src.substring(endIdx + 1);
            idx = src.lastIndexOf("${");
        }
        return src;
    }

    protected List getURLs(String appId, ObjectName serverInstance) {
        String configRef = (String)MBeanUtil.getAttribute(serverInstance, "config-ref");
        String name = (String)MBeanUtil.getAttribute(serverInstance, NAME);
        String appObj = "com.sun.appserv:type=application-ref,ref=" + appId + ",server=" + name + ",category=config";
        String strVirServers = (String)MBeanUtil.getAttribute(appObj, "virtual-servers");
        if (strVirServers == null || strVirServers.equals("")) {
            int count;
            ObjectName[] listeners = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=http-service,config=" + configRef + ",category=config", "getHttpListener", null, null);
            for (count = 0; count < listeners.length && !((String)MBeanUtil.getAttribute(listeners[count], "enabled")).equals(DEFAULT_FORCE); ++count) {
            }
            if (count == listeners.length) {
                return new ArrayList(0);
            }
            strVirServers = (String)MBeanUtil.getAttribute(listeners[count], "default-virtual-server");
        }
        ArrayList<String> listenerList = new ArrayList<String>();
        for (String virServer : Util.parseStringList(strVirServers, " ,")) {
            String listeners = (String)MBeanUtil.getAttribute("com.sun.appserv:type=virtual-server,id=" + virServer + ",config=" + configRef + ",category=config", "http-listeners");
            for (String listener : Util.parseStringList(listeners, " ,")) {
                if (listenerList.contains(listener)) continue;
                listenerList.add(listener);
            }
        }
        ArrayList<String> urls = new ArrayList<String>(listenerList.size());
        StringBuffer url = null;
        Iterator it = listenerList.iterator();
        while (it.hasNext()) {
            String listenerObj = "com.sun.appserv:type=http-listener,id=" + it.next() + ",config=" + configRef + ",category=config";
            url = new StringBuffer("http");
            if (MBeanUtil.getAttribute(listenerObj, "security-enabled").toString().equals(DEFAULT_FORCE)) {
                url.append("s");
            }
            url.append("://");
            url.append(this.getHost(serverInstance));
            url.append(":");
            url.append(this.replaceTokens(serverInstance, (String)MBeanUtil.getAttribute(listenerObj, "port")));
            url.append("/");
            urls.add(url.toString());
        }
        return urls;
    }

    protected List getURLs(String appId, ObjectName[] serverInstances) {
        ArrayList urls = new ArrayList();
        for (int count = 0; count < serverInstances.length; ++count) {
            if (serverInstances[count].getKeyProperty(TYPE).equals("cluster")) {
                urls.addAll(this.getURLs(appId, (ObjectName[])MBeanUtil.invoke(serverInstances[count], "listServerInstances", null, null)));
                continue;
            }
            urls.addAll(this.getURLs(appId, serverInstances[count]));
        }
        return urls;
    }

    protected ObjectName[] getWebAppReferencees(String appId) {
        return (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "listReferencees", new Object[]{appId}, new String[]{"java.lang.String"});
    }

    public String getWebAppHrefs(RequestContext ctx, HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("appId");
        String appendUrl = (String)handlerCtx.getInputValue("appendUrl");
        if (appendUrl != null) {
            appendUrl = appendUrl.startsWith("/") ? appendUrl.substring(1) : appendUrl;
        }
        List urls = this.getURLs(id, this.getWebAppReferencees(id));
        DefaultModel model = (DefaultModel)handlerCtx.getInputValue("model");
        if (model != null) {
            model.clear();
        }
        StringBuffer output = new StringBuffer("");
        Iterator it = urls.iterator();
        String url = null;
        while (it.hasNext()) {
            url = (String)it.next();
            url = url + appendUrl;
            output.append("<A href=\"" + url + "\" target=\"_blank\">" + url + "</A><BR>");
            model.appendRow();
            model.setValue("link", (Object)url);
        }
        return output.toString();
    }

    public void getApplicationStatusSummary(RequestContext ctx, HandlerContext handlerCtx) {
        String appsName = (String)handlerCtx.getInputValue("appsName");
        int status = this.getAppStatusSummary(appsName);
        String result = this.convertStatusSummary(status);
        if (result == null) {
            result = "false";
            Util.logWARNING("======= Error in getting enabled status for '" + appsName + "'");
        }
        handlerCtx.setOutputValue("value", (Object)result);
    }

    public void getResourceStatusSummary(RequestContext ctx, HandlerContext handlerCtx) {
        String resObj = (String)handlerCtx.getInputValue("resObjectName");
        try {
            int status = this.getResourceStatusSummary(new ObjectName(resObj));
            String result = this.convertStatusSummary(status);
            handlerCtx.setOutputValue("value", (Object)result);
        }
        catch (Exception ex) {
            throw new FrameworkException("error in getResourceStatusSummary ", (Throwable)ex);
        }
    }

    public void getRealTargetStatus(RequestContext ctx, HandlerContext handlerCtx) {
        String appsName = (String)handlerCtx.getInputValue("appsName");
        String target = (String)handlerCtx.getInputValue(TARGET);
        String status = this.getRealTargetStatus(appsName, target);
        handlerCtx.setOutputValue("value", (Object)status);
    }

    private String getRealTargetStatus(String appsName, Object target) {
        try {
            String enabled = DeploymentHandler.getAppStatus(appsName, "domain");
            if ("false".equals(enabled)) {
                return "false";
            }
            if (target instanceof ObjectName) {
                return (String)MBeanUtil.getAttribute((ObjectName)target, "enabled");
            }
            return DeploymentHandler.getAppStatus(appsName, (String)target);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void getRealResourceTargetStatus(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            String refsObjectName = (String)handlerCtx.getInputValue("refsObjectName");
            ObjectName refsObject = new ObjectName(refsObjectName);
            String status = this.getRealResourceTargetStatus(refsObject);
            handlerCtx.setOutputValue("value", (Object)status);
        }
        catch (Exception ex) {
            throw new FrameworkException("Error in getRealResourceTargetStatus ", (Throwable)ex);
        }
    }

    public void saveStatusPE(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            ObjectName objectName = new ObjectName((String)handlerCtx.getInputValue("objectName"));
            ObjectName refObjectName = new ObjectName((String)handlerCtx.getInputValue("refObjectName"));
            String value = (String)handlerCtx.getInputValue("value");
            if (refObjectName.getKeyProperty(TYPE).equals("application-ref") && !objectName.getKeyProperty(TYPE).equals("mbean")) {
                DeploymentHandler.changeEnableStatus(objectName.getKeyProperty(NAME), new String[]{"server"}, value);
            } else {
                MBeanUtil.setAttribute(objectName, new Attribute("enabled", DEFAULT_FORCE));
                MBeanUtil.setAttribute(refObjectName, new Attribute("enabled", value));
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    private String getRealResourceTargetStatus(ObjectName refsObject) {
        String resName = refsObject.getKeyProperty("ref");
        String resType = (String)MBeanUtil.invoke("com.sun.com.sun.appserv:type=resources,category=config", "getResourceType", (Object[])new String[]{resName}, new String[]{"java.lang.String"});
        try {
            ObjectName obj = new ObjectName("com.sun.appserv:category=config,type=" + resType + ",jndi-name=" + resName);
            String status = (String)MBeanUtil.getAttribute(obj, "enabled");
            if (DEFAULT_FORCE.equals(status)) {
                status = (String)MBeanUtil.getAttribute(refsObject, "enabled");
            }
            return status;
        }
        catch (Exception ex) {
            throw new FrameworkException("Error in getRealResourceTargetStatus", (Throwable)ex);
        }
    }

    private int getAppStatusSummary(String appsObjName) {
        ObjectName[] refs = null;
        int count = 0;
        try {
            String appsName = (String)MBeanUtil.getAttribute(appsObjName, NAME);
            boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
            if (!isTargetSupported) {
                ObjectName server = new ObjectName("com.sun.appserv:type=server,name=server,category=config");
                refs = new ObjectName[]{server};
            } else {
                Object[] params = new String[]{appsName};
                String[] types = new String[]{"java.lang.String"};
                refs = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "listReferencees", params, types);
                if (refs.length == 0) {
                    return -2;
                }
            }
            String status = DeploymentHandler.getAppStatus(appsName, ConfigProperties.getInstance().getDefaultTarget());
            if ("false".equals(status)) {
                return 0;
            }
            for (int i = 0; i < refs.length; ++i) {
                Object[] params = new String[]{appsName};
                String[] types = new String[]{"java.lang.String"};
                ObjectName appRefsObj = (ObjectName)MBeanUtil.invoke(refs[i], "getApplicationRefByRef", params, types);
                String refStatus = (String)MBeanUtil.getAttribute(appRefsObj, "enabled");
                if (!DEFAULT_FORCE.equals(refStatus)) continue;
                ++count;
            }
            if (count == refs.length) {
                return -1;
            }
            return count;
        }
        catch (Exception ex) {
            Util.logSEVERE(ex);
            return -3;
        }
    }

    private int getResourceStatusSummary(ObjectName resObject) {
        String resName = resObject.getKeyProperty("jndi-name");
        int count = 0;
        Object[] params = new String[]{resName};
        String[] types = new String[]{"java.lang.String"};
        ObjectName[] refs = null;
        boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        try {
            if (!isTargetSupported) {
                ObjectName server = new ObjectName("com.sun.appserv:type=server,name=server,category=config");
                refs = new ObjectName[]{server};
            } else {
                refs = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "listReferencees", params, types);
                if (refs.length == 0) {
                    return -2;
                }
            }
            String status = (String)MBeanUtil.getAttribute(resObject, "enabled");
            if ("false".equals(status)) {
                return 0;
            }
            for (int i = 0; i < refs.length; ++i) {
                ObjectName resRefsObj = (ObjectName)MBeanUtil.invoke(refs[i], "getResourceRefByRef", params, types);
                String refStatus = (String)MBeanUtil.getAttribute(resRefsObj, "enabled");
                if (!DEFAULT_FORCE.equals(refStatus)) continue;
                ++count;
            }
            if (count == refs.length) {
                return -1;
            }
            return count;
        }
        catch (Exception ex) {
            Util.logWARNING(ex);
            return -3;
        }
    }

    private String convertStatusSummary(int statusSummary) {
        String disp = null;
        boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        disp = statusSummary == -3 ? (isTargetSupported ? Util.getMessage("deploy.unknown") : "false") : (statusSummary == -1 ? (isTargetSupported ? Util.getMessage("deploy.allEnabled") : DEFAULT_FORCE) : (statusSummary == 0 ? (isTargetSupported ? Util.getMessage("deploy.allDisabled") : "false") : (statusSummary == -2 ? (isTargetSupported ? Util.getMessage("deploy.noTarget") : DEFAULT_FORCE) : (isTargetSupported ? Util.getMessage("deploy.someEnabled", new String[]{"" + statusSummary}) : DEFAULT_FORCE))));
        return disp;
    }

    public void loadMbeanAttrTable(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            desc = descView.getViewDescriptor();
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        if (model == null) {
            throw new FrameworkException("loadCallFlowDataTable: No Model Specified.", desc, handlerCtx.getView());
        }
        String implClass = (String)handlerCtx.getInputValue("implClass");
        Boolean create = (Boolean)handlerCtx.getInputValue("create");
        Object[] params = new Object[]{implClass};
        String[] types = new String[]{"java.lang.String"};
        MBeanInfo mbinfo = (MBeanInfo)MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getMBeanInfo", params, types);
        MBeanAttributeInfo[] attrArray = mbinfo.getAttributes();
        if (attrArray == null || attrArray.length < 0) {
            return;
        }
        AttributeList attrList = null;
        if (!create.booleanValue()) {
            String objName = (String)handlerCtx.getInputValue("mbeanObjectName");
            attrList = (AttributeList)MBeanUtil.invoke(objName, "getProperties", null, null);
        }
        ((DefaultModel)model).clear();
        try {
            model.beforeFirst();
            for (int i = 0; i < attrArray.length; ++i) {
                String val;
                model.appendRow();
                String name = attrArray[i].getName();
                model.setValue(PROPERTY_NAME, (Object)name);
                model.setValue(TYPE, (Object)attrArray[i].getType());
                if (create.booleanValue() || (val = this.getMbeanPropertyValue(attrList, name)) == null) continue;
                model.setValue(PROPERTY_VALUE, (Object)val);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    private String getMbeanPropertyValue(AttributeList attrList, String name) {
        if (attrList == null) {
            return null;
        }
        for (Attribute att : attrList) {
            if (!att.getName().equals(name)) continue;
            return (String)att.getValue();
        }
        return null;
    }

    public void getMbeanAttrFromTable(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        Boolean ignoreEmptyValues = (Boolean)handlerCtx.getInputValue("ignoreEmptyValues");
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        model.beforeFirst();
        Properties properties = new Properties();
        while (model.next()) {
            String name = (String)model.getValue(PROPERTY_NAME);
            String value = (String)model.getValue(PROPERTY_VALUE);
            if (Util.isEmpty(name) || Util.isEmpty(value) && ignoreEmptyValues != null && ignoreEmptyValues.booleanValue()) continue;
            properties.setProperty(name, value);
        }
        handlerCtx.setOutputValue("properties", (Object)properties);
    }
}

