/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.event;

import com.sun.enterprise.tools.jsfext.layout.LayoutDefinitionManager;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

public class CommandActionListener
implements Serializable {
    public static final String COMMAND_HANDLERS = "command";

    public void invokeCommandHandlers(ActionEvent event) {
        UIComponent command = (UIComponent)event.getSource();
        if (command == null) {
            throw new IllegalArgumentException("Action invoked, however, no source was given!");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LayoutElement desc = null;
        List handlers = (List)command.getAttributes().get(COMMAND_HANDLERS);
        if (handlers != null && handlers.size() > 0) {
            desc = new LayoutComponent(null, command.getId(), null);
            desc.setHandlers(COMMAND_HANDLERS, handlers);
        } else {
            String viewId = CommandActionListener.getViewId(command);
            desc = CommandActionListener.findLayoutElementByClientId(context, viewId, command.getClientId(context));
            if (desc == null) {
                desc = CommandActionListener.findLayoutElementById(context, viewId, command.getId());
            }
        }
        if (desc == null) {
            throw new IllegalArgumentException("Unable to locate handlers for '" + command.getClientId(context) + "'.");
        }
        desc.dispatchHandlers(context, COMMAND_HANDLERS, (EventObject)event);
    }

    public static String getViewId(UIComponent comp) {
        String result = null;
        while (comp != null && !(comp instanceof UIViewRoot)) {
            comp = comp.getParent();
        }
        if (comp != null) {
            result = ((UIViewRoot)comp).getViewId();
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(FacesContext ctx, String layoutDefKey, String clientId) {
        LayoutElement result = null;
        try {
            result = CommandActionListener.findLayoutElementByClientId(LayoutDefinitionManager.getManager(ctx).getLayoutDefinition(layoutDefKey), clientId);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(LayoutDefinition def, String clientId) {
        return null;
    }

    public static LayoutElement findLayoutElementById(FacesContext ctx, String layoutDefKey, String id) {
        if (id == null) {
            return null;
        }
        LayoutElement result = null;
        try {
            result = CommandActionListener.findLayoutElementById(LayoutDefinitionManager.getManager(ctx).getLayoutDefinition(layoutDefKey), id);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return result;
    }

    public static LayoutElement findLayoutElementById(LayoutElement elt, String id) {
        if (elt.getUnevaluatedId().equals(id)) {
            return elt;
        }
        LayoutElement child2 = null;
        for (LayoutElement child2 : elt.getChildLayoutElements()) {
            if (!(child2 instanceof LayoutComponent) || (child2 = CommandActionListener.findLayoutElementById(child2, id)) == null) continue;
            return child2;
        }
        return null;
    }
}

