/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.ClientSession;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.SQLConnectionManager;
import com.iplanet.jato.SQLConnectionManagerBase;
import com.iplanet.jato.ViewBeanManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestContextImpl
implements RequestContext {
    public static final String FLAG_RESPONSE_STARTED = "jato.responseStarted";
    private String servletName;
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ViewBeanManager viewBeanManager;
    private ModelManager modelManager;
    private SQLConnectionManager sqlConnectionManager;
    private StringWriter messageStringWriter;
    private PrintWriter messageWriter;
    private Map requestCompletionListeners;
    private ClientSession clientSession;

    public RequestContextImpl() {
    }

    public RequestContextImpl(String servletName, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletName = servletName;
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ViewBeanManager getViewBeanManager() {
        return this.viewBeanManager;
    }

    public void setViewBeanManager(ViewBeanManager value) {
        this.viewBeanManager = value;
    }

    public ModelManager getModelManager() {
        if (this.modelManager == null) {
            this.modelManager = new ModelManager(this);
        }
        return this.modelManager;
    }

    public void setModelManager(ModelManager value) {
        this.modelManager = value;
    }

    public SQLConnectionManager getSQLConnectionManager() {
        if (this.sqlConnectionManager == null) {
            this.sqlConnectionManager = new SQLConnectionManagerBase();
        }
        return this.sqlConnectionManager;
    }

    public void setSQLConnectionManager(SQLConnectionManager value) {
        this.sqlConnectionManager = value;
    }

    public PrintWriter getMessageWriter() {
        if (this.messageWriter == null) {
            if (this.messageStringWriter == null) {
                this.messageStringWriter = new StringWriter();
            }
            this.messageWriter = new PrintWriter(this.messageStringWriter);
        }
        return this.messageWriter;
    }

    public boolean hasMessages() {
        return this.messageWriter != null;
    }

    public StringBuffer getMessageBuffer() {
        if (this.messageStringWriter == null) {
            return new StringBuffer();
        }
        if (this.hasMessages()) {
            this.messageWriter.flush();
        }
        return this.messageStringWriter.getBuffer();
    }

    public void addRequestCompletionListener(RequestCompletionListener listener) {
        if (listener != null) {
            if (this.requestCompletionListeners == null) {
                this.requestCompletionListeners = new HashMap();
            }
            this.requestCompletionListeners.put(listener, listener);
        }
    }

    public void removeRequestCompletionListener(RequestCompletionListener listener) {
        if (listener != null && this.requestCompletionListeners != null) {
            this.requestCompletionListeners.remove(listener);
        }
    }

    protected void notifyRequestCompletionListeners() {
        if (this.requestCompletionListeners != null) {
            Iterator i = this.requestCompletionListeners.keySet().iterator();
            while (i.hasNext()) {
                ((RequestCompletionListener)i.next()).requestComplete();
            }
        }
    }

    public int getRequestPhase() {
        if (this.getRequest().getAttribute(FLAG_RESPONSE_STARTED) != null) {
            return 2;
        }
        return 1;
    }

    public ClientSession getClientSession() {
        if (this.clientSession == null) {
            this.clientSession = new ClientSession(this);
        }
        return this.clientSession;
    }

    public static void markResponseStarted(RequestContext requestContext) {
        requestContext.getRequest().setAttribute(FLAG_RESPONSE_STARTED, (Object)new Boolean(true));
    }

    static {
        FLAG_RESPONSE_STARTED = FLAG_RESPONSE_STARTED;
    }
}

