/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContextBase;

public class DatasetModelExecutionContextImpl
extends ModelExecutionContextBase
implements DatasetModelExecutionContext {
    private int datasetOffset = 0;
    private int datasetSize = -2;

    public DatasetModelExecutionContextImpl() {
        this.setOperationName("retrieve");
    }

    public DatasetModelExecutionContextImpl(String operationName) {
        this.setOperationName(operationName);
    }

    public DatasetModelExecutionContextImpl(int datasetOffset, int datasetSize) {
        this.setDatasetOffset(datasetOffset);
        this.setDatasetSize(datasetSize);
        this.setOperationName("retrieve");
    }

    public DatasetModelExecutionContextImpl(String operationName, int datasetOffset, int datasetSize) {
        this.setDatasetOffset(datasetOffset);
        this.setDatasetSize(datasetSize);
        this.setOperationName(operationName);
    }

    public int getDatasetOffset() {
        return this.datasetOffset;
    }

    public void setDatasetOffset(int value) {
        if (this.datasetOffset < 0) {
            throw new IllegalArgumentException("Result offset must be greater than zero (value = " + value + ")");
        }
        this.datasetOffset = value;
    }

    public int getDatasetSize() {
        return this.datasetSize;
    }

    public void setDatasetSize(int value) {
        this.datasetSize = value;
    }

    public static int calculatePaginationOffset(DatasetModel model, DatasetModelExecutionContext context) throws ModelControlException {
        int requestedOffset = 0;
        if (context != null) {
            requestedOffset = context.getDatasetOffset();
        }
        int requestedNumRows = -1;
        if (context != null) {
            if (context.getDatasetSize() == -2) {
                throw new IllegalArgumentException("DatasetModelExecutionContext property 'DatasetSize' may not be DATASET_SIZE_ALL_INCREMENTAL when calling this method");
            }
            requestedNumRows = context.getDatasetSize();
        }
        int newOffset = 0;
        int size = model.getSize();
        if (size == 0 || 0 == requestedOffset) {
            newOffset = 0;
        } else if (-1 == requestedOffset) {
            if (size >= requestedNumRows) {
                newOffset = size - requestedNumRows;
            }
        } else if (size < requestedOffset + 1) {
            if (model.getLocationOffset() < size && model.getLocationOffset() + requestedNumRows >= size) {
                newOffset = model.getLocationOffset();
            } else if (requestedNumRows < size) {
                newOffset = size - requestedNumRows;
            }
        } else {
            newOffset = requestedOffset;
        }
        return newOffset;
    }
}

