/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.object;

import com.iplanet.jato.Log;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.DatasetModelExecutionContextImpl;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.InvalidDatasetException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.ModelFieldGroup;
import com.iplanet.jato.model.MultiDatasetModel;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.object.KeyMappings;
import com.iplanet.jato.model.object.KeyPath;
import com.iplanet.jato.model.object.KeyPathFieldDescriptor;
import com.iplanet.jato.model.object.KeyTypeMappings;
import com.iplanet.jato.model.object.ObjectAdapterException;
import com.iplanet.jato.model.object.ObjectFactory;
import com.iplanet.jato.model.object.Operation;
import com.iplanet.jato.model.object.Operations;
import com.iplanet.jato.model.object.Parameter;
import com.iplanet.jato.model.object.PathContext;
import com.iplanet.jato.model.object.PathEvaluator;
import com.iplanet.jato.model.object.TypeMappings;
import com.iplanet.jato.util.ClassUtil;
import com.iplanet.jato.util.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectAdapterModel
implements MultiDatasetModel,
ExecutingModel,
RetrievingModel,
RequestParticipant,
PathContext {
    private static boolean toggleTrace = false;
    private static final boolean TRACE = true;
    private transient long _epoch = System.currentTimeMillis();
    public static final String DEFAULT_PARAMETER_NAME_BASE = "param";
    private static final boolean OPTION_USE_TYPE_CACHE = true;
    public static final int UNDEFINED_ROW_INDEX = -1;
    private static final Integer UNDEFINED_ROW_INDEX_INTEGER;
    public static final int DEFAULT_INFINITE_LOOP_CHECK_THRESHOLD = 3;
    private boolean _allowBlankOrNullValueName;
    private boolean _allowKeyMappings;
    private int _infiniteCheckThreshold;
    private transient int _infiniteCheck;
    private Map _datasetLocations;
    private Map _datasetLocationOffsets;
    private transient Map _datasetCache;
    private boolean _useDatasetCache;
    private KeyPath _currentDatasetKeyPath;
    private Object _currentDataset;
    private int _currentDatasetSize;
    private int _currentDatasetLocation;
    private int _currentDatasetLocationOffset;
    private KeyTypeMappings _keyTypeMappings;
    private transient Map _typeCache;
    private KeyMappings _keyMappings;
    private ObjectFactory _objectFactory;
    private ModelFieldGroup fieldGroup;
    private boolean _objectArray;
    private transient Object _object;
    private Class _objectType;
    private String _defaultExecuteOperationID;
    private Operations _operations;
    private TypeMappings _typeMappings;
    private transient RequestContext _requestContext;
    private String _defaultDatasetName;
    private String _name;
    private Map _localStorage;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;

    public ObjectAdapterModel() {
        this.clear();
        if (ObjectAdapterModel.isTrace()) {
            this.log("constructor", null);
        }
    }

    public RequestContext getRequestContext() {
        return this._requestContext;
    }

    public void setRequestContext(RequestContext value) {
        if (ObjectAdapterModel.isTrace()) {
            this.log("setRequestContext", null);
        }
        this._requestContext = value;
        if (ObjectAdapterModel.isTrace()) {
            this._epoch = System.currentTimeMillis();
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Object getValue(String name) {
        KeyPathFieldDescriptor field;
        if (null != name && this.getFieldGroup() != null && this.getFieldGroup().getNumFields() > 0 && null != (field = (KeyPathFieldDescriptor)this.getFieldGroup().getFieldDescriptor(name))) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getValue(" + name + ")->field-binding", field.getKeyPath());
            }
            name = field.getKeyPath();
        }
        if (name == null || name.trim().length() == 0) {
            if (this.isAllowBlankOrNullValueName()) {
                Log.log(32, "getValue(null) returning -> null; use setAllowBlankOrNullValueName(false) to have exception thrown instead");
                return null;
            }
            throw new IllegalArgumentException("name parameter cannot be null or blank");
        }
        return this.getValue(new KeyPath(name));
    }

    protected Object getValue(KeyPath keypath) {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        try {
            if (keypath.getPath().isRoot()) {
                if (ObjectAdapterModel.isTrace()) {
                    this.log("getValue", "calling getLocalValue() with keypath -> " + keypath);
                }
                Object result = this.getLocalValue(keypath.getKey());
                if (ObjectAdapterModel.isTrace()) {
                    this.log("getValue", "returning local storage -> " + result);
                }
                return result;
            }
            if (ObjectAdapterModel.isTrace()) {
                this.log("getValue", "calling eval() with keypath -> " + keypath);
            }
            Object result = this.eval(keypath);
            if (ObjectAdapterModel.isTrace()) {
                this.log("getValue", "returning evaluation -> " + result);
            }
            return result;
        }
        catch (ModelControlException mce) {
            throw new ObjectAdapterException(mce);
        }
    }

    public void setValue(String name, Object value) {
        KeyPathFieldDescriptor field;
        if (null != name && this.getFieldGroup() != null && this.getFieldGroup().getNumFields() > 0 && null != (field = (KeyPathFieldDescriptor)this.getFieldGroup().getFieldDescriptor(name))) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("setValue(" + name + ")->field-binding", field.getKeyPath());
            }
            name = field.getKeyPath();
        }
        if (name == null || name.trim().length() == 0) {
            if (this.isAllowBlankOrNullValueName()) {
                Log.log(32, "getValue(null) returning; use setAllowBlankOrNullValueName(false) to have exception thrown instead");
                return;
            }
            throw new IllegalArgumentException("name parameter cannot be null or blank");
        }
        this.setValue(new KeyPath(name), value);
    }

    protected void setValue(KeyPath keypath, Object value) {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        if (keypath.getPath().isRoot()) {
            if (keypath.getKey() == null) {
                throw new IllegalArgumentException("use setObject() to set the adapted object or call setAllowSettingOfAdaptedObject(true)");
            }
            Class type = this.getKeyPathType(keypath);
            if (type != null && !type.isInstance(value)) {
                if (ObjectAdapterModel.isTrace()) {
                    this.log("setValue", "converting value of type " + value.getClass().getName() + " to " + type.getName());
                }
                value = TypeConverter.asType(type, value);
            }
            if (ObjectAdapterModel.isTrace()) {
                this.log("setValue", "setting local storage: " + keypath.getKey() + "=" + (value == null ? "null" : value.toString()));
            }
            this.setLocalValue(keypath.getKey(), value);
            return;
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("setValue", "calling setPathValue: " + keypath + "=" + (value == null ? "null" : value.toString()));
        }
        try {
            this.setPathValue(keypath, value);
        }
        catch (ModelControlException mce) {
            throw new ObjectAdapterException(mce);
        }
    }

    public Object[] getValues(String name) {
        Object values;
        if (ObjectAdapterModel.isTrace()) {
            this.log("getValues", name);
        }
        if ((values = this.getValue(name)) != null) {
            Class<?> clzz = values.getClass();
            if (clzz.isArray()) {
                if (clzz.getComponentType().isPrimitive()) {
                    values = ClassUtil.primitiveArrayToObjectArray(values);
                }
                return (Object[])values;
            }
            if (values instanceof Collection) {
                Class collectionType = class$java$lang$Object == null ? (class$java$lang$Object = ObjectAdapterModel.class$("java.lang.Object")) : class$java$lang$Object;
                Collection temp = (Collection)values;
                if (!temp.isEmpty()) {
                    collectionType = temp.iterator().next().getClass();
                }
                return temp.toArray((Object[])Array.newInstance(collectionType, temp.size()));
            }
            return new Object[]{values};
        }
        return null;
    }

    public void setValues(String name, Object[] values) {
        if (ObjectAdapterModel.isTrace()) {
            this.log("setValues", name);
        }
        this.setValue(name, (Object)values);
    }

    public int getSize() throws ModelControlException {
        this.ensureCurrentDataset();
        return this._currentDatasetSize;
    }

    public void setSize(int value) throws ModelControlException {
        throw new ModelControlException("operation not supported");
    }

    public int getLocationOffset() throws ModelControlException {
        this.ensureCurrentDataset();
        return this._currentDatasetLocationOffset;
    }

    protected void setLocationOffset(int value) throws ModelControlException {
        this.ensureCurrentDataset();
        this._currentDatasetLocationOffset = value;
        this.getDatasetLocationOffsets().put(this._currentDatasetKeyPath.toString(), new Integer(value));
    }

    public int getLocation() throws ModelControlException {
        this.ensureCurrentDataset();
        return this._currentDatasetLocation;
    }

    public void setLocation(int location) throws ModelControlException {
        if (ObjectAdapterModel.isTrace()) {
            this.log("setLocation", "" + location);
        }
        this.setCurrentDatasetRowIndex(location);
    }

    public void beforeFirst() throws ModelControlException {
        if (ObjectAdapterModel.isTrace()) {
            this.log("beforeFirst", null);
        }
        this.setCurrentDatasetRowIndex(this.getLocationOffset() - 1);
    }

    public boolean first() throws ModelControlException {
        if (ObjectAdapterModel.isTrace()) {
            this.log("first", null);
        }
        this.setCurrentDatasetRowIndex(this.getLocationOffset());
        return true;
    }

    public boolean next() throws ModelControlException {
        this.ensureCurrentDataset();
        if (this._currentDatasetSize - 1 == this._currentDatasetLocation) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("next", "false");
            }
            return false;
        }
        this.setCurrentDatasetRowIndex(this._currentDatasetLocation + 1);
        if (ObjectAdapterModel.isTrace()) {
            this.log("next", "true");
        }
        return true;
    }

    public boolean previous() throws ModelControlException {
        this.ensureCurrentDataset();
        if (this._currentDatasetLocation < 1) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("previous", "false");
            }
            return false;
        }
        this.setCurrentDatasetRowIndex(this._currentDatasetLocation - 1);
        if (ObjectAdapterModel.isTrace()) {
            this.log("next", "true");
        }
        return true;
    }

    public boolean last() throws ModelControlException {
        this.ensureCurrentDataset();
        this.setCurrentDatasetRowIndex(this._currentDatasetSize - 1);
        if (ObjectAdapterModel.isTrace()) {
            this.log("last", "" + (this._currentDatasetSize - 1));
        }
        return true;
    }

    public String getCurrentDatasetName() {
        if (null == this._currentDatasetKeyPath) {
            if (null == this.getDefaultDatasetName() || this.getDefaultDatasetName().trim().length() == 0) {
                return null;
            }
            this.setCurrentDatasetName(this.getDefaultDatasetName());
        }
        return this._currentDatasetKeyPath.toString();
    }

    public void setCurrentDatasetName(String name) throws InvalidDatasetException {
        this.setCurrentDatasetName(name, false);
    }

    protected void setCurrentDatasetName(String name, boolean force) throws InvalidDatasetException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name param may not be null or blank");
        }
        KeyPath keypath = new KeyPath(name);
        if (!force && null != this._currentDatasetKeyPath && this._currentDatasetKeyPath.toString().equals(keypath.toString())) {
            return;
        }
        if (keypath.getPath().isIndexed()) {
            throw new IllegalArgumentException("ObjectPath portion of the KeyPath derived from name parameter cannot be indexed (end in ObjectPath.INDEXED_PATH_SUFFIX)");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("setCurrentDatasetName", "name=" + name + " force=" + force);
        }
        this._currentDataset = this.findDataset(keypath);
        this._currentDatasetSize = ObjectAdapterModel.determineDatasetSize(this._currentDataset);
        this._currentDatasetKeyPath = keypath;
        this._currentDatasetLocation = this.getDatasetLocation(keypath, false);
        Integer locationOffset = (Integer)this.getDatasetLocationOffsets().get(keypath.toString());
        if (locationOffset == null) {
            locationOffset = new Integer(0);
            this.getDatasetLocationOffsets().put(keypath.toString(), locationOffset);
        }
        this._currentDatasetLocationOffset = locationOffset;
    }

    public String getDefaultDatasetName() {
        return this._defaultDatasetName;
    }

    public void setDefaultDatasetName(String value) {
        this._defaultDatasetName = value;
    }

    protected void ensureCurrentDataset() throws ModelControlException {
        if (null == this._currentDatasetKeyPath) {
            if (null == this.getDefaultDatasetName() || this.getDefaultDatasetName().trim().length() == 0) {
                throw new ModelControlException("no current dataset assigned yet");
            }
            this.setCurrentDatasetName(this.getDefaultDatasetName());
        }
    }

    protected void setCurrentDatasetRowIndex(int index) throws ModelControlException {
        this.ensureCurrentDataset();
        this.setDatasetLocation(this._currentDatasetKeyPath, index);
        this._currentDatasetLocation = index;
        if (ObjectAdapterModel.isTrace()) {
            this.log("setCurrentDatasetRowIndex", "" + index);
        }
    }

    protected boolean checkCurrentDatasetRowIndex(int index) throws ModelControlException {
        this.ensureCurrentDataset();
        return index >= 0 && index < this._currentDatasetSize;
    }

    protected boolean checkDatasetRowIndex(KeyPath keypath, int index) throws InvalidDatasetException {
        Object dataset = this.findDataset(keypath);
        if (index < 0 || index >= ObjectAdapterModel.determineDatasetSize(dataset)) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("checkDatasetRowIndex", "keypath=" + keypath + " index=" + index + " [index is negative or out of bounds for dataset " + "of size=" + ObjectAdapterModel.determineDatasetSize(dataset) + "]");
            }
            return false;
        }
        return true;
    }

    protected static int determineDatasetSize(Object dataset) throws InvalidDatasetException {
        if (null == dataset) {
            throw new IllegalArgumentException("param dataset may not be null");
        }
        if (dataset.getClass().isArray()) {
            return ((Object[])dataset).length;
        }
        if (dataset instanceof Collection) {
            return ((Collection)dataset).size();
        }
        throw new InvalidDatasetException("param dataset is neither an array nor Collection but rather a " + dataset.getClass().getName());
    }

    protected void setDatasetLocation(KeyPath keypath, int location) throws InvalidDatasetException, ModelControlException {
        if (location < 0 && location != -1) {
            throw new ModelControlException("param location must be a whole number or the value of UNDEFINED_ROW_INDEX which is -1");
        }
        int neededSize = location + 1;
        Object dataset = this.findDataset(keypath);
        int size = ObjectAdapterModel.determineDatasetSize(dataset);
        if (neededSize > size) {
            Object replacementDataset;
            if (dataset.getClass().isArray()) {
                replacementDataset = PathEvaluator.ensureArraySize((Object[])dataset, neededSize);
            } else if (dataset instanceof List) {
                replacementDataset = PathEvaluator.ensureListSize((List)dataset, neededSize);
            } else {
                throw new ModelControlException("param location=" + location + " must be within the size of the dataset " + "which is " + size + " and we cannot auto entend when its not an array or List");
            }
            this.setValue(this._currentDatasetKeyPath, replacementDataset);
            if (this.isUseDatasetCache()) {
                this.getDatasetCache().put(keypath.toString(), replacementDataset);
            }
            this._currentDataset = replacementDataset;
            this._currentDatasetSize = neededSize;
        }
        this.getDatasetLocations().put(keypath.toString(), new Integer(location));
        if (ObjectAdapterModel.isTrace()) {
            this.log("setDatasetLocation", "keypath=" + keypath + " location=" + location);
        }
    }

    protected Map getDatasetLocations() {
        if (null == this._datasetLocations) {
            this._datasetLocations = new HashMap();
        }
        return this._datasetLocations;
    }

    protected Map getDatasetLocationOffsets() {
        if (null == this._datasetLocationOffsets) {
            this._datasetLocationOffsets = new HashMap();
        }
        return this._datasetLocationOffsets;
    }

    protected int getDatasetLocation(KeyPath keypath, boolean validate) throws InvalidDatasetException {
        Integer location;
        if (validate) {
            this.findDataset(keypath);
        }
        if ((location = (Integer)this.getDatasetLocations().get(keypath.toString())) == null) {
            location = UNDEFINED_ROW_INDEX_INTEGER;
            this.getDatasetLocations().put(keypath.toString(), location);
        }
        return location;
    }

    protected Object findDataset(KeyPath keypath) throws InvalidDatasetException {
        Object dataset = this.getDataset(keypath, true);
        if (null == dataset) {
            throw new InvalidDatasetException("dataset is unavailable for keypath=" + keypath);
        }
        return dataset;
    }

    protected Object getDataset(KeyPath keypath) throws InvalidDatasetException {
        return this.getDataset(keypath, false);
    }

    protected Object getDataset(KeyPath keypath, boolean ensure) throws InvalidDatasetException {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        Object result = null;
        if (this.isUseDatasetCache()) {
            result = this.getDatasetCache().get(keypath.toString());
            if (ObjectAdapterModel.isTrace() && null != result) {
                this.log("getDataset", "dataset cache hit for keypath=" + keypath);
            }
        }
        if (null == result && keypath.getKey() == null && keypath.getPath().isRoot()) {
            try {
                result = this.getObject();
            }
            catch (ModelControlException mce) {
                throw new InvalidDatasetException("keypath=" + keypath + " cannot acquire root object ", mce);
            }
        }
        if (null == result && null == (result = this.getValue(keypath)) && ensure) {
            PathEvaluator temp;
            if (ObjectAdapterModel.isTrace()) {
                this.log("getDataset", "dataset=" + keypath + " does not exist so we are building it");
            }
            try {
                temp = this.createPathEvaluator(keypath);
            }
            catch (ModelControlException mce) {
                throw new InvalidDatasetException("keypath=" + keypath + " cannot create PathEvaluator ", mce);
            }
            result = temp.eval(keypath.getPath(), true);
        }
        if (null == result) {
            return result;
        }
        if (result.getClass().isArray()) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getDataset", "keypath=" + keypath + " results in array[" + ((Object[])result).length + "]");
            }
        } else if (result instanceof Collection) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getDataset", "keypath=" + keypath + " results in collection{" + result.getClass().getName() + "}[" + ((Collection)result).size() + "]");
            }
        } else {
            throw new InvalidDatasetException("keypath=" + keypath + " results in non-array and non-collection of type " + result.getClass().getName());
        }
        if (this.isUseDatasetCache()) {
            this.getDatasetCache().put(keypath.toString(), result);
        }
        return result;
    }

    public boolean isUseDatasetCache() {
        return this._useDatasetCache;
    }

    public void setUseDatasetCache(boolean flag) {
        this._useDatasetCache = flag;
    }

    protected Map getDatasetCache() {
        if (this._datasetCache == null) {
            this._datasetCache = new HashMap();
        }
        return this._datasetCache;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        if (ObjectAdapterModel.isTrace()) {
            this.log("execute", "op=" + (context != null ? context.getOperationName() : "default=" + this.getDefaultExecuteOperationID()));
        }
        String opID = this.getDefaultExecuteOperationID();
        if (context != null) {
            opID = context.getOperationName();
        }
        if (opID == null || opID.trim().length() == 0) {
            throw new ModelControlException("operation identifier may not be null or blank; see getDefaultExecuteOperationID()");
        }
        Operation opDesc = this.getOperations().getOperation(opID);
        if (opDesc == null) {
            if (opID.equals("retrieve")) {
                return this.retrieve(context);
            }
            throw new ModelControlException("No operation found for operation ID \"" + opID + "\"");
        }
        Object[] params = this.getOperationParameters(opDesc);
        if (ObjectAdapterModel.isTrace()) {
            Parameter[] parameters = opDesc.getParameters();
            int i = 0;
            while (i < parameters.length) {
                this.log("execute", "param[" + i + "]{" + parameters[i].getName() + "}={" + params[i] + "}[" + (null == params[i] ? "" : params[i].getClass().getName()) + "]");
                ++i;
            }
        }
        try {
            Object result = this.getMethod(opDesc).invoke(this.getObject(), params);
            String key = opID + "." + "RESULT";
            this.setLocalValue(key, result);
            return result;
        }
        catch (Exception ex) {
            throw new ModelControlException("ObjectAdapterModel.execute(ModelExecutionContext): Unable to execute method: " + opDesc.getOperationName(), ex);
        }
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        if (context != null && context instanceof DatasetModelExecutionContext && this.getCurrentDatasetName() != null) {
            this.setLocationOffset(DatasetModelExecutionContextImpl.calculatePaginationOffset(this, (DatasetModelExecutionContext)context));
        }
        return null;
    }

    protected PathEvaluator createPathEvaluator(KeyPath keypath) throws ModelControlException {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("createPathEvaluator", keypath.toString());
        }
        if (keypath.getKey() == null) {
            return new PathEvaluator(this, this.getObject());
        }
        Object localObj = this.getLocalValue(keypath.getKey());
        if (null == localObj) {
            Class localObjType = this.getJavaType(new KeyPath(keypath.getKey(), (String)null));
            if (null == localObjType) {
                throw new ModelControlException("Unable to determine Class Type for localStorage key=" + keypath.getKey() + "   please check that you have" + " all the necessary KeyTypeMappings");
            }
            try {
                localObj = ClassUtil.instantiate(localObjType);
                this.setLocalValue(keypath.getKey(), localObj);
            }
            catch (InstantiationException ex) {
                throw new ModelControlException("Unable to create local storage object.", ex);
            }
        }
        return new PathEvaluator(this, localObj, keypath.getKey());
    }

    protected Object eval(KeyPath keypath) throws ModelControlException {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("eval", "keypath=" + keypath.toString());
        }
        if (keypath.getKey() == null && keypath.getPath().isRoot()) {
            return this.getObject();
        }
        PathEvaluator pathEval = this.createPathEvaluator(keypath);
        Object result = pathEval.eval(keypath.getPath());
        return result;
    }

    protected void setPathValue(KeyPath keypath, Object value) throws ModelControlException {
        if (null == keypath) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("setPathValue", "keypath=" + keypath.toString() + "value=" + (value == null ? "null" : value.toString()));
        }
        if (keypath.getKey() == null && keypath.getPath().isRoot()) {
            throw new IllegalArgumentException("param keypath may refer to root object; the root object should be set using setObject()");
        }
        PathEvaluator pathEval = this.createPathEvaluator(keypath);
        pathEval.setValue(keypath.getPath(), value);
    }

    public int getIndex(KeyPath keypath) throws InvalidDatasetException, ModelControlException {
        if (keypath == null) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        if (!keypath.getPath().isIndexed()) {
            throw new IllegalArgumentException("ObjectAdapterModel.getIndex(" + keypath + "): path is not indexed");
        }
        int location = this.getDatasetLocation(keypath = keypath.getUnindexedKeyPath(), true);
        if (location == -1) {
            this.setDatasetLocation(keypath, 0);
            location = 0;
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("getIndex", "keypath=" + keypath + " result=" + location);
        }
        return location;
    }

    public Class getJavaType(KeyPath keypath) throws ModelControlException {
        if (keypath == null) {
            throw new IllegalArgumentException("param keypath may not be null");
        }
        return this.getKeyPathType(keypath);
    }

    public Object getObject() throws ModelControlException {
        if (this.isObjectNull()) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getObject", "object not set yet");
            }
            this.assignObjectFromFactory();
            if (this.isObjectNull()) {
                this.setObject(this.handleObjectNotFound());
            }
        }
        return this._object;
    }

    public boolean isObjectNull() {
        return null == this._object;
    }

    protected void assignObjectFromFactory() throws ModelControlException {
        ObjectFactory factory = this.getObjectFactory();
        if (factory != null) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("assignObjectFromFactory", "trying " + this.getObjectFactory().getClass().getName());
            }
            this.setObject(factory.getObject(RequestManager.getRequestContext()));
        }
    }

    protected Object handleObjectNotFound() throws ModelControlException {
        throw new ModelControlException("model 'Object' not available");
    }

    public void setObject(Object obj) {
        if (obj != null && this._objectType != null) {
            Class<?> offeredType;
            if ((class$java$util$Collection == null ? (class$java$util$Collection = ObjectAdapterModel.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(obj.getClass())) {
                obj = ((Collection)obj).toArray((Object[])Array.newInstance(this._objectType, ((Collection)obj).size()));
            }
            Class<?> clazz = offeredType = obj.getClass().isArray() ? obj.getClass().getComponentType() : obj.getClass();
            if (!this._objectType.isAssignableFrom(offeredType)) {
                throw new IllegalArgumentException("Object parameter is not assignable to existing 'ObjectType' [" + this._objectType.getName() + "]");
            }
        }
        this._object = obj;
        if (ObjectAdapterModel.isTrace()) {
            this.log("setObject", "successful");
        }
        if (this._object != null && this._objectType == null) {
            this.setObjectType(this._object.getClass());
        }
    }

    public void setObjectTypeName(String typeName) {
        this.setObjectType(this.findClassFromTypeName(typeName));
        if (ObjectAdapterModel.isTrace()) {
            this.log("setObjectTypeName", this._objectType.getName());
        }
    }

    public String getObjectTypeName() {
        Class type = this.getObjectType();
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    public void setObjectType(Class type) {
        if (this._object != null && !type.isAssignableFrom(this._object.getClass())) {
            throw new ObjectAdapterException("existing model 'Object' is not assignable from type [" + type.getName() + "]");
        }
        this._objectType = type;
        if (ObjectAdapterModel.isTrace()) {
            this.log("setObjectType", this._objectType.getName());
        }
    }

    public Class getObjectType() {
        return this._objectType;
    }

    public ObjectFactory getObjectFactory() {
        return this._objectFactory;
    }

    public void setObjectFactory(ObjectFactory factory) {
        this._objectFactory = factory;
    }

    protected void setObjectArray(boolean flag) {
        this._objectArray = flag;
    }

    protected boolean isObjectArray() {
        return this._objectArray;
    }

    public KeyMappings getKeyMappings() {
        if (null == this._keyMappings) {
            this._keyMappings = new KeyMappings();
        }
        return this._keyMappings;
    }

    public void setKeyMappings(KeyMappings mappings) {
        this._keyMappings = mappings;
    }

    public String getKeyMapping(String oldKey) {
        if (this.getKeyMappings() == null || oldKey == null) {
            return null;
        }
        return this.getKeyMappings().map(oldKey);
    }

    public TypeMappings getTypeMappings() {
        if (this._typeMappings == null) {
            this._typeMappings = new TypeMappings();
        }
        return this._typeMappings;
    }

    public void setTypeMappings(TypeMappings value) {
        this._typeMappings = value;
    }

    public Class getMappedJavaType(String origType) {
        Class result;
        if (origType == null) {
            return null;
        }
        Class result2 = (Class)this.getTypeCache().get(origType);
        if (result2 != null) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getMappedJavaType", "cache hit");
            }
            return result2;
        }
        String mappedType = this.getTypeMappings().map(origType);
        if (mappedType == null) {
            mappedType = origType;
        }
        if ((result = this.findClassFromTypeName(mappedType)) != null) {
            this.getTypeCache().put(origType, result);
        }
        return result;
    }

    public KeyTypeMappings getKeyTypeMappings() {
        if (this._keyTypeMappings == null) {
            this._keyTypeMappings = new KeyTypeMappings();
        }
        return this._keyTypeMappings;
    }

    public void setKeyTypeMappings(KeyTypeMappings value) {
        this._keyTypeMappings = value;
    }

    protected Class getKeyPathType(KeyPath kp) {
        if (kp == null) {
            throw new IllegalArgumentException("ObjectAdapterModel.getKeyPathType(KeyPath): null is an invalid input for KeyPath!");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("getKeyPathType", kp.toString());
        }
        if (kp.getKey() == null && kp.getPath().isRoot()) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getKeyPathType", "returning ObjectType");
            }
            return this.getObjectType();
        }
        Class result = (Class)this.getTypeCache().get(kp.toString());
        if (result != null) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("getKeyPathType", "cache hit");
            }
            return result;
        }
        String keyPathClass = this.getKeyTypeMappings().map(kp.toString());
        if (keyPathClass == null) {
            return null;
        }
        Class result2 = this.getMappedJavaType(keyPathClass);
        this.getTypeCache().put(kp.toString(), result2);
        return result2;
    }

    protected Map getTypeCache() {
        if (this._typeCache == null) {
            this._typeCache = new HashMap();
        }
        return this._typeCache;
    }

    protected Class findClassFromTypeName(String typeName) {
        try {
            return ClassUtil.getClass(typeName);
        }
        catch (Exception ex) {
            throw new ObjectAdapterException("Unable to load class: " + typeName, ex);
        }
    }

    public void clear() {
        this._allowBlankOrNullValueName = false;
        this._allowKeyMappings = false;
        this._infiniteCheckThreshold = 3;
        this._infiniteCheck = 0;
        this._datasetLocations = null;
        this._datasetLocationOffsets = null;
        this._datasetCache = null;
        this._useDatasetCache = true;
        this._currentDatasetKeyPath = null;
        this._currentDataset = null;
        this._currentDatasetSize = -1;
        this._currentDatasetLocation = -1;
        this._currentDatasetLocationOffset = 0;
        this._objectArray = false;
        this._object = null;
        this._defaultDatasetName = null;
    }

    protected Map getLocalStorage() {
        if (this._localStorage == null) {
            this._localStorage = new HashMap();
        }
        return this._localStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getLocalValue(String key) throws ModelControlException {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("key param may not be null or blank; if you want to get the adapted object then use getOject() or getValue(\"/\")");
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("getLocalValue", key);
        }
        if (this.isAllowKeyMappings()) {
            String actualKeyPath;
            if (this.getInfiniteCheck() > this.getInfiniteCheckThreshold()) {
                ObjectAdapterException e = new ObjectAdapterException("getLocalValue() has been recursively called " + this.getInfiniteCheckThreshold() + "and an infinite recursion is suspected due to improper key " + "mappings");
            }
            if (ObjectAdapterModel.isTrace()) {
                this.log("getLocalValue", "key=" + key + " recursion=" + this.getInfiniteCheck());
            }
            if ((actualKeyPath = this.getKeyMapping(key)) != null) {
                if (ObjectAdapterModel.isTrace()) {
                    this.log("getLocalValue", "KeyMapping found: " + actualKeyPath);
                }
                try {
                    this.setInfiniteCheck(this.getInfiniteCheck() + 1);
                    Object object = this.getValue(actualKeyPath);
                    Object var5_4 = null;
                    this.setInfiniteCheck(this.getInfiniteCheck() - 1);
                    return object;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.setInfiniteCheck(this.getInfiniteCheck() - 1);
                    throw throwable;
                }
            }
        }
        return this.getLocalStorage().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocalValue(String key, Object value) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("key param may not be null or blank; if you want to set the adapted object then use setOject()");
        }
        if (this.isAllowKeyMappings()) {
            String actualKeyPath;
            if (this.getInfiniteCheck() > this.getInfiniteCheckThreshold()) {
                ObjectAdapterException e = new ObjectAdapterException("setLocalValue() has been recursively called " + this.getInfiniteCheckThreshold() + "and an infinite recursion is suspected due to improper key " + "mappings");
            }
            if (ObjectAdapterModel.isTrace()) {
                this.log("setLocalValue", "key=" + key + " recursion=" + this.getInfiniteCheck());
            }
            if ((actualKeyPath = this.getKeyMapping(key)) != null) {
                if (ObjectAdapterModel.isTrace()) {
                    this.log("setLocalValue", "KeyMapping found: " + actualKeyPath);
                }
                try {
                    this.setInfiniteCheck(this.getInfiniteCheck() + 1);
                    this.setValue(actualKeyPath, value);
                    Object var5_4 = null;
                    this.setInfiniteCheck(this.getInfiniteCheck() - 1);
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.setInfiniteCheck(this.getInfiniteCheck() - 1);
                    throw throwable;
                }
            }
        }
        if (ObjectAdapterModel.isTrace()) {
            this.log("setLocalValue", "key=" + key + " currentDatasetName=" + this.getCurrentDatasetName());
        }
        this.getLocalStorage().put(key, value);
        String changedKey = new KeyPath(key, (String)null).toString();
        if (this.isUseDatasetCache()) {
            this.cleanCache(this.getDatasetCache(), changedKey);
            this.cleanCache(this.getDatasetLocationOffsets(), changedKey);
            this.cleanCache(this.getDatasetLocations(), changedKey);
        }
        if (null != this.getCurrentDatasetName() && this.getCurrentDatasetName().startsWith(changedKey)) {
            if (ObjectAdapterModel.isTrace()) {
                this.log("setLocalValue", "resetting current dataset");
            }
            this.setCurrentDatasetName(this.getCurrentDatasetName(), true);
        }
    }

    protected void cleanCache(Map cache, String baseKey) {
        Set keys = cache.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(baseKey)) continue;
            if (ObjectAdapterModel.isTrace()) {
                this.log("cleanCache", "baseKey=" + baseKey + " clearing=" + key);
            }
            keys.remove(key);
        }
    }

    public Operations getOperations() {
        return this._operations;
    }

    public void setOperations(Operations value) {
        if (value == null) {
            value = new Operations();
        }
        this._operations = value;
    }

    public String getDefaultExecuteOperationID() {
        return this._defaultExecuteOperationID;
    }

    public void setDefaultExecuteOperationID(String value) {
        this._defaultExecuteOperationID = value;
    }

    protected Method getMethod(Operation opDesc) throws ModelControlException {
        Parameter[] params = opDesc.getParameters();
        int numParams = params.length;
        Class[] types = new Class[numParams];
        int count = 0;
        while (count < numParams) {
            try {
                types[count] = params[count].getType();
            }
            catch (ClassNotFoundException ex) {
                throw new ModelControlException("Unable to find class for parameter " + params[count].getName(), ex);
            }
            ++count;
        }
        try {
            return this.getObjectType().getMethod(opDesc.getOperationName(), types);
        }
        catch (Exception ex) {
            throw new ModelControlException("Unable to find '" + opDesc.getOperationName() + "' with argument types: " + types, ex);
        }
    }

    protected Object[] getOperationParameters(Operation opDesc) throws ModelControlException {
        if (opDesc == null) {
            return new Object[0];
        }
        Parameter[] parameters = opDesc.getParameters();
        if (parameters == null) {
            return new Object[0];
        }
        int len = parameters.length;
        Object[] params = new Object[len];
        Class paramType = null;
        int count = 0;
        while (count < len) {
            Object value = this.getLocalValue(opDesc.getName() + "." + parameters[count].getName());
            try {
                paramType = parameters[count].getType();
                if (!paramType.isArray() && value != null && value.getClass().isArray()) {
                    value = ((Object[])value)[0];
                }
                if (!paramType.isInstance(value)) {
                    value = TypeConverter.asType(paramType, value);
                }
                params[count] = value;
            }
            catch (ClassNotFoundException ex) {
                throw new ModelControlException(ex);
            }
            ++count;
        }
        return params;
    }

    public boolean isAllowBlankOrNullValueName() {
        return this._allowBlankOrNullValueName;
    }

    public void setAllowBlankOrNullValueName(boolean flag) {
        this._allowBlankOrNullValueName = flag;
    }

    public boolean isAllowKeyMappings() {
        return this._allowKeyMappings;
    }

    public void setAllowKeyMappings(boolean flag) {
        this._allowKeyMappings = flag;
    }

    protected int getInfiniteCheck() {
        return this._infiniteCheck;
    }

    protected void setInfiniteCheck(int value) {
        this._infiniteCheck = value;
    }

    public int getInfiniteCheckThreshold() {
        return this._infiniteCheckThreshold;
    }

    public void setInfiniteCheckThreshold(int value) {
        this._infiniteCheckThreshold = value;
    }

    protected void setFieldGroup(ModelFieldGroup fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public ModelFieldGroup getFieldGroup() {
        return this.fieldGroup;
    }

    public static boolean isTrace() {
        return toggleTrace;
    }

    public static void setTrace(boolean flag) {
        toggleTrace = flag;
    }

    protected void log(String context, String msg) {
        if (!ObjectAdapterModel.isTrace() || !Log.isLevelEnabled(8)) {
            return;
        }
        String info = "ObjectAdapterModel [" + this.getName() + "," + (System.currentTimeMillis() - this._epoch) + "," + context + "] ";
        Log.log(8, info + msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TRACE = true;
        DEFAULT_PARAMETER_NAME_BASE = DEFAULT_PARAMETER_NAME_BASE;
        OPTION_USE_TYPE_CACHE = true;
        UNDEFINED_ROW_INDEX = -1;
        UNDEFINED_ROW_INDEX_INTEGER = new Integer(-1);
        DEFAULT_INFINITE_LOOP_CHECK_THRESHOLD = 3;
    }
}

