/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.ws;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.object.ObjectFactory;
import com.iplanet.jato.util.ClassUtil;
import java.lang.reflect.Method;

public class JaxRpcStubFactory
implements ObjectFactory {
    private String serviceImplClassName;
    private String portFactoryMethodName;

    public void setServiceImplClassName(String className) {
        this.serviceImplClassName = className;
    }

    public String getServiceImplClassName() {
        return this.serviceImplClassName;
    }

    public void setPortFactoryMethodName(String methodName) {
        this.portFactoryMethodName = methodName;
    }

    public String getPortFactoryMethodName() {
        return this.portFactoryMethodName;
    }

    public Object getObject(RequestContext requestContext) throws ModelControlException {
        try {
            Class serviceImplType = ClassUtil.getClass(this.getServiceImplClassName());
            if (null == serviceImplType) {
                throw new ModelControlException("Unable to find Service Implementation Class [" + this.getServiceImplClassName() + "] please make sure " + "this class is compiled and available WAR");
            }
            Object serviceImpl = serviceImplType.newInstance();
            Method portFactoryMethod = serviceImplType.getDeclaredMethod(this.getPortFactoryMethodName(), new Class[0]);
            return portFactoryMethod.invoke(serviceImpl, new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new ModelControlException("failure instantiating JAXRPC Service Implementation [" + this.getServiceImplClassName() + "] please make sure " + "this class is compiled and available WAR", ie);
        }
        catch (IllegalAccessException iae) {
            throw new ModelControlException("Unable to instantiate JAXRPC Service Implementation [" + this.getServiceImplClassName() + "] please make sure " + "this class is compiled and available WAR", iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new ModelControlException("Cannot find port factory method [" + this.getPortFactoryMethodName() + "] in JAXRPC Service Implementation [" + this.getServiceImplClassName() + "]", nsme);
        }
        catch (SecurityException se) {
            throw new ModelControlException("Unable to access port factory method [" + this.getPortFactoryMethodName() + "] in JAXRPC Service Implementation [" + this.getServiceImplClassName() + "]", se);
        }
        catch (Exception e) {
            throw new ModelControlException("Exception reached creating JAXRPC stub", e);
        }
    }
}

