/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import java.io.Serializable;

public final class NonSyncStringBuffer
implements Serializable {
    private static final long serialVersionUID = -3694710825562081903L;
    private char[] value;
    private int count;
    private boolean shared;

    public NonSyncStringBuffer() {
        this(16);
    }

    public NonSyncStringBuffer(int length) {
        this.value = new char[length];
        this.shared = false;
    }

    public NonSyncStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public NonSyncStringBuffer(String str, int additionalCapacity) {
        this(str.length() + additionalCapacity);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copyWhenShared() {
        if (this.shared) {
            char[] newValue = new char[this.value.length];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacity(newLength);
        if (this.count < newLength) {
            this.copyWhenShared();
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = newLength;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.copyWhenShared();
        this.value[index] = ch;
    }

    public NonSyncStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public NonSyncStringBuffer append(String str) {
        if (str == null) {
            str = String.valueOf(str);
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public NonSyncStringBuffer append(char[] str) {
        int len = str.length;
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public NonSyncStringBuffer append(char[] str, int offset, int len) {
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public NonSyncStringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public NonSyncStringBuffer append(char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        this.value[this.count++] = c;
        return this;
    }

    public NonSyncStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public NonSyncStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public NonSyncStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public NonSyncStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public NonSyncStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public NonSyncStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public NonSyncStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count += len;
        return this;
    }

    public NonSyncStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public NonSyncStringBuffer insert(int offset, char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        ++this.count;
        return this;
    }

    public NonSyncStringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public NonSyncStringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public NonSyncStringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public NonSyncStringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public NonSyncStringBuffer reverse() {
        this.copyWhenShared();
        int n = this.count - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
            --j;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    final void setShared() {
        this.shared = true;
    }

    public final char[] getValue() {
        return this.value;
    }

    public NonSyncStringBuffer appendDelimited(String delimiter, Object obj) {
        if (this.length() > 0) {
            this.append(delimiter);
        }
        return this.append(obj);
    }

    static {
        serialVersionUID = -3694710825562081903L;
    }
}

