/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;

public class DisplayFieldImpl
extends ViewBase
implements DisplayField {
    private Model model;
    private String boundName;
    private DisplayFieldDescriptor descriptor;

    public DisplayFieldImpl(ContainerView parent, String name, Object value) {
        super(parent, name);
        this.setBoundName(name);
        this.setModel(parent.getDefaultModel());
        if (value != null) {
            this.setValue(value, false);
        }
    }

    public DisplayFieldImpl(ContainerView parent, String name, String boundName, Object value) {
        super(parent, name);
        this.setBoundName(boundName);
        this.setModel(parent.getDefaultModel());
        if (value != null) {
            this.setValue(value, false);
        }
    }

    public DisplayFieldImpl(View parent, Model model, String name, Object value) {
        super(parent, name);
        this.setBoundName(name);
        this.setModel(model);
        if (value != null) {
            this.setValue(value, false);
        }
    }

    public DisplayFieldImpl(View parent, Model model, String name, String boundName, Object value) {
        super(parent, name);
        this.setBoundName(boundName);
        this.setModel(model);
        this.setValue(value, false);
    }

    public DisplayFieldImpl(View parent, Model model, String name, String boundName, Object value, DisplayFieldDescriptor descriptor) {
        super(parent, name);
        this.setBoundName(boundName);
        this.setModel(model);
        this.setDescriptor(descriptor);
        if (value != null) {
            this.setValue(value, false);
        }
    }

    public Model getModel() {
        return this.model;
    }

    protected void setModel(Model value) {
        this.model = value;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public void setBoundName(String value) {
        this.boundName = value;
    }

    public DisplayFieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(DisplayFieldDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Object getValue() {
        return this.getModel().getValue(this.getBoundName());
    }

    public void setValue(Object value) {
        this.getModel().setValue(this.getBoundName(), value);
    }

    public void setValue(Object value, boolean overwrite) {
        if (overwrite) {
            this.getModel().setValue(this.getBoundName(), value);
        } else {
            Object[] v = this.getModel().getValues(this.getBoundName());
            if (v == null || v.length == 0) {
                this.getModel().setValue(this.getBoundName(), value);
            }
        }
    }

    public Object[] getValues() {
        return this.getModel().getValues(this.getBoundName());
    }

    public void setValues(Object[] values) {
        this.getModel().setValues(this.getBoundName(), values);
    }

    public void setValues(Object[] values, boolean overwrite) {
        if (overwrite) {
            this.getModel().setValues(this.getBoundName(), values);
        } else {
            Object[] v = this.getModel().getValues(this.getBoundName());
            if (v == null || v.length == 0) {
                this.getModel().setValues(this.getBoundName(), values);
            }
        }
    }

    public String stringValue() {
        Object o = this.getValue();
        if (o != null) {
            return o.toString();
        }
        return "";
    }
}

