/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandDescriptor;
import com.iplanet.jato.command.CommandFactory;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.SimpleModelReference;
import com.iplanet.jato.model.TreeModel;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.SimpleTreeViewStateData;
import com.iplanet.jato.view.TreeHandleViewInvocation;
import com.iplanet.jato.view.TreeView;
import com.iplanet.jato.view.TreeViewStateData;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ViewCommandEvent;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class RequestHandlingTreeViewBase
extends RequestHandlingViewBase
implements TreeView,
RequestCompletionListener {
    public static final String HANDLE_COMMAND_NVP_NAME = "jato_treeHandle";
    public static final String HANDLE_STATE_NVP_NAME = "jato_expandNode";
    public static final String DEFAULT_TREE_STATE_DATA_SESSION_ATTRIBUTE_NAME = "jato.treeStateData";
    private ModelReference primaryModelReference;
    private CommandDescriptor treeHandleCommandDescriptor;
    private TreeViewStateData stateData;
    private String stateDataLookupName = "jato.treeStateData";
    static /* synthetic */ Class class$com$iplanet$jato$model$TreeModel;
    static /* synthetic */ Class class$com$iplanet$jato$view$command$TreeHandleRequestCommand;

    public RequestHandlingTreeViewBase() {
    }

    public RequestHandlingTreeViewBase(View parent, String name) {
        super(parent, name);
    }

    protected RequestHandlingTreeViewBase(View parent, String name, String stateDataLookupName) {
        super(parent, name);
        this.stateDataLookupName = stateDataLookupName;
    }

    public void setRequestContext(RequestContext requestContext) {
        super.setRequestContext(requestContext);
        TreeViewStateData data = (TreeViewStateData)requestContext.getRequest().getSession().getAttribute(this.getStateDataLookupName());
        if (data == null) {
            data = new SimpleTreeViewStateData(new HashMap());
        }
        this.setStateData(data);
    }

    public void requestComplete() {
        if (this.getStateData() != null) {
            this.getRequestContext().getRequest().getSession().setAttribute(this.getStateDataLookupName(), (Object)this.getStateData());
        }
    }

    public TreeModel getPrimaryModel() {
        if (this.getPrimaryModelReference() != null) {
            return (TreeModel)this.getPrimaryModelReference().getModel();
        }
        return null;
    }

    public void setPrimaryModel(TreeModel value) {
        this.setPrimaryModelReference(new SimpleModelReference(value));
    }

    public ModelReference getPrimaryModelReference() {
        return this.primaryModelReference;
    }

    public void setPrimaryModelReference(ModelReference value) {
        if (value != null && !(class$com$iplanet$jato$model$TreeModel == null ? (class$com$iplanet$jato$model$TreeModel = RequestHandlingTreeViewBase.class$("com.iplanet.jato.model.TreeModel")) : class$com$iplanet$jato$model$TreeModel).isAssignableFrom(value.getModelClass())) {
            throw new IllegalArgumentException("Model reference must refer to a model of type " + (class$com$iplanet$jato$model$TreeModel == null ? (class$com$iplanet$jato$model$TreeModel = RequestHandlingTreeViewBase.class$("com.iplanet.jato.model.TreeModel")) : class$com$iplanet$jato$model$TreeModel).getName());
        }
        this.primaryModelReference = value;
    }

    public Class getPrimaryModelClass() {
        if (this.getPrimaryModelReference() != null) {
            return this.getPrimaryModelReference().getModelClass();
        }
        return null;
    }

    public void setPrimaryModelClass(Class value) {
        this.setPrimaryModelClass(value, false, false);
    }

    public void setPrimaryModelClass(Class value, boolean lookInSession, boolean saveInSession) {
        if (!(class$com$iplanet$jato$model$TreeModel == null ? (class$com$iplanet$jato$model$TreeModel = RequestHandlingTreeViewBase.class$("com.iplanet.jato.model.TreeModel")) : class$com$iplanet$jato$model$TreeModel).isAssignableFrom(value)) {
            throw new IllegalArgumentException("The primary model class must be of type " + (class$com$iplanet$jato$model$TreeModel == null ? (class$com$iplanet$jato$model$TreeModel = RequestHandlingTreeViewBase.class$("com.iplanet.jato.model.TreeModel")) : class$com$iplanet$jato$model$TreeModel).getName());
        }
        this.setPrimaryModelReference(new SimpleModelReference(value, null, lookInSession, saveInSession));
    }

    public String getStateDataLookupName() {
        return this.stateDataLookupName;
    }

    public void setStateDataLookupName(String value) {
        this.stateDataLookupName = value;
    }

    public void resetNodeLocation() throws ModelControlException {
        this.getPrimaryModel().beforeRoot();
    }

    public boolean nextNode() throws ModelControlException {
        int nextNode = 0;
        if (!this.isNodeExpanded()) {
            nextNode = 1;
        }
        return this.getPrimaryModel().nextNode(nextNode);
    }

    public int getNodeLevel() throws ModelControlException {
        return this.getPrimaryModel().getNodeLevel();
    }

    public String getNodeName() throws ModelControlException {
        return this.getPrimaryModel().getNodeName();
    }

    public String getNodeType() throws ModelControlException {
        return this.getPrimaryModel().getNodeType();
    }

    public boolean isNodeExpanded() {
        return this.getStateData().isNodeExpanded(this.getPrimaryModel().getNodeID());
    }

    public boolean isParentNode() {
        return this.getPrimaryModel().isParentNode();
    }

    public boolean isChildNode() {
        return this.getPrimaryModel().isChildNode();
    }

    public String getTreeHandleChildName() {
        return this.getQualifiedName() + "." + HANDLE_COMMAND_NVP_NAME;
    }

    public Object getTreeHandleChildValue() {
        return this.getPrimaryModel().getNodeID();
    }

    public String getTreeHandleStateParameterName() {
        return this.getQualifiedName() + "." + HANDLE_STATE_NVP_NAME;
    }

    public Object acceptRequest(HttpServletRequest request) {
        if (request.getParameter(this.getTreeHandleChildName()) != null) {
            return this.acceptTreeHandleRequest(request);
        }
        return super.acceptRequest(request);
    }

    protected Object acceptTreeHandleRequest(HttpServletRequest request) {
        String nodeID = request.getParameter(this.getTreeHandleChildName());
        CommandDescriptor commandDescriptor = this.getTreeHandleCommandDescriptor();
        if (commandDescriptor == null) {
            commandDescriptor = this.getDefaultTreeHandleCommandDescriptor();
        }
        return new TreeHandleViewInvocation(this, HANDLE_COMMAND_NVP_NAME, this.getTreeHandleChildName(), commandDescriptor, nodeID);
    }

    public void handleRequest(Object anInvocation) throws Exception {
        if (anInvocation instanceof TreeHandleViewInvocation) {
            Command command;
            TreeHandleViewInvocation invocation = (TreeHandleViewInvocation)anInvocation;
            CommandDescriptor commandDescriptor = invocation.getCommandDescriptor();
            if (commandDescriptor == null) {
                commandDescriptor = this.getDefaultTreeHandleCommandDescriptor();
            }
            if ((command = commandDescriptor.getCommand()) == null) {
                Class clazz = commandDescriptor.getCommandClass();
                if (clazz == null) {
                    clazz = class$com$iplanet$jato$view$command$TreeHandleRequestCommand == null ? (class$com$iplanet$jato$view$command$TreeHandleRequestCommand = RequestHandlingTreeViewBase.class$("com.iplanet.jato.view.command.TreeHandleRequestCommand")) : class$com$iplanet$jato$view$command$TreeHandleRequestCommand;
                }
                command = CommandFactory.getCommand(clazz);
            }
            ViewCommandEvent commandEvent = new ViewCommandEvent(this, this.getRequestContext(), commandDescriptor.getOperationName(), commandDescriptor.getParameters(), invocation);
            command.execute(commandEvent);
        } else {
            super.handleRequest(anInvocation);
        }
    }

    public CommandDescriptor getTreeHandleCommandDescriptor() {
        if (this.treeHandleCommandDescriptor == null) {
            this.treeHandleCommandDescriptor = this.getDefaultTreeHandleCommandDescriptor();
        }
        return this.treeHandleCommandDescriptor;
    }

    public void setTreeHandleCommandDescriptor(CommandDescriptor value) {
        this.treeHandleCommandDescriptor = value;
    }

    protected final CommandDescriptor getDefaultTreeHandleCommandDescriptor() {
        return new CommandDescriptor(class$com$iplanet$jato$view$command$TreeHandleRequestCommand == null ? (class$com$iplanet$jato$view$command$TreeHandleRequestCommand = RequestHandlingTreeViewBase.class$("com.iplanet.jato.view.command.TreeHandleRequestCommand")) : class$com$iplanet$jato$view$command$TreeHandleRequestCommand, "DEFAULT");
    }

    public TreeViewStateData getStateData() {
        return this.stateData;
    }

    protected void setStateData(TreeViewStateData value) {
        this.stateData = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HANDLE_COMMAND_NVP_NAME = HANDLE_COMMAND_NVP_NAME;
        HANDLE_STATE_NVP_NAME = HANDLE_STATE_NVP_NAME;
        DEFAULT_TREE_STATE_DATA_SESSION_ATTRIBUTE_NAME = DEFAULT_TREE_STATE_DATA_SESSION_ATTRIBUTE_NAME;
    }
}

