/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.InvalidDatasetException;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.MultiDatasetModel;
import com.iplanet.jato.model.SimpleModelReference;
import com.iplanet.jato.util.WrapperRuntimeException;
import com.iplanet.jato.view.BasicBooleanDisplayField;
import com.iplanet.jato.view.BooleanDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.event.DisplayEvent;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public abstract class TiledViewBase
extends ContainerViewBase
implements TiledView {
    public static final int UNDEFINED_ROW_INDEX = -1;
    private ModelReference primaryModelReference;
    private String primaryModelDatasetName;
    private int maxDisplayTiles = -1;
    private int displayIndex = -1;
    static /* synthetic */ Class class$com$iplanet$jato$model$DatasetModel;
    static /* synthetic */ Class class$com$iplanet$jato$view$BooleanDisplayField;

    protected TiledViewBase() {
    }

    public TiledViewBase(View parent, String name) {
        super(parent, name);
    }

    protected String getNonIndexedQualifiedName() {
        return super.getQualifiedName();
    }

    public String getQualifiedName() {
        String qualifiedName = this.getNonIndexedQualifiedName();
        try {
            if (this.getNumTiles() > 0 && this.getTileIndex() != -1) {
                qualifiedName = qualifiedName + "[" + this.getTileIndex() + "]";
            }
        }
        catch (ModelControlException e) {
            throw new Error("Unexpected ModelControlException: " + e);
        }
        return qualifiedName;
    }

    public void dumpChildValues(PrintStream out) throws ModelControlException {
        PrintWriter writer = new PrintWriter(out);
        this.dumpChildValues(writer);
        writer.flush();
    }

    public void dumpChildValues(PrintWriter out) throws ModelControlException {
        this.resetTileIndex();
        int row = 0;
        while (this.nextTileInternal()) {
            out.print("Row " + row + ": ");
            String[] names = this.getChildNames();
            int j = 0;
            while (j < names.length) {
                if (this.getChild(names[j]) instanceof DisplayField) {
                    if (j > 0) {
                        out.print(", ");
                    }
                    out.println(names[j] + "=" + ((DisplayField)this.getChild(names[j])).getValue());
                }
                ++j;
            }
            ++row;
        }
        this.resetTileIndex();
    }

    public DatasetModel getPrimaryModel() {
        DatasetModel result = null;
        if (this.getPrimaryModelReference() != null) {
            result = (DatasetModel)this.getPrimaryModelReference().getModel();
        }
        if (result == null) {
            result = (DatasetModel)this.getDefaultModel();
        }
        return result;
    }

    public void setPrimaryModel(DatasetModel value) {
        this.setPrimaryModelReference(new SimpleModelReference(value));
    }

    public void setPrimaryModel(Model value) {
        this.setPrimaryModel((DatasetModel)value);
    }

    public ModelReference getPrimaryModelReference() {
        return this.primaryModelReference;
    }

    public void setPrimaryModelReference(ModelReference value) {
        if (value != null && value.getModelClass() != null && !(class$com$iplanet$jato$model$DatasetModel == null ? (class$com$iplanet$jato$model$DatasetModel = TiledViewBase.class$("com.iplanet.jato.model.DatasetModel")) : class$com$iplanet$jato$model$DatasetModel).isAssignableFrom(value.getModelClass())) {
            throw new IllegalArgumentException("Model reference must refer to a model of type " + (class$com$iplanet$jato$model$DatasetModel == null ? (class$com$iplanet$jato$model$DatasetModel = TiledViewBase.class$("com.iplanet.jato.model.DatasetModel")) : class$com$iplanet$jato$model$DatasetModel).getName());
        }
        this.primaryModelReference = value;
    }

    public String getPrimaryModelDatasetName() {
        return this.primaryModelDatasetName;
    }

    public void setPrimaryModelDatasetName(String value) {
        this.primaryModelDatasetName = value;
    }

    protected void applyPrimaryModelDatasetName() throws InvalidDatasetException {
        if (this.getPrimaryModelDatasetName() != null && this.getPrimaryModel() instanceof MultiDatasetModel) {
            ((MultiDatasetModel)this.getPrimaryModel()).setCurrentDatasetName(this.getPrimaryModelDatasetName());
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.applyPrimaryModelDatasetName();
    }

    public View getChild(String name, int tile) throws ModelControlException {
        View result = this.getChild(name);
        if (result != null) {
            this.getPrimaryModel().setLocation(tile);
        }
        return result;
    }

    public int getNumTiles() {
        DatasetModel model = this.getPrimaryModel();
        if (model == null) {
            return -1;
        }
        try {
            this.applyPrimaryModelDatasetName();
            return model.getSize();
        }
        catch (ModelControlException e) {
            throw new WrapperRuntimeException("Could not obtain the number of rows from the primary model", e);
        }
    }

    public int getTileIndex() throws ModelControlException {
        DatasetModel model = this.getPrimaryModel();
        if (model == null) {
            return -1;
        }
        this.applyPrimaryModelDatasetName();
        return model.getLocation();
    }

    public void setTileIndex(int value) throws ModelControlException {
        DatasetModel model = this.getPrimaryModel();
        if (model != null) {
            this.applyPrimaryModelDatasetName();
            model.setLocation(value);
        }
    }

    public int getMaxDisplayTiles() {
        return this.maxDisplayTiles;
    }

    public void setMaxDisplayTiles(int value) {
        this.maxDisplayTiles = value;
    }

    public int getDisplayIndex() {
        return this.displayIndex;
    }

    protected void setDisplayIndex(int value) {
        this.displayIndex = value;
    }

    protected void resetDisplayIndex() {
        this.setDisplayIndex(-1);
    }

    protected int incrementDisplayIndex() {
        int newIndex = this.getDisplayIndex() + 1;
        this.setDisplayIndex(newIndex);
        return newIndex;
    }

    protected boolean isTileDisplayable(int index) {
        int maxTiles = this.getMaxDisplayTiles();
        return maxTiles <= -1 || index < maxTiles;
    }

    public void resetTileIndex() throws ModelControlException {
        if (this.getPrimaryModel() != null) {
            this.applyPrimaryModelDatasetName();
            this.getPrimaryModel().beforeFirst();
        }
        this.resetDisplayIndex();
    }

    public boolean nextTile() throws ModelControlException {
        return this.nextTileInternal();
    }

    protected final boolean nextTileInternal() throws ModelControlException {
        if (!this.isTileDisplayable(this.incrementDisplayIndex())) {
            return false;
        }
        if (this.getPrimaryModel() != null) {
            this.applyPrimaryModelDatasetName();
            return this.getPrimaryModel().next();
        }
        return false;
    }

    public void mapRequestParameters(HttpServletRequest request) throws ModelControlException {
        this.applyPrimaryModelDatasetName();
        HttpServletRequest aRequest = request;
        String[] childNames = this.getChildNames();
        boolean oldBooleanFieldHandling = BasicBooleanDisplayField.OPTION_OLD_BOOLEAN_FIELD_MAPPING;
        int i = 0;
        while (i < childNames.length) {
            boolean isBooleanDisplayField = (class$com$iplanet$jato$view$BooleanDisplayField == null ? TiledViewBase.class$("com.iplanet.jato.view.BooleanDisplayField") : class$com$iplanet$jato$view$BooleanDisplayField).isAssignableFrom(this.getChildType(childNames[i]));
            if (isBooleanDisplayField && oldBooleanFieldHandling) {
                BooleanDisplayField booleanField = (BooleanDisplayField)this.getChild(childNames[i]);
                booleanField.setValue(booleanField.getFalseValue());
            } else if (isBooleanDisplayField && !oldBooleanFieldHandling) {
                String[][] booleanFieldMarkerValues = null;
                String booleanMarkerName = childNames[i] + ViewBase.getQualifiedViewNameSeparator() + "jato_boolean";
                booleanFieldMarkerValues = TiledViewBase.getChildValues(aRequest, this.getNonIndexedQualifiedName(), booleanMarkerName);
                int row = 0;
                while (row < booleanFieldMarkerValues.length) {
                    DisplayField child = (DisplayField)this.getChild(childNames[i], row);
                    try {
                        this.mapRequestParameter(child, booleanFieldMarkerValues[row]);
                    }
                    catch (RuntimeException e) {
                        this.onValidationException(child, booleanFieldMarkerValues[row], e);
                    }
                    ++row;
                }
            }
            String[][] childValues = TiledViewBase.getChildValues(aRequest, this.getNonIndexedQualifiedName(), childNames[i]);
            int row = 0;
            while (row < childValues.length) {
                if (childValues[row] != null) {
                    View child = this.getChild(childNames[i], row);
                    if (child instanceof ContainerView) {
                        ((ContainerView)child).mapRequestParameters(request);
                    } else if (child instanceof DisplayField) {
                        try {
                            this.mapRequestParameter((DisplayField)child, childValues[row]);
                        }
                        catch (RuntimeException e) {
                            this.onValidationException((DisplayField)child, childValues[row], e);
                        }
                    }
                }
                ++row;
            }
            ++i;
        }
        this.resetTileIndex();
    }

    public static String[][] getChildValues(HttpServletRequest request, String qualifiedParentName, String childName) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            if (!param.startsWith(qualifiedParentName) || !param.endsWith(ViewBase.getQualifiedViewNameSeparator() + childName)) continue;
            int startIndex = param.lastIndexOf("[");
            int endIndex = param.lastIndexOf("]");
            if (startIndex == -1 || endIndex == -1) {
                throw new RuntimeException("Malformed qualified field name; tile index not found in \"" + param + "\"");
            }
            String indexString = param.substring(startIndex + 1, endIndex);
            int index = new Integer(indexString);
            if (index >= values.size()) {
                while (values.size() <= index) {
                    values.add(null);
                }
            }
            String[] paramValues = request.getParameterValues(param);
            values.set(index, paramValues);
        }
        return (String[][])values.toArray((T[])new String[0][0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        UNDEFINED_ROW_INDEX = -1;
    }
}

