/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import java.util.LinkedList;
import java.util.ListIterator;

public class ViewBase
implements View {
    private static String qualfiedViewNameSeparator = ".";
    private View parent;
    private String name;
    private boolean visible = true;
    private transient ViewBean parentViewBean;

    public ViewBase() {
    }

    public ViewBase(View parent) {
        this.setParent(parent);
    }

    public ViewBase(String name) {
        this.setName(name);
    }

    public ViewBase(View parent, String name) {
        this(parent);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getQualifiedName() {
        View parent = this.getParent();
        if (parent != null && parent.getName() != null) {
            return parent.getQualifiedName() + ViewBase.getQualifiedViewNameSeparator() + this.name;
        }
        return this.name;
    }

    public View getParent() {
        return this.parent;
    }

    public void setParent(View parent) {
        this.parent = parent;
        this.parentViewBean = null;
    }

    public ViewBean getParentViewBean() {
        if (this.parentViewBean == null) {
            this.parentViewBean = ViewBase.getRootView(this);
        }
        return this.parentViewBean;
    }

    public ViewBean getRootView() {
        return this.getParentViewBean();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public static ViewBean getRootView(View view) {
        View parent = view;
        while (parent != null && !(parent instanceof ViewBean)) {
            parent = parent.getParent();
        }
        return (ViewBean)parent;
    }

    public static String getSimpleQualifiedName(View view) {
        LinkedList<View> views = new LinkedList<View>();
        while (view != null) {
            views.add(view);
            view = view.getParent();
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(128);
        ListIterator i = views.listIterator(views.size());
        while (i.hasPrevious()) {
            if (buffer.length() > 0) {
                buffer.append(ViewBase.getQualifiedViewNameSeparator());
            }
            buffer.append(((View)i.previous()).getName());
        }
        return buffer.toString();
    }

    public static String getQualifiedViewNameSeparator() {
        return qualfiedViewNameSeparator;
    }

    public static void setQualifiedViewNameSeparator(String value) {
        qualfiedViewNameSeparator = value;
    }
}

