/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view.html;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.view.BooleanDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayFieldBase;

public class CheckBox
extends HtmlDisplayFieldBase
implements BooleanDisplayField {
    private Object checkedValue;
    private Object uncheckedValue;

    public CheckBox(ContainerView parent, String name, Object checkedValue, Object uncheckedValue, boolean checked) {
        super(parent, parent.getDefaultModel(), name, name, null, null);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public CheckBox(View parent, Model model, String name, Object checkedValue, Object uncheckedValue, boolean checked) {
        super(parent, model, name, name, null, null);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public CheckBox(View parent, Model model, String name, String boundName, Object checkedValue, Object uncheckedValue, boolean checked, DisplayFieldDescriptor descriptor) {
        super(parent, model, name, boundName, null, descriptor);
        this.setCheckedValue(checkedValue);
        this.setUncheckedValue(uncheckedValue);
        if (checked) {
            this.setValue(checkedValue, false);
        } else {
            this.setValue(uncheckedValue, false);
        }
    }

    public boolean isChecked() {
        if (this.getValue() != null) {
            if (this.getTrueValue() != null) {
                Object convertedValue = TypeConverter.asType(this.getTrueValue().getClass(), this.getValue());
                if (convertedValue != null && this.getValue().equals(this.getTrueValue())) {
                    return true;
                }
                return this.getValue().equals(this.getTrueValue());
            }
            if (this.getValue() instanceof Boolean) {
                return (Boolean)this.getValue();
            }
            return false;
        }
        return false;
    }

    public void setChecked(boolean value) {
        super.setValue(value ? this.getCheckedValue() : this.getUncheckedValue());
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean overwrite) {
        if (value == null) {
            super.setValue(this.getFalseValue(), overwrite);
        } else if (value.equals(this.getTrueValue()) || value.equals(this.getFalseValue())) {
            super.setValue(value, overwrite);
        } else {
            Object convertedValue;
            if (this.getTrueValue() != null && (convertedValue = TypeConverter.asType(this.getTrueValue().getClass(), value)) != null && convertedValue.equals(this.getTrueValue())) {
                super.setValue(this.getTrueValue(), overwrite);
                return;
            }
            if (this.getFalseValue() != null && (convertedValue = TypeConverter.asType(this.getFalseValue().getClass(), value)) != null && convertedValue.equals(this.getFalseValue())) {
                super.setValue(this.getFalseValue(), overwrite);
                return;
            }
            throw new IllegalArgumentException("Attempted to set field \"" + this.getName() + "\" to value \"" + value + "\", which is not equal to the true value \"" + this.getTrueValue() + "\" or false value \"" + this.getFalseValue() + "\"");
        }
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return this.getCheckedValue();
            }
            return this.getUncheckedValue();
        }
        return value;
    }

    public Object getCheckedValue() {
        return this.checkedValue;
    }

    public void setCheckedValue(Object value) {
        this.checkedValue = value;
    }

    public Object getUncheckedValue() {
        return this.uncheckedValue;
    }

    public void setUncheckedValue(Object value) {
        this.uncheckedValue = value;
    }

    public boolean booleanValue() {
        return this.isChecked();
    }

    public boolean getState() {
        return this.isChecked();
    }

    public Object getTrueValue() {
        return this.getCheckedValue();
    }

    public Object getFalseValue() {
        return this.getUncheckedValue();
    }
}

