/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventListener;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPProcessor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.PersistenceProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.database.DatabaseConstants;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeploymentEventListenerImpl
implements DeploymentEventListener,
DatabaseConstants {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", DeploymentEventListenerImpl.class.getClassLoader());
    private static Logger logger = LogHelperSQLStore.getLogger();

    DeploymentEventListenerImpl() {
    }

    public void notifyDeploymentEvent(DeploymentEvent event) {
        int type = event.getEventType();
        switch (type) {
            case 2: {
                this.processEvent(event.getEventInfo(), true);
                break;
            }
            case 3: {
                this.processEvent(event.getEventInfo(), false);
                break;
            }
        }
    }

    private void processEvent(DeploymentEventInfo info, boolean deploy) {
        Application application;
        String cliCreateTables = null;
        String cliDropAndCreateTables = null;
        String cliDropTables = null;
        DeploymentRequest request = info.getDeploymentRequest();
        Properties cliOverrides = request.getOptionalArguments();
        if (deploy) {
            cliDropAndCreateTables = cliOverrides.getProperty("CmpInfo.DROP_AND_CREATE_TABLES", "undefined");
            cliCreateTables = cliOverrides.getProperty("CmpInfo.CREATE_TABLES", "undefined");
            if (cliCreateTables.equals("undefined")) {
                cliCreateTables = cliDropAndCreateTables;
            }
        } else {
            cliDropTables = cliOverrides.getProperty("CmpInfo.DROP_TABLES", "undefined");
        }
        if ((application = info.getApplicationDescriptor()) == null) {
            return;
        }
        this.processApplication(request, info, deploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    private void processApplication(DeploymentRequest request, DeploymentEventInfo info, boolean deploy, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        boolean debug = logger.isLoggable(500);
        boolean redeploy = this.isRedeploy(deploy, request);
        if (debug) {
            logger.fine("ejb.DeploymentEventListenerImpl.processingevent", deploy ? (redeploy ? "redeploy" : "deploy") : "undeploy", info.getApplicationDescriptor().getRegistrationName());
        }
        DeploymentStatus status = request.getCurrentDeploymentStatus();
        status.setStageStatus(2);
        status.setStageStatusMessage("");
        BaseProcessor processor = new CMPProcessor(info, deploy, redeploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
        processor.processApplication();
        processor = new PersistenceProcessor(info, deploy, redeploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
        processor.processApplication();
    }

    private boolean isRedeploy(boolean deploy, DeploymentRequest request) {
        boolean redeploy = deploy;
        try {
            if (request != null) {
                redeploy = request.isReDeploy();
            }
        }
        catch (IASDeploymentException e) {
            // empty catch block
        }
        return redeploy;
    }

    static {
        DeploymentEventManager.addListener((DeploymentEventListener)new DeploymentEventListenerImpl());
    }
}

