/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import com.sun.enterprise.deployment.interfaces.QueryParser;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLC;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLParser;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import persistence.antlr.ANTLRException;
import persistence.antlr.collections.AST;

public class JDOQLParameterDeclarationParser
implements QueryParser {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(JDOQLParameterDeclarationParser.class);

    public Iterator parameterTypeIterator(String text) {
        return new ParameterTypeIterator(this.parse(text));
    }

    private AST parse(String text) {
        if (text == null) {
            return null;
        }
        AST paramsAST = null;
        ErrorMsg errorMsg = new ErrorMsg();
        JQLParser parser = JQLC.createStringParser(text, errorMsg);
        try {
            parser.parseParameters();
            paramsAST = parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, errorMsg);
        }
        return paramsAST;
    }

    public static void main(String[] args) {
        JDOQLParameterDeclarationParser helper = new JDOQLParameterDeclarationParser();
        for (int i = 0; i < args.length; ++i) {
            String text = args[i];
            System.out.println("Parameter types for >" + text + "<");
            Iterator types = helper.parameterTypeIterator(text);
            while (types.hasNext()) {
                System.out.println("  " + types.next());
            }
        }
    }

    private static class ParameterTypeIterator
    implements Iterator {
        private AST current;

        ParameterTypeIterator(AST ast) {
            this.current = ast;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.current.getType() != 61) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.jdoqlparameterdeclarationparser.next.wrongtoken", this.current.getType()));
            }
            String typeRepr = this.getTypeRepr(this.current.getFirstChild());
            this.current = this.current.getNextSibling();
            return typeRepr;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String getTypeRepr(AST ast) {
            if (ast == null) {
                return "";
            }
            if (ast.getType() == 94) {
                StringBuffer tmp = new StringBuffer();
                AST left = ast.getFirstChild();
                AST right = left.getNextSibling();
                return this.getTypeRepr(left) + "." + this.getTypeRepr(right);
            }
            return ast.getText();
        }
    }
}

