/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.ResultFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class ResultDesc {
    private List fields = new ArrayList();
    private List fieldNames = new ArrayList();
    private ClassDesc config;
    private boolean prefetching;
    private ArrayList prefetchedCollectionFields;
    private ForeignFieldDesc parentField;
    private ResultFieldDesc fieldProjection;
    private int aggregateResultType = 0;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", ResultDesc.class.getClassLoader());
    private boolean debug;

    public ResultDesc(ClassDesc config, int aggregateResultType) {
        this.config = config;
        this.aggregateResultType = aggregateResultType;
    }

    public void addField(LocalFieldDesc fieldDesc, ColumnRef columnRef, boolean projection) {
        ResultFieldDesc rfd = new ResultFieldDesc(fieldDesc, columnRef);
        if (projection) {
            this.fieldProjection = rfd;
        }
        this.fields.add(rfd);
        this.fieldNames.add(fieldDesc.getName());
    }

    private void addField(ResultDesc rs) {
        if (rs != null) {
            this.fields.add(rs);
            this.fieldNames.add(null);
        }
    }

    public void setPrefetching() {
        this.prefetching = true;
    }

    public void setParentField(ForeignFieldDesc parentField) {
        this.parentField = parentField;
    }

    private static Object getConvertedObject(ResultSet resultData, ColumnRef columnRef, FieldDesc fieldDesc, StateManager sm) {
        Object retVal = null;
        try {
            Object scoVal;
            retVal = ResultDesc.getValueFromResultSet(resultData, columnRef, fieldDesc.getEnumType());
            if (retVal != null && (scoVal = ResultDesc.createSCO(retVal, sm, fieldDesc)) != null) {
                retVal = scoVal;
            }
        }
        catch (SQLException sqlException) {
            try {
                retVal = fieldDesc.convertValue(resultData.getObject(columnRef.getIndex()), sm);
            }
            catch (Exception e) {
                logger.log(900, "sqlstore.exception.log", e);
            }
        }
        return retVal;
    }

    private static Object getValueFromResultSet(ResultSet resultData, ColumnRef columnRef, int resultType) throws SQLException {
        int index = columnRef.getIndex();
        int columnType = columnRef.getColumnType();
        return ResultDesc.getValueFromResultSet(resultData, index, resultType, columnType);
    }

    private static Object getValueFromResultSet(ResultSet resultData, int index, int resultType) throws SQLException {
        return ResultDesc.getValueFromResultSet(resultData, index, resultType, 1111);
    }

    private static Object getValueFromResultSet(ResultSet resultData, int index, int resultType, int columnType) throws SQLException {
        Object retVal = null;
        try {
            switch (resultType) {
                case 1: 
                case 11: {
                    boolean booleanValue = resultData.getBoolean(index);
                    if (!resultData.wasNull()) {
                        retVal = new Boolean(booleanValue);
                    }
                    break;
                }
                case 2: 
                case 12: {
                    String strValue = resultData.getString(index);
                    if (strValue != null) {
                        retVal = FieldDesc.getCharFromString(strValue);
                    }
                    break;
                }
                case 3: 
                case 13: {
                    byte byteValue = resultData.getByte(index);
                    if (!resultData.wasNull()) {
                        retVal = new Byte(byteValue);
                    }
                    break;
                }
                case 4: 
                case 14: {
                    short shortValue = resultData.getShort(index);
                    if (!resultData.wasNull()) {
                        retVal = new Short(shortValue);
                    }
                    break;
                }
                case 5: 
                case 15: {
                    int intValue = resultData.getInt(index);
                    if (!resultData.wasNull()) {
                        retVal = new Integer(intValue);
                    }
                    break;
                }
                case 6: 
                case 16: {
                    long longValue = resultData.getLong(index);
                    if (!resultData.wasNull()) {
                        retVal = new Long(longValue);
                    }
                    break;
                }
                case 7: 
                case 17: {
                    float floatValue = resultData.getFloat(index);
                    if (!resultData.wasNull()) {
                        retVal = new Float(floatValue);
                    }
                    break;
                }
                case 8: 
                case 18: {
                    double doubleValue = resultData.getDouble(index);
                    if (!resultData.wasNull()) {
                        retVal = new Double(doubleValue);
                    }
                    break;
                }
                case 19: 
                case 20: {
                    retVal = resultData.getBigDecimal(index);
                    if (resultType == 20 && retVal != null) {
                        retVal = ((BigDecimal)retVal).toBigInteger();
                    }
                    break;
                }
                case 21: {
                    if (LocalFieldDesc.isCharLobType(columnType)) {
                        Reader reader = resultData.getCharacterStream(index);
                        retVal = ResultDesc.readCharacterStreamToString(reader);
                        break;
                    }
                    retVal = resultData.getString(index);
                    break;
                }
                case 23: {
                    retVal = resultData.getDate(index);
                    break;
                }
                case 24: {
                    retVal = resultData.getTime(index);
                    break;
                }
                case 22: 
                case 25: {
                    Timestamp ts = resultData.getTimestamp(index);
                    if (resultType == 22 && ts != null) {
                        retVal = new Date(ts.getTime());
                        break;
                    }
                    retVal = ts;
                    break;
                }
                case 51: {
                    InputStream is = resultData.getBinaryStream(index);
                    retVal = ResultDesc.readInputStreamToByteArray(is);
                    break;
                }
                case 0: {
                    retVal = resultData.getObject(index);
                    break;
                }
                default: {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.resultdesc.unknownfieldtype", resultType));
                }
            }
        }
        catch (SQLException e) {
            if (logger.isLoggable(900)) {
                Object[] items = new Object[]{new Integer(index), new Integer(resultType), new Integer(columnType), e};
                logger.log(900, "sqlstore.resultdesc.errorgettingvalefromresulset", items);
            }
            throw e;
        }
        if (LocalFieldDesc.isFixedCharType(columnType) && resultType != 2 && resultType != 12 && retVal != null) {
            retVal = StringHelper.rtrim(retVal.toString());
        }
        return retVal;
    }

    private static Object createSCO(Object value, StateManager sm, FieldDesc fieldDesc) {
        Object retVal = null;
        if (fieldDesc != null) {
            int enumType = fieldDesc.getEnumType();
            switch (enumType) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    retVal = fieldDesc.createSCO(value, sm);
                    break;
                }
            }
        }
        return retVal;
    }

    private static byte[] readInputStreamToByteArray(InputStream is) {
        byte[] byteArray = null;
        if (is != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] chunk = new byte[2000];
            int read = 0;
            try {
                while ((read = is.read(chunk)) != -1) {
                    bos.write(chunk, 0, read);
                }
                byteArray = bos.toByteArray();
            }
            catch (IOException e) {
                logger.log(900, "sqlstore.exception.log", e);
            }
        }
        return byteArray;
    }

    private static String readCharacterStreamToString(Reader reader) {
        String retVal = null;
        if (reader != null) {
            BufferedReader buffReader = new BufferedReader(reader);
            StringBuffer buff = new StringBuffer();
            try {
                int charRead;
                while ((charRead = buffReader.read()) != -1) {
                    buff.append((char)charRead);
                }
            }
            catch (IOException e) {
                logger.log(900, "sqlstore.exception.log", e);
            }
            retVal = buff.toString();
        }
        return retVal;
    }

    public Object getResult(PersistenceManager pm, ResultSet resultData) throws SQLException {
        ArrayList<Object> result = null;
        this.debug = logger.isLoggable(300);
        if (!this.isAggregate()) {
            ArrayList<Object> resultCollection = new ArrayList<Object>();
            while (resultData.next()) {
                Object resultObject = null;
                resultObject = this.fieldProjection != null ? this.getProjectedField(resultData) : this.setFields(pm, resultData);
                if (this.prefetching && resultCollection.contains(resultObject)) continue;
                resultCollection.add(resultObject);
            }
            this.applyDeferredUpdatesToPrefetchedCollections(resultCollection);
            result = resultCollection;
        } else {
            result = this.getAggregateResult(resultData);
        }
        return result;
    }

    private void applyDeferredUpdatesToPrefetchedCollections(Collection resultCollection) {
        if (this.prefetching && this.prefetchedCollectionFields != null && this.prefetchedCollectionFields.size() > 0) {
            for (PersistenceCapable resultPC : resultCollection) {
                if (resultPC == null) continue;
                SQLStateManager sm = (SQLStateManager)resultPC.jdoGetStateManager();
                Iterator prefetchedCollectionFieldsIter = this.prefetchedCollectionFields.iterator();
                StateManager resultSM = resultPC.jdoGetStateManager();
                while (prefetchedCollectionFieldsIter.hasNext()) {
                    ForeignFieldDesc prefetchedCollectionField = (ForeignFieldDesc)prefetchedCollectionFieldsIter.next();
                    if (prefetchedCollectionField.cardinalityUPB <= 1) continue;
                    SCOCollection relationshipValue = (SCOCollection)prefetchedCollectionField.getValue(sm);
                    if (relationshipValue.isDeferred()) {
                        relationshipValue.applyDeferredUpdates(null);
                    }
                    resultSM.setPresenceMaskBit(prefetchedCollectionField.absoluteID);
                }
            }
        }
    }

    private Object getAggregateResult(ResultSet resultData) throws SQLException {
        Object result = null;
        if (resultData.next()) {
            result = ResultDesc.getValueFromResultSet(resultData, 1, this.aggregateResultType);
        }
        return result;
    }

    private Object getProjectedField(ResultSet resultData) {
        LocalFieldDesc f = this.fieldProjection.getFieldDesc();
        if (this.debug) {
            logger.finest("sqlstore.resultdesc.returning_field", f.getName());
        }
        return ResultDesc.getConvertedObject(resultData, this.fieldProjection.getColumnRef(), f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setFields(PersistenceManager pm, ResultSet resultData) {
        Object pcObj = null;
        SQLStateManager sm = (SQLStateManager)this.findOrCreateStateManager(resultData, pm);
        if (sm != null) {
            pcObj = sm.getPersistent();
            sm.getLock();
            try {
                for (int i = 0; i < this.fields.size(); ++i) {
                    Object temp = this.fields.get(i);
                    if (temp instanceof ResultFieldDesc) {
                        ResultFieldDesc rfd = (ResultFieldDesc)temp;
                        LocalFieldDesc f = rfd.getFieldDesc();
                        if (sm.getPresenceMaskBit(f.absoluteID)) continue;
                        Object value = ResultDesc.getConvertedObject(resultData, rfd.getColumnRef(), f, sm);
                        if (this.debug) {
                            logger.finest("sqlstore.resultdesc.marking_field", f.getName());
                        }
                        ResultDesc.setFieldValue(sm, f, value);
                        continue;
                    }
                    ResultDesc frd = (ResultDesc)temp;
                    ForeignFieldDesc parentField = frd.parentField;
                    if (!sm.getPresenceMaskBit(parentField.absoluteID)) {
                        Object fobj = frd.setFields(pm, resultData);
                        if (parentField.cardinalityUPB > 1) {
                            SCOCollection collection = (SCOCollection)parentField.getValue(sm);
                            if (collection == null) {
                                sm.replaceCollection(parentField, null);
                                collection = (SCOCollection)parentField.getValue(sm);
                            }
                            if (fobj != null) {
                                collection.addToBaseCollection(fobj);
                            }
                        } else {
                            ResultDesc.setFieldValue(sm, parentField, fobj);
                        }
                    }
                    if (!this.debug) continue;
                    logger.finest("sqlstore.resultdesc.marking_foreign_field", parentField.getName());
                }
                sm.initialize(true);
            }
            finally {
                sm.releaseLock();
            }
        }
        return pcObj;
    }

    private static void setFieldValue(StateManager sm, FieldDesc f, Object value) {
        f.setValue(sm, value);
        sm.setPresenceMaskBit(f.absoluteID);
    }

    private boolean isAggregate() {
        return this.aggregateResultType != 0;
    }

    private StateManager findOrCreateStateManager(ResultSet resultData, PersistenceManager pm) {
        try {
            Class oidClass = this.config.getOidClass();
            Object oid = oidClass.newInstance();
            Field[] keyFields = this.config.getKeyFields();
            String[] keyNames = this.config.getKeyFieldNames();
            for (int i = 0; i < keyFields.length; ++i) {
                Field keyField = keyFields[i];
                String keyName = keyNames[i];
                FieldDesc fd = this.config.getField(keyName);
                int index = this.fieldNames.indexOf(keyName);
                ResultFieldDesc rfd = (ResultFieldDesc)this.fields.get(index);
                Object v = ResultDesc.getConvertedObject(resultData, rfd.getColumnRef(), fd, null);
                if (this.debug) {
                    logger.finest("sqlstore.resultdesc.marking_key_field", keyName);
                }
                if (v == null) {
                    return null;
                }
                keyField.set(oid, v);
            }
            return pm.findOrCreateStateManager(oid, this.config.getPersistenceCapableClass());
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    public void doJoin(ResultDesc foreignResult, ForeignFieldDesc parentField) {
        this.addField(foreignResult);
        foreignResult.parentField = parentField;
        if (parentField.cardinalityUPB > 1) {
            if (this.prefetchedCollectionFields == null) {
                this.prefetchedCollectionFields = new ArrayList();
            }
            this.prefetchedCollectionFields.add(parentField);
        }
    }
}

