/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Appserver70DomainNamesResolver {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private URLClassLoader classLoader;
    private Class domainRegistryClass;
    private Object domainRegistryObject;
    private static final String ASADMINUNIX = "asadmin";
    private static final String ASADMINWIN = "asadmin.bat";
    private static final String BIN = "bin";

    public Appserver70DomainNamesResolver(String appserverRoot) {
        try {
            File jarFile = new File(appserverRoot + File.separator + "lib" + File.separator + "appserv-admin.jar");
            System.setProperty("com.sun.aas.configRoot", this.getConfigDir70(appserverRoot));
            URL[] jars = new URL[]{jarFile.toURL()};
            this.classLoader = new URLClassLoader(jars, this.getClass().getClassLoader());
            this.domainRegistryClass = this.classLoader.loadClass("com.iplanet.ias.admin.common.domains.registry.DomainRegistry");
            Method newInstanceMethod = this.domainRegistryClass.getMethod("newInstance", null);
            this.domainRegistryObject = newInstanceMethod.invoke(null, null);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), ex);
        }
    }

    public Hashtable getDomainNamesPathMapping() {
        Hashtable<String, DomainInfo> mapping = new Hashtable<String, DomainInfo>();
        try {
            Method iteratorMethod = this.domainRegistryClass.getMethod("iterator", null);
            Iterator domainNameIterator = (Iterator)iteratorMethod.invoke(this.domainRegistryObject, null);
            while (domainNameIterator.hasNext()) {
                Object obj = domainNameIterator.next();
                Method dName = obj.getClass().getMethod("getName", null);
                String name = (String)dName.invoke(obj, null);
                Method dPath = obj.getClass().getMethod("getPath", null);
                String path = (String)dPath.invoke(obj, null);
                mapping.put(name, new DomainInfo(name, path));
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), ex);
        }
        return mapping;
    }

    public String getConfigDir70(String source) {
        String osName = System.getProperty("os.name");
        String asenv = null;
        String asadmin = null;
        asadmin = osName.indexOf("Windows") != -1 ? source + File.separator + BIN + File.separator + ASADMINWIN : source + File.separator + BIN + File.separator + ASADMINUNIX;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(asadmin)));
            String readString = reader.readLine();
            while (readString != null) {
                if (readString.indexOf("asenv") != -1) {
                    StringTokenizer st = new StringTokenizer(readString);
                    st.nextToken();
                    String asenvStr = st.nextToken();
                    int index = asenvStr.indexOf("asenv");
                    asenv = asenvStr.substring(0, index);
                    break;
                }
                readString = reader.readLine();
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        return asenv;
    }

    public static void main(String[] args) {
        Appserver70DomainNamesResolver as = new Appserver70DomainNamesResolver(args[0]);
        as.getDomainNamesPathMapping();
    }
}

