/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Appserver70DomainNamesResolver;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class VersionExtracter {
    private String installDir;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private CommonInfoModel common;

    public VersionExtracter(String iD, CommonInfoModel common) {
        this.installDir = iD;
        this.common = common;
    }

    public String getVersion() {
        String asadminString = "asadmin";
        if (System.getProperty("os.name").indexOf("indows") != -1) {
            asadminString = "asadmin.bat";
        }
        String appserverVersion = null;
        String asAdminFileStr = this.installDir + File.separator + "bin" + File.separator + asadminString;
        if (new File(asAdminFileStr).exists()) {
            String execCommand = asAdminFileStr + " version";
            try {
                Process asadminProcess = Runtime.getRuntime().exec(execCommand);
                BufferedReader pInReader = new BufferedReader(new InputStreamReader(asadminProcess.getInputStream()));
                String inLine = null;
                while ((inLine = pInReader.readLine()) != null && (appserverVersion = this.parseVersion(inLine)) == null) {
                }
                asadminProcess.destroy();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("common.versionextracter.getVersionError"), ex);
            }
        }
        if (appserverVersion == null) {
            appserverVersion = this.extractVersionFromConfigFile();
        }
        return appserverVersion;
    }

    private String parseVersion(String versionString) {
        String appservString = this.stringManager.getString("common.versionextracter.appserver.string");
        String app7String = this.stringManager.getString("common.versionextracter.appserver.7string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app7String) != -1) {
            String verEdString = this.extractVersionFromConfigFile();
            if (verEdString != null) {
                return verEdString;
            }
            return "as7xpe";
        }
        String app80String = this.stringManager.getString("common.versionextracter.appserver.80string");
        String appPEString = this.stringManager.getString("common.versionextracter.appserver.platformEdition");
        String appSEString = this.stringManager.getString("common.versionextracter.appserver.standardEdition");
        String appEEString = this.stringManager.getString("common.versionextracter.appserver.enterpriseEdition");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app80String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as80pe";
            }
            if (versionString.indexOf(appSEString) != -1) {
                return "as81se";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as81ee";
            }
            return null;
        }
        String app81String = this.stringManager.getString("common.versionextracter.appserver.81string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app81String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as81pe";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as81ee";
            }
            return null;
        }
        String app90String = this.stringManager.getString("common.versionextracter.appserver.90string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app90String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as90pe";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as90ee";
            }
            return null;
        }
        return null;
    }

    public String formatVersionEditionStrings(String[] verEd) {
        if (verEd != null) {
            if (verEd[0].equals("7x")) {
                if (verEd[1].equals("pe")) {
                    return "as7xpe";
                }
                if (verEd[1].equals("se")) {
                    return "as7xse";
                }
                if (verEd[1].equals("ee")) {
                    return "as7xee";
                }
            } else if (verEd[0].equals("80")) {
                if (verEd[1].equals("pe")) {
                    return "as80pe";
                }
                if (verEd[1].equals("se")) {
                    return "as81se";
                }
                if (verEd[1].equals("ee")) {
                    return "as81ee";
                }
            } else if (verEd[0].equals("81")) {
                if (verEd[1].equals("pe")) {
                    return "as81pe";
                }
                if (verEd[1].equals("ee")) {
                    return "as81ee";
                }
            } else if (verEd[0].equals("90")) {
                if (verEd[1].equals("pe")) {
                    return "as90pe";
                }
                if (verEd[1].equals("ee")) {
                    return "as90ee";
                }
            }
        }
        return null;
    }

    private String extractVersionFromConfigFile() {
        String versionString = null;
        String editionString = null;
        File configFile = this.getConfigFile();
        if (configFile == null || !configFile.exists()) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(configFile);
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String systemID = adminServerDoc.getDoctype().getSystemId();
            String appservString = this.stringManager.getString("common.versionextracter.appserver.string");
            String app7xPESEString = this.stringManager.getString("common.versionextracter.appserver.7xPESEConfigString");
            String app70EEString = this.stringManager.getString("common.versionextracter.appserver.70EEConfigString");
            String app71EEString = this.stringManager.getString("common.versionextracter.appserver.71EEConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app7xPESEString) != -1) {
                versionString = "7x";
                editionString = this.getEditionFor70PEAnd70SE(configFile);
            }
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app70EEString) != -1) {
                versionString = "7x";
                editionString = this.getEditionFor70EEAnd71SE(adminServerDoc);
            }
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app71EEString) != -1) {
                versionString = "7x";
                editionString = "ee";
            }
            String app80String = this.stringManager.getString("common.versionextracter.appserver.80ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app80String) != -1) {
                versionString = "80";
                editionString = "pe";
            }
            String app81String = this.stringManager.getString("common.versionextracter.appserver.81ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app81String) != -1) {
                versionString = "81";
            }
            String app90String = this.stringManager.getString("common.versionextracter.appserver.90ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app90String) != -1) {
                versionString = "90";
            }
            if (editionString == null) {
                NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("jvm-options");
                for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                    Element element = (Element)taggedElements.item(lh);
                    String jvmOptionsData = this.getTextNodeData(element);
                    if (versionString.equals("7x")) {
                        if (jvmOptionsData.indexOf("EEORBInitializer") == -1 && jvmOptionsData.indexOf("EEIIOPSocketFactory") == -1) continue;
                        editionString = "se";
                        break;
                    }
                    if (jvmOptionsData.indexOf("EEPluggableFeatureImpl") == -1) continue;
                    editionString = "ee";
                    break;
                }
                if (editionString == null) {
                    editionString = "pe";
                }
            }
            return this.formatVersionEditionStrings(new String[]{versionString, editionString});
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.transform.startFailureMessage"), ex);
            return null;
        }
    }

    private String getEditionFor70PEAnd70SE(File configFile) {
        String editionString = "pe";
        Hashtable domainMapping = this.extractDomainsMapping();
        if (domainMapping != null && !domainMapping.isEmpty()) {
            for (DomainInfo dInfo : domainMapping.values()) {
                if (dInfo.getInstanceNames().size() <= 2) continue;
                return "se";
            }
            return "pe";
        }
        String domainsDir = this.getDomainAndConfigDirs()[0];
        File[] domains = new File(domainsDir).listFiles();
        if (domains != null) {
            for (int i = 0; i < domains.length; ++i) {
                if (!domains[i].isDirectory() || domains[i].list().length <= 2 || !this.common.isValid70Domain(domains[i].getPath())) continue;
                return "se";
            }
            return "pe";
        }
        return "pe";
    }

    private String getEditionFor70EEAnd71SE(Document doc) {
        NodeList taggedElements = doc.getDocumentElement().getElementsByTagName("jvm-options");
        for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
            Element element = (Element)taggedElements.item(lh);
            String jvmOptionsData = this.getTextNodeData(element);
            if (jvmOptionsData.indexOf("com.sun.aas.hadbRoot") == -1) continue;
            return "ee";
        }
        NodeList availabilityEles = doc.getDocumentElement().getElementsByTagName("availability-service");
        if (availabilityEles.getLength() != 0) {
            return "ee";
        }
        return "se";
    }

    private Hashtable extractDomainsMapping() {
        File runtime70Jar = new File(this.installDir + File.separator + "lib" + File.separator + "admingui.ear");
        boolean notTargetInstallation7x = true;
        if (this.common.getTargetInstallDir() != null) {
            boolean bl = notTargetInstallation7x = !this.common.getTargetInstallDir().equals(this.installDir);
        }
        if (runtime70Jar.exists() && !this.common.checkSourceInputAsDomainRoot(this.installDir) && notTargetInstallation7x) {
            Appserver70DomainNamesResolver as = new Appserver70DomainNamesResolver(this.installDir);
            Hashtable domainsMapping = as.getDomainNamesPathMapping();
            this.common.setInstallConfig70(as.getConfigDir70(this.installDir));
            return domainsMapping;
        }
        return null;
    }

    private File getConfigFile() {
        Hashtable domainMapping = this.extractDomainsMapping();
        if (domainMapping != null && !domainMapping.isEmpty()) {
            DomainInfo dInfo = (DomainInfo)domainMapping.values().iterator().next();
            String instanceName = null;
            Iterator instIt = dInfo.getInstanceNames().iterator();
            while (instIt.hasNext() && (instanceName = (String)instIt.next()).equals("admin-server")) {
            }
            return new File(dInfo.getInstancePath(instanceName) + File.separator + "config" + File.separator + "server.xml");
        }
        String[] dCDirs = this.getDomainAndConfigDirs();
        if (dCDirs == null) {
            return null;
        }
        if (dCDirs[1].indexOf("server1") != -1) {
            return new File(dCDirs[1] + File.separator + "server.xml");
        }
        return new File(dCDirs[1] + File.separator + "domain.xml");
    }

    public String[] getDomainAndConfigDirs() {
        String domainsDir = this.installDir + File.separator + "domains";
        String configDir = null;
        boolean domainRootSame = false;
        if (this.common.checkSourceInputAsDomainRoot(this.installDir)) {
            domainRootSame = new File(this.common.getSourceDomainRoot()).equals(new File(this.common.getTargetDomainRoot()));
        }
        if (this.common.checkSourceInputAsDomainRoot(this.installDir) && domainRootSame) {
            if (domainRootSame) {
                if (new File(this.installDir + File.separator + "backup").exists()) {
                    domainsDir = this.installDir;
                    String backupdomainPath = this.common.findLatestDomainDir(this.installDir);
                    String serverDir = backupdomainPath + File.separator + "server1";
                    configDir = !new File(serverDir).exists() ? backupdomainPath + File.separator + "config" : backupdomainPath + File.separator + "server1" + File.separator + "config";
                } else {
                    String[] directories = new File(this.installDir).list();
                    String domainName = null;
                    for (int j = 0; j < directories.length; ++j) {
                        if (directories[j].equals("backup") || new File(this.installDir + File.separator + directories[j]).isFile()) continue;
                        domainName = directories[j];
                        break;
                    }
                    if (!new File(domainsDir = this.installDir + File.separator + domainName).exists()) {
                        domainsDir = null;
                        configDir = null;
                    } else {
                        String domainsDir2 = domainsDir + File.separator + "server1";
                        configDir = !new File(domainsDir2).exists() ? domainsDir + File.separator + "config" : domainsDir + File.separator + "server1" + File.separator + "config";
                        domainsDir = this.installDir;
                    }
                }
            }
        } else if (!new File(domainsDir).exists()) {
            domainsDir = this.installDir + File.separator + "domains_bak";
            if (!new File(domainsDir).exists()) {
                String[] chList = new File(this.installDir).list();
                if (chList == null || chList.length <= 0) {
                    domainsDir = null;
                    configDir = null;
                } else {
                    domainsDir = this.installDir + File.separator + chList[0];
                    if (!new File(domainsDir + File.separator + "config").exists()) {
                        if (new File(this.installDir + File.separator + "config").isDirectory()) {
                            configDir = this.installDir + File.separator + "config";
                            domainsDir = this.installDir;
                        } else {
                            domainsDir = null;
                            configDir = null;
                        }
                    } else {
                        String domainsDir2 = domainsDir + File.separator + "server1";
                        configDir = !new File(domainsDir2).exists() ? domainsDir + File.separator + "config" : domainsDir + File.separator + "server1" + File.separator + "config";
                        domainsDir = this.installDir;
                    }
                }
            } else {
                String[] chList = new File(domainsDir).list();
                configDir = domainsDir + File.separator + chList[0] + File.separator + "config";
            }
        } else {
            String[] chList = new File(domainsDir).list();
            if (chList != null) {
                String domainsDir2 = domainsDir + File.separator + chList[0] + File.separator + "server1";
                configDir = !new File(domainsDir2).exists() ? domainsDir + File.separator + chList[0] + File.separator + "config" : domainsDir + File.separator + chList[0] + File.separator + "server1" + File.separator + "config";
            }
        }
        if (configDir == null) {
            return null;
        }
        return new String[]{domainsDir, configDir};
    }

    private String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

