/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.arguments.CertificateArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;

public class ARG_jkspwdfile
extends CertificateArgumentHandler {
    private String jksPwdFile;

    public ARG_jkspwdfile(ParsedArgument pa) {
        super(pa);
        if (this.parameters.isEmpty()) {
            this.helpUsage(this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--jkspwdfile/-j"));
            System.exit(1);
        }
        this.jksPwdFile = (String)this.parameters.firstElement();
        this.processCertificatePasswords(this.jksPwdFile);
    }

    protected void setCertificatePassword(String password) {
        if (password == null) {
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)this.jksPwdFile));
            System.exit(1);
        }
        this.commonInfo.setJksKeystorePassword(password);
        String jksPath = "";
        if (this.commonInfo.isUpgradeNSStoJKS()) {
            if (!this.interactiveMap.containsKey("target")) {
                return;
            }
            jksPath = this.commonInfo.getTargetJKSKeyStorePath();
        } else {
            if (!this.interactiveMap.containsKey("source")) {
                return;
            }
            jksPath = this.commonInfo.getSourceJKSKeyStorePath();
        }
        boolean validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, password);
        if (!validpwd) {
            this.commonInfo.recover();
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
            System.exit(1);
        }
        this.interactiveMap.put("jkspwd-" + this.commonInfo.getCurrentDomain(), this.jksPwdFile);
    }
}

