/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class CertificateArgumentHandler
extends ArgumentHandler {
    public CertificateArgumentHandler(ParsedArgument pa) {
        super(pa);
        this.commonInfo.setCertificateConversionFlag(true);
    }

    protected void processCertificatePasswords(String pwdfile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pwdfile)));
            while (reader.ready()) {
                String entry = reader.readLine();
                StringTokenizer tokens = new StringTokenizer(entry, " ", false);
                int tokenCount = tokens.countTokens();
                if (tokenCount < 1) {
                    this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile));
                    System.exit(1);
                }
                if (tokenCount > 1) {
                    String domainName = tokens.nextToken();
                    this.commonInfo.setCurrentDomain(domainName);
                    this.commonInfo.addDomainOptionName(domainName);
                }
                if (tokenCount == 3) {
                    this.commonInfo.setCurrentSourceInstance(tokens.nextToken());
                }
                this.setCertificatePassword(tokens.nextToken());
                if (this.commonInfo.getSourceVersion().equals("7x")) {
                    this.interactiveMap.put("domain-" + this.commonInfo.getCurrentDomain() + ":" + this.commonInfo.getCurrentSourceInstance(), pwdfile);
                    continue;
                }
                this.interactiveMap.put("domain-" + this.commonInfo.getCurrentDomain(), pwdfile);
            }
        }
        catch (FileNotFoundException fe) {
            this.helpUsage();
            this._logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.password_file_missing", (Object)pwdfile), fe);
            System.exit(1);
        }
        catch (Exception io) {
            this._logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile), io);
            System.exit(1);
        }
    }

    protected abstract void setCertificatePassword(String var1);
}

