/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.LogMessageEvent;
import com.sun.enterprise.tools.upgrade.common.UpgradeUpdateEvent;
import com.sun.enterprise.tools.upgrade.gui.FlowLabel;
import com.sun.enterprise.tools.upgrade.gui.HeaderPanel;
import com.sun.enterprise.tools.upgrade.gui.ProgressBar;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProgressPanel
extends JPanel {
    private FlowLabel flowProgressLabel;
    private JTextArea resultTextArea;
    private ProgressBar progressBar;
    private JScrollPane jscrollpane;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = CommonInfoModel.getDefaultLogger();

    public ProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel(this.stringManager.getString("upgrade.gui.progresspanel.headerPanel"));
        headerPanel.setInsets(new Insets(12, 10, 12, 10));
        this.add((Component)headerPanel, "North");
        this.add((Component)this.getWizardPanel(), "Center");
    }

    private JPanel getWizardPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        FlowLabel flowTopLabel = new FlowLabel();
        FlowLabel flowTextAreaLabel = new FlowLabel();
        this.flowProgressLabel = new FlowLabel();
        this.progressBar = new ProgressBar();
        this.resultTextArea = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setLineWrap(true);
        this.jscrollpane = new JScrollPane(this.resultTextArea, 20, 30);
        this.jscrollpane.setAutoscrolls(true);
        this.resultTextArea.setAutoscrolls(true);
        flowTopLabel.setText(this.stringManager.getString("upgrade.gui.progresspanel.flowContentLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)flowTopLabel, gridBagConstraints);
        flowTextAreaLabel.setText(this.stringManager.getString("upgrade.gui.progresspanel.textAreaText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)flowTextAreaLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)this.jscrollpane, gridBagConstraints);
        this.flowProgressLabel.setText(this.stringManager.getString("upgrade.gui.progresspanel.progressLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.flowProgressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.progressBar, gridBagConstraints);
        return panel;
    }

    public void updateLog(LogMessageEvent evt) {
        LogRecord logRecord = evt.getLogRecord();
        if (logRecord != null) {
            if (logRecord.getLevel().equals(Level.SEVERE) || logRecord.getLevel().equals(Level.WARNING)) {
                this.resultTextArea.append(logRecord.getMessage());
                this.resultTextArea.revalidate();
            } else {
                this.resultTextArea.append(logRecord.getMessage());
            }
            this.resultTextArea.append("\n");
        } else {
            this.resultTextArea.append(evt.getMessage());
        }
        this.resultTextArea.revalidate();
        this.jscrollpane.getVerticalScrollBar().setValue(this.jscrollpane.getVerticalScrollBar().getMaximum());
        this.jscrollpane.getVerticalScrollBar().setVisibleAmount(this.jscrollpane.getVerticalScrollBar().getMaximum());
    }

    public void updateProgress(UpgradeUpdateEvent evt) {
        int progressState = evt.getProgressState();
        String labelText = null;
        if (evt.getProgressState() == 100) {
            labelText = this.stringManager.getString("upgrade.gui.progresspanel.progressLabel.DONE");
        }
        if (evt.getProgressState() == -1) {
            progressState = 0;
            labelText = this.stringManager.getString("upgrade.gui.progresspanel.progressLabel.ERROR");
            JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.progresspanel.errorProgressMsg"), this.stringManager.getString("upgrade.gui.progresspanel.errorProgressMsgTitle"), 0);
        }
        this.progressBar.setProgress(progressState);
        if (labelText != null) {
            this.flowProgressLabel.setText(labelText);
        }
    }
}

