/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.logging;

import com.sun.enterprise.tools.upgrade.common.LogMessageListener;
import com.sun.enterprise.tools.upgrade.logging.LogFormatter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogService {
    public static final String UPGRADE_LOGGER = "com.sun.enterprise.tools.upgrade";
    public static final String UPGRADE_CLI_LOGGER = "com.sun.enterprise.tools.upgrade.cli";
    public static final String UPGRADE_CERTCONVERSION_LOGGER = "com.sun.enterprise.tools.upgrade.certconversion";
    private static LogFormatter formatter;
    private static FileHandler loghandler;

    public static void initialize(String fileName) throws IOException {
        LogManager.getLogManager().reset();
        formatter = new LogFormatter();
        boolean append = true;
        int limit = 1000000;
        loghandler = new FileHandler(fileName, limit, 1, append);
        loghandler.setLevel(Level.ALL);
        loghandler.setFormatter((Formatter)((Object)formatter));
    }

    public static Logger getLogger(String name) {
        Logger logger = Logger.getLogger(name);
        Handler[] h = logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            logger.removeHandler(h[i]);
        }
        logger.addHandler(loghandler);
        return logger;
    }

    public static void addLogMessageListener(LogMessageListener listener) {
        LogFormatter.addLogMessageListener(listener);
    }

    public static void removeLogMessageListener(LogMessageListener listener) {
        LogFormatter.removeLogMessageListener(listener);
    }
}

