/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JVMOptions
extends BaseElement {
    public void transform(Element element, Element parentSource, Element parentResult) {
        NodeList jvmOptions = parentResult.getElementsByTagName("jvm-options");
        Element jvmOption = null;
        String srcTxtDt = this.getTextNodeData(element);
        String[] sourceTextData = this.parseTextData(srcTxtDt);
        if (sourceTextData == null) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.jvmoptions.notTransferred", (Object)srcTxtDt));
            return;
        }
        if (srcTxtDt.trim().equals("-Djdbc.drivers=com.pointbase.jdbc.jdbcUniversalDriver")) {
            return;
        }
        if (!this.canTransfer(sourceTextData[0], sourceTextData[1])) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.jvmoptions.notTransferred", (Object)sourceTextData[0]));
            return;
        }
        for (int lh = 0; lh < jvmOptions.getLength(); ++lh) {
            String tgTxtDt = this.getTextNodeData((Element)jvmOptions.item(lh));
            if (srcTxtDt.equals(tgTxtDt)) {
                jvmOption = (Element)jvmOptions.item(lh);
                break;
            }
            String[] targetTextData = this.parseTextData(tgTxtDt);
            if (sourceTextData == null || targetTextData == null || !sourceTextData[0].equals(targetTextData[0])) continue;
            jvmOption = (Element)jvmOptions.item(lh);
            break;
        }
        if (jvmOption == null) {
            if (this.canTransfer(sourceTextData[0], sourceTextData[1])) {
                if (sourceTextData[1].indexOf(commonInfoModel.getSourceInstallDir()) == -1) {
                    jvmOption = parentResult.getOwnerDocument().createElement("jvm-options");
                    Text textNode = jvmOption.getOwnerDocument().createTextNode(srcTxtDt);
                    jvmOption.appendChild(textNode);
                    parentResult.appendChild(jvmOption);
                }
            } else {
                this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.jvmoptions.notTransferred", (Object)sourceTextData[0]));
            }
        }
    }

    private String[] parseTextData(String fullStr) {
        String[] parsedStrings = null;
        StringTokenizer stk = new StringTokenizer(fullStr, "=");
        if (stk.hasMoreTokens() && stk.countTokens() == 2) {
            parsedStrings = new String[]{stk.nextToken(), stk.nextToken()};
        }
        return parsedStrings;
    }

    private String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    private boolean canTransfer(String optionName, String optionValue) {
        block5: {
            block4: {
                if (optionName.indexOf("Dorg.xml.sax.parser") != -1 || optionName.indexOf("Dorg.xml.sax.driver") != -1 || optionName.indexOf("Dcom.sun.jdo.api.persistence.model.multipleClassLoaders") != -1 || optionName.indexOf("Djava.util.logging.manager") != -1 || optionName.indexOf("Dcom.sun.aas.imqLib") != -1 || optionName.indexOf("Dcom.sun.aas.imqBin") != -1 || optionName.indexOf("Dcom.sun.aas.webServicesLib") != -1 || optionName.indexOf("Dcom.sun.aas.configRoot") != -1) {
                    return false;
                }
                String repOpValue = commonInfoModel.getSourceInstallDir().replace('\\', '/');
                if (optionValue.indexOf(repOpValue) != -1) break block4;
                if (optionValue.indexOf(commonInfoModel.getSourceInstallDir()) == -1) break block5;
            }
            return false;
        }
        return !commonInfoModel.getTargetEdition().equals("ee") || optionName.indexOf("javax.net.ssl") == -1;
    }
}

