/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.ClusterRefConfigReferent;
import com.sun.appserv.management.config.ConfigRemover;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DeployedItemRefConfigReferent;
import com.sun.appserv.management.config.RefConfig;
import com.sun.appserv.management.config.RefConfigReferent;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourceRefConfigReferent;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.config.ServerRefConfigReferent;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.Output;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefHelper {
    private static final Set<String> REFERENT_J2EE_TYPES = Collections.unmodifiableSet(GSetUtil.newSet(new String[]{"X-ResourceRefConfig", "X-DeployedItemRefConfig", "X-ServerRefConfig", "X-ClusterRefConfig"}));

    private RefHelper() {
    }

    private static Output getDebug() {
        return AMXDebug.getInstance().getOutput("com.sun.appserv.management.helper.RefHelper");
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigs(QueryMgr queryMgr) {
        Set refs = queryMgr.queryInterfaceSet(RefConfig.class.getName(), null);
        return refs;
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigsByJ2EEType(QueryMgr queryMgr, String refJ2EEType) {
        Set refs = queryMgr.queryJ2EETypeSet(refJ2EEType);
        return refs;
    }

    public static Set<ResourceRefConfig> findAllResourceRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigsByJ2EEType(queryMgr, "X-ResourceRefConfig");
    }

    public static Set<DeployedItemRefConfig> findAllDeployedItemRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigsByJ2EEType(queryMgr, "X-DeployedItemRefConfig");
    }

    public static Set<ServerRefConfig> findAllServerRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigsByJ2EEType(queryMgr, "X-ServerRefConfig");
    }

    public static Set<ClusterRefConfig> findAllClusterRefConfigs(QueryMgr queryMgr) {
        return RefHelper.findAllRefConfigsByJ2EEType(queryMgr, "X-ClusterRefConfig");
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigsWithName(QueryMgr queryMgr, String refJ2EEType, String name) {
        String props = Util.makeRequiredProps(refJ2EEType, name);
        Set refs = queryMgr.queryPatternSet(null, props);
        return refs;
    }

    public static String getReferentRefJ2EEType(RefConfigReferent referent) {
        String j2eeType = null;
        if (referent instanceof ResourceRefConfigReferent) {
            j2eeType = "X-ResourceRefConfig";
        } else if (referent instanceof DeployedItemRefConfigReferent) {
            j2eeType = "X-DeployedItemRefConfig";
        } else if (referent instanceof ServerRefConfigReferent) {
            j2eeType = "X-ServerRefConfig";
        } else if (referent instanceof ClusterRefConfigReferent) {
            j2eeType = "X-ClusterRefConfig";
        } else {
            throw new IllegalArgumentException("Unknown referent class: " + Util.asAMX(referent).getJ2EEType());
        }
        return j2eeType;
    }

    public static Set<String> getReferentJ2EETypes() {
        return REFERENT_J2EE_TYPES;
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigs(RefConfigReferent referent) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), RefHelper.getReferentRefJ2EEType(referent), amx.getName());
    }

    public static <T extends RefConfig> Set<T> findAllRefConfigs(RefConfigReferent referent, String refJ2EEType) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), refJ2EEType, amx.getName());
    }

    public static Set<DeployedItemRefConfig> findAllRefConfigs(DeployedItemRefConfigReferent referent) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), "X-DeployedItemRefConfig", amx.getName());
    }

    public static Set<ResourceRefConfig> findAllRefConfigs(ResourceRefConfigReferent referent) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), "X-ResourceRefConfig", amx.getName());
    }

    public static Set<ServerRefConfig> findAllRefConfigs(ServerRefConfigReferent referent) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), "X-ServerRefConfig", amx.getName());
    }

    private static QueryMgr getQueryMgr(AMX amx) {
        return amx.getDomainRoot().getQueryMgr();
    }

    public static Set<ClusterRefConfig> findAllRefConfigs(ClusterRefConfigReferent referent) {
        AMX amx = Util.asAMX(referent);
        return RefHelper.findAllRefConfigsWithName(RefHelper.getQueryMgr(amx), "X-ClusterRefConfig", amx.getName());
    }

    public static <T extends RefConfig> Set<T> removeAllRefsTo(RefConfigReferent item, boolean allowSingleFailure) {
        Set<T> refs = RefHelper.findAllRefConfigs(item);
        Set<T> failures = RefHelper.removeRefConfigs(refs);
        if (failures.size() > 1 || !allowSingleFailure) {
            Set<ObjectName> objectNames = Util.toObjectNames(failures);
            throw new IllegalArgumentException("failure removing refererences:\n{" + CollectionUtil.toString(objectNames, "\n") + "\n}");
        }
        return failures;
    }

    public static <T extends RefConfig> Set<T> removeRefConfigs(Set<T> refs) {
        HashSet<RefConfig> failures = new HashSet<RefConfig>();
        for (RefConfig ref : refs) {
            ConfigRemover rrc = (ConfigRemover)ConfigRemover.class.cast(ref.getContainer());
            try {
                rrc.removeConfig(ref.getJ2EEType(), ref.getName());
            }
            catch (Exception e) {
                failures.add(ref);
            }
        }
        return failures;
    }
}

