/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class AMXCreateResourceCommand
extends S1ASCommand {
    public static final String DOMAIN_CONFIG_OBJECT_NAME = "amx:j2eeType=X-DomainConfig,name=na";
    public static final String SERVER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-StandaloneServerConfig,name=";
    public static final String CLUSTER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-ClusterConfig,name=";
    public static final String TARGET_NAME = "target";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String targetName = this.getOption(TARGET_NAME);
        ObjectName scON = targetName != null && !targetName.equals("domain") ? this.getTargetConfigObjectName(mbsc, targetName) : null;
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            Object returnValue = mbsc.invoke(Util.newObjectName((String)DOMAIN_CONFIG_OBJECT_NAME), operationName, params, types);
            if (scON != null) {
                mbsc.invoke(scON, "createResourceRefConfig", new Object[]{new String((String)this.getOperands().get(0))}, new String[]{"java.lang.String"});
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    public void displayExceptionMessage(Exception e) throws CommandException {
        Throwable rootException = ExceptionUtil.getRootCause((Throwable)e);
        if (rootException.getLocalizedMessage() != null) {
            CLILogger.getInstance().printDetailMessage(rootException.getLocalizedMessage());
        }
        throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
    }

    private ObjectName getTargetConfigObjectName(MBeanServerConnection mbsc, String targetName) throws CommandException {
        try {
            ObjectName scON = Util.newObjectName((String)(SERVER_CONFIG_OBJECT_NAME + targetName));
            if (!mbsc.isRegistered(scON)) {
                scON = Util.newObjectName((String)(CLUSTER_CONFIG_OBJECT_NAME + targetName));
            }
            if (!mbsc.isRegistered(scON)) {
                throw new CommandException(this.getLocalizedString("InvalidTargetName"));
            }
            return scON;
        }
        catch (RuntimeOperationsException roe) {
            throw new CommandException(roe);
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
    }
}

