/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.enterprise.cli.commands.BaseTransformationRuleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;

public class ConfigureWebServiceCommand
extends BaseTransformationRuleCommand {
    private static final String MONITORING_OPTION = "monitoring";
    private static final String MAX_HISTORY_SIZE_OPTION = "maxhistorysize";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            String webServiceName = (String)this.getOperands().get(0);
            this.validateWebServiceName(webServiceName, true);
            WebServiceEndpointConfig wsc = this.getWebServiceEndpointConfig(mbsc, webServiceName, true);
            if (wsc == null) {
                throw new CommandException(this.getLocalizedString("CannotFindWebservice"));
            }
            String maxHistorySize = this.getOption(MAX_HISTORY_SIZE_OPTION);
            String monitoring = this.getOption(MONITORING_OPTION);
            if (maxHistorySize != null) {
                wsc.setMaxHistorySize(maxHistorySize);
            }
            if (monitoring != null) {
                wsc.setMonitoringLevel(monitoring);
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private String getWebServiceName() throws CommandException {
        String operand = (String)this.getOperands().get(0);
        StringTokenizer paramsTokenizer = new StringTokenizer(operand, "#");
        int size = paramsTokenizer.countTokens();
        if (size != 3) {
            throw new CommandException(this.getLocalizedString("InvalidWebServiceEndpoint"));
        }
        return paramsTokenizer.nextToken();
    }

    private String getWebServiceEndPoint() throws CommandException {
        String operand = (String)this.getOperands().get(0);
        int index = operand.indexOf("#");
        return operand.substring(index + 1);
    }

    private Map getOptionMap() throws CommandException {
        HashMap<String, String> map = new HashMap<String, String>();
        String maxHistorySize = this.getOption(MAX_HISTORY_SIZE_OPTION);
        String monitoring = this.getOption(MONITORING_OPTION);
        map.put("MonitoringLevel", monitoring);
        map.put("MaxHistorySize", maxHistorySize);
        return map;
    }
}

