/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;

public class CreateDomainCommand
extends BaseLifeCycleCommand {
    private static final String DOMAIN_PATH = "path";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String DOCROOT = "docroot";
    private static final String TEMPLATE = "template";
    private static final String DOMAIN_PROPERTIES = "domainproperties";
    private static final String CHECKPORTS_OPTION = "checkports";
    private static final int DEFAULT_HTTPSSL_PORT = 8181;
    private static final int DEFAULT_IIOPSSL_PORT = 3820;
    private static final int DEFAULT_IIOPMUTUALAUTH_PORT = 3920;
    private static final int DEFAULT_INSTANCE_PORT = 8080;
    private static final int DEFAULT_JMS_PORT = 7676;
    private static final String DEFAULT_JMS_USER = "admin";
    private static final String DEFAULT_JMS_PASSWORD = "admin";
    private static final int DEFAULT_IIOP_PORT = 3700;
    private static final int DEFAULT_JMX_PORT = 8686;
    public static String DOMAINDIR_OPTION = "domaindir";
    private static String SAVELOGIN_OPTION = "savelogin";
    private String domainName = null;
    private String adminUser = null;
    private String adminPassword = null;
    private String masterPassword = null;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void validatePasswords() throws CommandValidationException {
        if (!this.isPasswordValid(this.adminPassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"adminpassword"}));
        }
        if (!this.isPasswordValid(this.masterPassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"masterpassword"}));
        }
        CLILogger.getInstance().printDebugMessage("domainName = " + this.domainName);
    }

    protected String getAdminPassword() throws CommandValidationException, CommandException {
        return this.getPassword("adminpassword", "AdminPasswordPrompt", "AdminPasswordConfirmationPrompt", true, true, false, false, null, null, true, true, true, true);
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.setLoggerLevel();
        String domainDirValue = this.getOption(DOMAINDIR_OPTION);
        if (domainDirValue != null && !this.isWindows() && this.isSpaceInPath(domainDirValue)) {
            throw new CommandException(this.getLocalizedString("SpaceNotAllowedInPath", new Object[]{DOMAINDIR_OPTION}));
        }
        try {
            this.domainName = (String)this.operands.firstElement();
            DomainsManager manager = this.getFeatureFactory().getDomainsManager();
            DomainConfig config = this.getDomainConfig(this.domainName);
            manager.validateDomain(config, false);
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CouldNotCreateDomain", new Object[]{this.domainName}), e);
        }
        this.adminUser = this.getAdminUser();
        this.adminPassword = this.getAdminPassword();
        this.masterPassword = this.getMasterPassword(true);
        this.validatePasswords();
        try {
            this.verifyPortIsValid(this.getOption("adminport"));
            if (this.getOption(INSTANCE_PORT) != null) {
                this.verifyPortIsValid(this.getOption(INSTANCE_PORT));
            }
            Properties domainProperties = this.getDomainProperties(this.getOption(DOMAIN_PROPERTIES));
            domainProperties.remove("domain.adminPort");
            this.createTheDomain(this.getDomainsRoot(), domainProperties);
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CouldNotCreateDomain", new Object[]{this.domainName}), e);
        }
    }

    private void verifyPortIsValid(String portNum) throws CommandException, CommandValidationException {
        int portToVerify = this.convertPortStr(portNum);
        if (portToVerify <= 0 || portToVerify > 65535) {
            throw new CommandException(this.getLocalizedString("InvalidPortRange", new Object[]{portNum}));
        }
        if (this.getBooleanOption(CHECKPORTS_OPTION) && !NetUtils.isPortFree((int)portToVerify)) {
            throw new CommandException(this.getLocalizedString("PortInUse", new Object[]{(String)this.operands.firstElement(), portNum}));
        }
        CLILogger.getInstance().printDebugMessage("Port =" + portToVerify);
    }

    private void createTheDomain(String domainPath, Properties domainProperties) throws Exception {
        Integer adminPort = new Integer(this.getOption("adminport"));
        String domainFilePath = domainPath + File.separator + this.domainName;
        if (FileUtils.safeGetCanonicalFile((File)new File(domainFilePath)).exists()) {
            throw new CommandValidationException(this.getLocalizedString("DomainExists", new Object[]{this.domainName}));
        }
        Integer instancePort = this.getPort(domainProperties, "domain.instancePort", this.getOption(INSTANCE_PORT), Integer.toString(8080), "HTTP Instance");
        Integer jmsPort = this.getPort(domainProperties, "jms.port", null, Integer.toString(7676), "JMS");
        String jmsUser = "admin";
        String jmsPassword = "admin";
        Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, Integer.toString(3700), "IIOP");
        Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, Integer.toString(8181), "HTTP_SSL");
        Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, Integer.toString(3820), "IIOP_SSL");
        Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, Integer.toString(3920), "IIOP_MUTUALAUTH");
        Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, Integer.toString(8686), "JMX_ADMIN");
        Boolean saveMasterPassword = this.getSaveMasterPassword(this.masterPassword);
        DomainConfig domainConfig = new DomainConfig(this.domainName, adminPort, domainPath, this.adminUser, this.adminPassword, this.masterPassword, saveMasterPassword, instancePort, "admin", "admin", jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, domainProperties);
        if (this.getOption(TEMPLATE) != null) {
            domainConfig.put((Object)"template.name", (Object)this.getOption(TEMPLATE));
        }
        domainConfig.put((Object)"domain.validatePorts", (Object)new Boolean(this.getBooleanOption(CHECKPORTS_OPTION)));
        DomainsManager manager = this.getFeatureFactory().getDomainsManager();
        manager.createDomain(domainConfig);
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainCreated", new Object[]{this.domainName}));
        this.checkAsadminPrefsFile();
        if (this.getBooleanOption(SAVELOGIN_OPTION)) {
            this.saveLogin(adminPort, this.adminUser, this.adminPassword, this.domainName);
        }
    }

    private void checkAsadminPrefsFile() {
        try {
            this.checkForFileExistence(System.getProperty("user.home"), ".asadminprefs");
            CLILogger.getInstance().printMessage(this.getLocalizedString("AsadminPrefFileDetected", new Object[]{this.domainName}));
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws CommandValidationException {
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if (this.getBooleanOption(CHECKPORTS_OPTION) && !NetUtils.isPortFree((int)port)) {
            port = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DefaultPortInUse", new Object[]{name, defaultPort, Integer.toString(port)}));
                } else {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("PortNotSpecified", new Object[]{name, new Integer(port)}));
                }
            } else if (invalidPortSpecified) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("InvalidPortRangeMsg", new Object[]{name, new Integer(port)}));
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("PortInUseMsg", new Object[]{name, new Integer(port)}));
            }
        } else if (defaultPortUsed) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("UsingDefaultPort", new Object[]{name, Integer.toString(port)}));
        }
        if (properties != null) {
            properties.remove(key);
        }
        return new Integer(port);
    }

    private Properties getDomainProperties(String propertyValues) throws CommandException, CommandValidationException {
        Properties propertyList = new Properties();
        if (propertyValues == null) {
            return propertyList;
        }
        StringTokenizer st = new StringTokenizer(propertyValues, ":");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            while (st.hasMoreTokens() && propertyString.endsWith(Character.toString('\\'))) {
                propertyString = propertyString.concat(st.nextToken());
            }
            int index = propertyString.indexOf(Character.toString('='));
            if (index == -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertySyntax"));
            }
            String propertyName = propertyString.substring(0, index);
            String propertyValue = propertyString.substring(index + 1);
            propertyList.put(propertyName, propertyValue);
        }
        CLILogger.getInstance().printDebugMessage("domain properties = " + propertyList);
        return propertyList;
    }

    private int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void saveLogin(int port, String user, String password, String dn) {
        block3: {
            CLILogger logger = CLILogger.getInstance();
            try {
                String msg;
                Object[] params;
                LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                LoginInfo login = new LoginInfo("localhost", port, user, password);
                if (store.exists(login.getHost(), login.getPort())) {
                    params = new Object[]{login.getHost(), "" + login.getPort()};
                    msg = this.getLocalizedString("OverwriteLoginMsgCreateDomain", params);
                    logger.printMessage(msg);
                }
                store.store(login, true);
                params = new String[]{user, dn, store.getName()};
                msg = this.getLocalizedString("LoginInfoStoredCreateDomain", params);
                logger.printMessage(msg);
            }
            catch (Exception e) {
                Object[] params = new String[]{user, dn};
                String msg = this.getLocalizedString("LoginInfoStoredCreateDomain", params);
                logger.printWarning(msg);
                if (!logger.isDebug()) break block3;
                logger.printExceptionStackTrace(e);
            }
        }
    }
}

