/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class DisplayErrorStatisticsCommand
extends GenericCommand {
    protected void handleReturnValue(Object retVal) {
        Map[] errorInfo = (Map[])retVal;
        if (errorInfo.length > 0) {
            String sTitle = String.format("%1$-39s %2$-9s %3$-8s", this.getLocalizedString("Timestamp"), this.getLocalizedString("Severity"), this.getLocalizedString("Warning"));
            CLILogger.getInstance().printDetailMessage(sTitle);
            CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
        }
        for (Map errorRecord : errorInfo) {
            Long timeStamp = (Long)errorRecord.get("TimeStamp");
            Date date = new Date(timeStamp);
            Integer severeCount = (Integer)errorRecord.get("SevereCount");
            Integer warningCount = (Integer)errorRecord.get("WarningCount");
            String sDate = this.getBooleanOption("terse") ? timeStamp.toString() : timeStamp.toString() + "(" + DateFormat.getDateTimeInstance().format(date) + ")";
            String sErrorRecord = String.format("%1$-43s %2$-8s %3$-8s", sDate, severeCount, warningCount);
            CLILogger.getInstance().printMessage(sErrorRecord);
        }
        if (errorInfo.length > 0) {
            CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
        }
    }
}

