/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListSubComponentsCommand
extends S1ASCommand {
    private static final String GET_MODULE_COMPONENTS = "getModuleComponents";
    private static final String APPNAME_OPTION = "appname";
    private static final String TYPE_OPTION = "type";
    private static final String EJBS = "ejbs";
    private static final String SERVLETS = "servlets";
    private static final String EJB_SUB_MODULE = "EJBModule|SessionBean|StatelessSessionBean|StatefulSessionBean|MessageDrivenBean|EntityBean";
    private static final String SERVLET_SUB_MODULE = "WebModule|Servlet";
    private static final String TYPE_OPTION_VALUES = "ejbs|servlets";

    public boolean validateOptions() throws CommandValidationException {
        String typeOption = this.getOption(TYPE_OPTION);
        if (typeOption != null && !typeOption.matches(TYPE_OPTION_VALUES)) {
            throw new CommandValidationException(this.getLocalizedString("InvalidTypeOption"));
        }
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String objectName = this.getObjectName();
        String appname = this.getOption(APPNAME_OPTION);
        String typeOption = this.getOption(TYPE_OPTION);
        Object[] params = this.getParams(appname);
        String[] types = this.getTypes(appname);
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), GET_MODULE_COMPONENTS, params, types);
            this.printObjectName(returnValue, typeOption);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private Object[] getParams(String appname) {
        if (appname == null) {
            return new Object[]{(String)this.getOperands().get(0)};
        }
        return new Object[]{appname, (String)this.getOperands().get(0)};
    }

    private String[] getTypes(String appname) {
        if (appname == null) {
            return new String[]{String.class.getName()};
        }
        return new String[]{String.class.getName(), String.class.getName()};
    }

    private void printObjectName(Object returnValue, String typeOption) throws CommandException {
        if (returnValue == null) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
        }
        try {
            if (returnValue.getClass().getName().equals(STRING_ARRAY)) {
                String[] objs = (String[])returnValue;
                boolean nothingToList = true;
                for (int ii = 0; ii < objs.length; ++ii) {
                    CLILogger.getInstance().printDebugMessage("***** " + objs[ii]);
                    ObjectName on = new ObjectName(objs[ii]);
                    if (typeOption != null) {
                        if ((!typeOption.equals(EJBS) || !on.getKeyProperty("j2eeType").matches(EJB_SUB_MODULE)) && (!typeOption.equals(SERVLETS) || !on.getKeyProperty("j2eeType").matches(SERVLET_SUB_MODULE))) continue;
                        this.printSubComponent(on);
                        nothingToList = false;
                        continue;
                    }
                    this.printSubComponent(on);
                    nothingToList = false;
                }
                if (nothingToList) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    private void printSubComponent(ObjectName on) {
        CLILogger.getInstance().printMessage(on.getKeyProperty("name") + " <" + on.getKeyProperty("j2eeType") + ">");
    }

    private void printDebug(MBeanServerConnection mbsc, String objectName) throws Exception {
        CLILogger.getInstance().printDebugMessage("********** getMBeanInfo **********");
        MBeanInfo mbinfo = mbsc.getMBeanInfo(new ObjectName(objectName));
        CLILogger.getInstance().printDebugMessage("Description = " + mbinfo.getDescription());
        CLILogger.getInstance().printDebugMessage("Classname = " + mbinfo.getClassName());
        MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
        for (int ii = 0; ii < mboinfo.length; ++ii) {
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Description = " + mboinfo[ii].getDescription());
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Name = " + mboinfo[ii].getName());
            CLILogger.getInstance().printDebugMessage("****** TYPE *****");
            MBeanParameterInfo[] mbpi = mboinfo[ii].getSignature();
            for (int kk = 0; kk < mbpi.length; ++kk) {
                CLILogger.getInstance().printDebugMessage("type = " + mbpi[kk].getType());
            }
            CLILogger.getInstance().printDebugMessage("returnType = " + mboinfo[ii].getReturnType());
        }
    }
}

