/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactory;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class StopDomainCommand
extends BaseLifeCycleCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void stopDomain(String domainName) throws CommandException, CommandValidationException {
        block5: {
            try {
                ClientPluggableFeatureFactory fac = this.getFeatureFactory();
                DomainsManager mgr = fac.getDomainsManager();
                DomainConfig cfg = this.getDomainConfig(domainName);
                InstancesManager im = mgr.getInstancesManager((RepositoryConfig)cfg);
                int state = im.getInstanceStatus();
                String[] domains = mgr.listDomains(cfg);
                boolean exists = false;
                for (int i = 0; domains != null && i < domains.length; ++i) {
                    if (!domains[i].equals(domainName)) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    mgr.stopDomain(cfg);
                    break block5;
                }
                if (state == 0) {
                    mgr.stopDomain(cfg);
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainStopped", new Object[]{domainName}));
                    break block5;
                }
                throw new CommandException(this.getLocalizedString("CannotStopDomainAlreadyStopped", new Object[]{domainName}));
            }
            catch (Exception e) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
                throw new CommandException(this.getLocalizedString("CannotStopDomain", new Object[]{domainName}), e);
            }
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String domainName = null;
        try {
            domainName = this.getDomainName();
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            domainName = domainName == null ? this.getLocalizedString("Undefined") : domainName;
            throw new CommandException(this.getLocalizedString("CannotStopDomain", new Object[]{domainName}), e);
        }
        this.stopDomain(domainName);
    }
}

