/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.ICommandEnvironment;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class GlobalsManager {
    private static GlobalsManager sGlobalsMgr = null;
    private ICommandEnvironment mGlobalCommandEnvironment = null;
    private static HashMap resourceBundles = new HashMap();
    private static String COMMANDS_BASE_PACKAGE = null;
    private static final String FRAMEWORK_BASE_PACKAGE = GlobalsManager.class.getPackage().getName();
    private static String FRAMEWORK_PROPERTY_FILE_NAME = "LocalStrings";
    private static String COMMANDS_PROPERTY_FILE_NAME = "LocalStrings";

    protected GlobalsManager() {
        this(new CommandEnvironment());
    }

    protected GlobalsManager(ICommandEnvironment env) {
        this.mGlobalCommandEnvironment = env;
        resourceBundles = new HashMap();
    }

    public static void setInstance(GlobalsManager globalsMgr) {
        if (sGlobalsMgr != globalsMgr) {
            sGlobalsMgr = globalsMgr;
        }
    }

    public static GlobalsManager getInstance() {
        if (sGlobalsMgr == null) {
            sGlobalsMgr = new GlobalsManager();
        }
        return sGlobalsMgr;
    }

    public ICommandEnvironment getGlobalsEnv() {
        return this.mGlobalCommandEnvironment;
    }

    public void setGlobalsEnv(ICommandEnvironment env) {
        this.mGlobalCommandEnvironment = env;
    }

    public String getOption(String optionName) {
        String optionValue = (String)this.mGlobalCommandEnvironment.getEnvironmentValue(optionName);
        return optionValue;
    }

    public void setOption(String name, String value) {
        this.mGlobalCommandEnvironment.setEnvironment(name, value);
    }

    public void removeOption(String optionName) {
        this.mGlobalCommandEnvironment.removeEnvironment(optionName);
    }

    public static String getString(String key) throws CommandException {
        return GlobalsManager.getString(key, COMMANDS_BASE_PACKAGE, COMMANDS_PROPERTY_FILE_NAME);
    }

    public static String getString(String key, Object[] toInsert) throws CommandException {
        return GlobalsManager.getString(key, toInsert, COMMANDS_BASE_PACKAGE, COMMANDS_PROPERTY_FILE_NAME);
    }

    public static String getFrameworkString(String key) throws CommandException {
        return GlobalsManager.getString(key, FRAMEWORK_BASE_PACKAGE, FRAMEWORK_PROPERTY_FILE_NAME);
    }

    public static String getFrameworkString(String key, Object[] toInsert) throws CommandException {
        return GlobalsManager.getString(key, toInsert, FRAMEWORK_BASE_PACKAGE, FRAMEWORK_PROPERTY_FILE_NAME);
    }

    private static String getString(String key, String basePkg, String propertyFile) throws CommandException {
        return GlobalsManager.getResourceBundle(basePkg, propertyFile).getString(key);
    }

    private static String getString(String key, Object[] toInsert, String basePkg, String propertyFile) throws CommandException {
        String fmtStr = null;
        try {
            ResourceBundle resBundle = GlobalsManager.getResourceBundle(basePkg, propertyFile);
            MessageFormat msgFormat = new MessageFormat(resBundle.getString(key));
            fmtStr = msgFormat.format(toInsert);
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
        return fmtStr;
    }

    private static ResourceBundle getResourceBundle(String packageName, String propertyFile) throws CommandException {
        ResourceBundle resBundle = (ResourceBundle)resourceBundles.get(packageName);
        if (resBundle == null) {
            try {
                resBundle = ResourceBundle.getBundle(packageName + "." + propertyFile);
                resourceBundles.put(packageName, resBundle);
            }
            catch (MissingResourceException mre) {
                throw new CommandException(mre.getLocalizedMessage());
            }
        }
        return resBundle;
    }

    public static void setBasePackage(String basePkg) {
        COMMANDS_BASE_PACKAGE = basePkg;
    }

    public static void setPropertyFile(String fileName) {
        COMMANDS_PROPERTY_FILE_NAME = fileName;
    }

    public static void main(String[] args) {
        try {
            GlobalsManager globalsMgr = GlobalsManager.getInstance();
            System.out.println(GlobalsManager.getFrameworkString("junk", new Object[]{"junk", "prashanth"}));
            GlobalsManager.setBasePackage("com.sun.enterprise.cli.commands");
            System.out.println(GlobalsManager.getString("junk", new Object[]{"junk", "prashanth"}));
        }
        catch (CommandException ce) {
            ce.printStackTrace();
        }
    }
}

