/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigureListener;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

public class WebConfiguration {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.config");
    private static final Pattern ALLOWABLE_BOOLEANS = Pattern.compile("true|false");
    private static final String WEB_CONFIG_KEY = "com.sun.faces.config.WebConfiguration";
    private Level loggingLevel = Level.FINE;
    private Map<BooleanWebContextInitParameter, Boolean> booleanContextParameters = new HashMap<BooleanWebContextInitParameter, Boolean>(BooleanWebContextInitParameter.values().length);
    private Map<WebContextInitParameter, String> contextParameters = new HashMap<WebContextInitParameter, String>(WebContextInitParameter.values().length);
    private Map<WebEnvironmentEntry, String> envEntries = new HashMap<WebEnvironmentEntry, String>(WebEnvironmentEntry.values().length);
    private ServletContext servletContext;

    private WebConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
        String contextName = this.getServletContextName();
        this.processBooleanParameters(servletContext, contextName);
        this.processInitParameters(servletContext, contextName);
        this.processJndiEntries(contextName);
    }

    public static WebConfiguration getInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            ExternalContext extContext = ConfigureListener.getExternalContextDuringInitialize();
            if (extContext == null) {
                return null;
            }
            return WebConfiguration.getInstance(extContext);
        }
        return WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public static WebConfiguration getInstance(ExternalContext extContext) {
        WebConfiguration config = (WebConfiguration)extContext.getApplicationMap().get(WEB_CONFIG_KEY);
        if (config == null) {
            return WebConfiguration.getInstance((ServletContext)extContext.getContext());
        }
        return config;
    }

    public static WebConfiguration getInstance(ServletContext servletContext) {
        WebConfiguration webConfig = (WebConfiguration)servletContext.getAttribute(WEB_CONFIG_KEY);
        if (webConfig == null) {
            webConfig = new WebConfiguration(servletContext);
            servletContext.setAttribute(WEB_CONFIG_KEY, (Object)webConfig);
        }
        return webConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean getBooleanContextInitParameter(BooleanWebContextInitParameter param) {
        if (this.booleanContextParameters.get((Object)param) != null) {
            return this.booleanContextParameters.get((Object)param);
        }
        return param.getDefaultValue();
    }

    public String getContextInitParameter(WebContextInitParameter param) {
        return this.contextParameters.get((Object)param);
    }

    public String getEnvironmentEntry(WebEnvironmentEntry entry) {
        return this.envEntries.get((Object)entry);
    }

    public String getServletContextName() {
        if (this.servletContext.getMajorVersion() == 2 && this.servletContext.getMinorVersion() <= 4) {
            return this.servletContext.getServletContextName();
        }
        return this.servletContext.getContextPath();
    }

    public void overrideContextInitParameter(BooleanWebContextInitParameter param) {
    }

    public void overrideContextInitParameter(WebContextInitParameter param) {
    }

    public void overrideEnvEntry(WebEnvironmentEntry entry) {
    }

    static void clear(ServletContext servletContext) {
        servletContext.removeAttribute(WEB_CONFIG_KEY);
    }

    private boolean isValueValid(BooleanWebContextInitParameter param, String value) {
        if (!ALLOWABLE_BOOLEANS.matcher(value).matches()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.config.webconfig.boolconfig.invalidvalue", new Object[]{value, param.getQualifiedName(), "true|false"});
            }
            return false;
        }
        return true;
    }

    private void processBooleanParameters(ServletContext servletContext, String contextName) {
        for (BooleanWebContextInitParameter param : BooleanWebContextInitParameter.values()) {
            boolean value;
            String strValue = servletContext.getInitParameter(param.getQualifiedName());
            if (strValue != null && strValue.length() > 0 && param.isDeprecated()) {
                BooleanWebContextInitParameter alternate = param.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, param.getQualifiedName(), alternate.getQualifiedName()});
                }
                value = this.isValueValid(param, strValue) ? Boolean.valueOf(strValue).booleanValue() : param.getDefaultValue();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, value ? "jsf.config.webconfig.configinfo.reset.enabled" : "jsf.config.webconfig.configinfo.reset.disabled", new Object[]{contextName, alternate.getQualifiedName()});
                }
                this.booleanContextParameters.put(alternate, value);
                continue;
            }
            if (param.isDeprecated()) continue;
            value = strValue == null ? param.getDefaultValue() : (this.isValueValid(param, strValue) ? Boolean.valueOf(strValue).booleanValue() : param.getDefaultValue());
            if (BooleanWebContextInitParameter.DisplayConfiguration.equals((Object)param) && value) {
                this.loggingLevel = Level.INFO;
            }
            if (LOGGER.isLoggable(this.loggingLevel)) {
                LOGGER.log(this.loggingLevel, value ? "jsf.config.webconfig.boolconfiginfo.enabled" : "jsf.config.webconfig.boolconfiginfo.disabled", new Object[]{contextName, param.getQualifiedName()});
            }
            this.booleanContextParameters.put(param, value);
        }
    }

    private void processInitParameters(ServletContext servletContext, String contextName) {
        for (WebContextInitParameter param : WebContextInitParameter.values()) {
            String value = servletContext.getInitParameter(param.getQualifiedName());
            if (value != null && value.length() > 0 && param.isDeprecated()) {
                WebContextInitParameter alternate = param.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, param.getQualifiedName(), alternate.getQualifiedName()});
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.webconfig.configinfo.reset", new Object[]{contextName, alternate.getQualifiedName(), value});
                }
                this.contextParameters.put(alternate, value);
                continue;
            }
            if (!(value != null && value.length() != 0 || param.isDeprecated())) {
                value = param.getDefaultValue();
            }
            if (value == null || value.length() == 0) continue;
            if (value.length() > 0) {
                if (LOGGER.isLoggable(this.loggingLevel)) {
                    LOGGER.log(this.loggingLevel, "jsf.config.webconfig.configinfo", new Object[]{contextName, param.getQualifiedName(), value});
                }
                this.contextParameters.put(param, value);
                continue;
            }
            if (!LOGGER.isLoggable(this.loggingLevel)) continue;
            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.option.notconfigured", new Object[]{contextName, param.getQualifiedName()});
        }
    }

    private void processJndiEntries(String contextName) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (initialContext != null) {
            for (WebEnvironmentEntry entry : WebEnvironmentEntry.values()) {
                String entryName = entry.getQualifiedName();
                try {
                    String value = (String)initialContext.lookup(entryName);
                    if (value == null) continue;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        if (!entry.equals((Object)WebEnvironmentEntry.ClientStateSavingPassword)) {
                            if (LOGGER.isLoggable(this.loggingLevel)) {
                                LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventryinfo", new Object[]{contextName, entryName, value});
                            }
                        } else if (LOGGER.isLoggable(this.loggingLevel)) {
                            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventry.clientencrypt", contextName);
                        }
                    }
                    this.envEntries.put(entry, value);
                }
                catch (NamingException ne) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebEnvironmentEntry {
        ClientStateSavingPassword("ClientStateSavingPassword");

        private static final String JNDI_PREFIX = "java:comp/env/";
        private String qualifiedName;

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebEnvironmentEntry(String qualifiedName) {
            this.qualifiedName = "java:comp/env/com.sun.faces." + qualifiedName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanWebContextInitParameter {
        DisplayConfiguration("com.sun.faces.displayConfiguration", false),
        ValidateFacesConfigFiles("com.sun.faces.validateXml", false),
        VerifyFacesConfigObjects("com.sun.faces.verifyObjects", false),
        ForceLoadFacesConfigFiles("com.sun.faces.forceLoadConfiguration", false),
        DisableArtifactVersioning("com.sun.faces.disableVersionTracking", false),
        EnableHtmlTagLibraryValidator("com.sun.faces.enableHtmlTagLibValidator", false),
        PreferXHTMLContentType("com.sun.faces.preferXHTML", false),
        PreferXHTMLContextTypeDeprecated("com.sun.faces.PreferXHTML", false, true, PreferXHTMLContentType),
        CompressViewState("com.sun.faces.compressViewState", true),
        CompressViewStateDeprecated("com.sun.faces.COMPRESS_STATE", true, true, CompressViewState),
        CompressJavaScript("com.sun.faces.compressJavaScript", true),
        ExternalizeJavaScript("com.sun.faces.externalizeJavaScript", false),
        SendPoweredByHeader("com.sun.faces.sendPoweredByHeader", true),
        EnableJSStyleHiding("com.sun.faces.enableJSStyleHiding", false);

        private BooleanWebContextInitParameter alternate;
        private String qualifiedName;
        private boolean defaultValue;
        private boolean deprecated;

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue, boolean deprecated, BooleanWebContextInitParameter alternate) {
            this.qualifiedName = qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        private BooleanWebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebContextInitParameter {
        ManagedBeanFactoryDecorator("com.sun.faces.managedBeanFactoryDecoratorClass", ""),
        StateSavingMethod("javax.faces.STATE_SAVING_METHOD", "server"),
        JspDefaultSuffix("javax.faces.DEFAULT_SUFFIX", ".jsp"),
        JavaxFacesConfigFiles("javax.faces.CONFIG_FILES", ""),
        AlternateLifecycleId("javax.faces.LIFECYCLE_ID", ""),
        NumberOfViews("com.sun.faces.numberOfViewsInSession", "15"),
        NumberOfViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION", "15", true, NumberOfViews),
        NumberOfLogicalViews("com.sun.faces.numberOfLogicalViews", "15"),
        NumberOfLogicalViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION", "15", true, NumberOfLogicalViews),
        InjectionProviderClass("com.sun.faces.injectionProvider", ""),
        SerializationProviderClass("com.sun.faces.serializationProvider", ""),
        ResponseBufferSize("com.sun.faces.responseBufferSize", "4096"),
        ClientStateWriteBufferSize("com.sun.faces.clientStateWriteBufferSize", "8192"),
        ExpressionFactory("com.sun.faces.expressionFactory", "com.sun.el.ExpressionFactoryImpl");

        private String defaultValue;
        private String qualifiedName;
        private WebContextInitParameter alternate;
        private boolean deprecated;

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue, boolean deprecated, WebContextInitParameter alternate) {
            this.qualifiedName = qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        private WebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

