/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.guiframework.util.LogUtil;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.util.List;
import java.util.logging.Level;

public class DebugHandlers {
    public static final String VALUE = "value";
    public static final String LABEL = "label";
    public static final String LEVEL = "level";
    public static final String EXCEPTION_TO_LOG = "exceptionToLog";

    public void println(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value;
        Level level = LogUtil.stringToLogLevel((String)handlerCtx.getInputValue(LEVEL));
        String label = (String)handlerCtx.getInputValue(LABEL);
        if (label == null) {
            label = "";
        }
        if ((value = handlerCtx.getInputValue(VALUE)) == null) {
            LogUtil.log(level, label + "null");
        } else if (value instanceof List) {
            List l = (List)value;
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o == null) {
                    LogUtil.log(level, label + "null");
                    continue;
                }
                LogUtil.log(level, label + o.toString());
            }
        } else if (value instanceof Exception) {
            LogUtil.log(level, label + ((Exception)value).getMessage());
        } else if (value != null) {
            LogUtil.log(level, label + value.toString());
        }
    }

    public void logException(RequestContext ctx, HandlerContext handlerCtx) {
        Throwable ex = (Throwable)handlerCtx.getInputValue(EXCEPTION_TO_LOG);
        String logLevel = (String)handlerCtx.getInputValue(LEVEL);
        if (logLevel == null) {
            logLevel = "FINE";
        }
        Level level = LogUtil.stringToLogLevel(logLevel);
        if (ex != null) {
            LogUtil.log(level, "", ex);
        } else {
            LogUtil.log(level, this.getClass().getName() + ".logException() called without an exception to log.");
        }
    }
}

