/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DBSchemaConnectionPanel
extends JPanel
implements ListDataListener {
    static final long serialVersionUID = 5364628520334696421L;
    private ArrayList dbconns;
    private ArrayList list;
    private DBSchemaWizardData data;
    private Node dbNode;
    private Node[] drvNodes;
    private JTextArea descriptionTextArea;
    private JComboBox existingConnComboBox;
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");

    public DBSchemaConnectionPanel(DBSchemaWizardData dBSchemaWizardData, ArrayList arrayList) {
        DataFolder dataFolder;
        this.list = arrayList;
        this.dbconns = new ArrayList();
        this.data = dBSchemaWizardData;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(this.bundle.getString("ConnectionChooser"));
        this.initComponents();
        this.resize();
        this.initAccessibility();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("UI/Runtime");
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        this.dbNode = dataFolder.getNodeDelegate().getChildren().findChild("Databases");
        this.fillConnectionCombo();
        this.existingConnComboBox.setSelectedIndex(0);
        this.existingConnComboBox.getModel().addListDataListener(this);
    }

    public JComboBox getComboBox() {
        return this.existingConnComboBox;
    }

    private void fillConnectionCombo() {
        this.dbconns.clear();
        this.existingConnComboBox.removeAllItems();
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            this.existingConnComboBox.addItem(databaseConnectionArray[i].getName());
            this.dbconns.add(databaseConnectionArray[i]);
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("NoConnection"), 0);
        } else {
            this.existingConnComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
        }
        this.existingConnComboBox.addItem(this.bundle.getString("NewConnectionButton"));
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ConnectionPanelA11yDesc"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_DescriptionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_ExistingConnectionA11yName"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingConnectionA11yDesc"));
    }

    private void resize() {
        int n = new Double(this.descriptionTextArea.getFontMetrics(this.descriptionTextArea.getFont()).getStringBounds(this.bundle.getString("Description"), this.getGraphics()).getWidth() / 2.0).intValue() + 160;
        int n2 = 300;
        if (n < 675) {
            n = 675;
        }
        if (n2 < 390) {
            n2 = 390;
        }
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.existingConnComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(this.bundle.getString("Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(this.bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.existingConnComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
    }

    private void newConnectionButtonActionPerformed(ActionEvent actionEvent) {
        final HashSet<DatabaseConnection> hashSet = new HashSet<DatabaseConnection>(Arrays.asList(ConnectionManager.getDefault().getConnections()));
        ConnectionListener connectionListener = new ConnectionListener(){

            public void connectionsChanged() {
                DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
                for (int i = 0; i < databaseConnectionArray.length; ++i) {
                    if (hashSet.contains(databaseConnectionArray[i])) continue;
                    DBSchemaConnectionPanel.this.existingConnComboBox.setSelectedItem(databaseConnectionArray[i]);
                }
            }
        };
        ConnectionManager.getDefault().addConnectionListener(connectionListener);
        ConnectionManager.getDefault().showAddConnectionDialog(null);
        ConnectionManager.getDefault().removeConnectionListener(connectionListener);
    }

    private void existingConnComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            if (this.existingConnComboBox.getItemCount() == this.existingConnComboBox.getSelectedIndex() + 1) {
                this.newConnectionButtonActionPerformed(actionEvent);
            } else {
                this.data.setDatabaseConnection((DatabaseConnection)this.dbconns.get(this.existingConnComboBox.getSelectedIndex() - 1));
            }
        }
    }

    public boolean isValid() {
        return this.existingConnComboBox.getSelectedIndex() > 0;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void initData() {
        this.data.setExistingConn(true);
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            this.data.setDatabaseConnection((DatabaseConnection)this.dbconns.get(this.existingConnComboBox.getSelectedIndex() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object object) {
        ArrayList arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            arrayList = (ArrayList)this.list.clone();
        }
        serializable = new ChangeEvent(object);
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            changeListener.stateChanged((ChangeEvent)serializable);
        }
    }
}

