/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMMemoryStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMMemoryStatsImpl
implements JVMMemoryStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMMemoryStats";
    private MutableCountStatistic initHeapSize;
    private MutableCountStatistic usedHeapSize;
    private MutableCountStatistic maxHeapSize;
    private MutableCountStatistic commitHeapSize;
    private MutableCountStatistic initNonHeapSize;
    private MutableCountStatistic maxNonHeapSize;
    private MutableCountStatistic usedNonHeapSize;
    private MutableCountStatistic commitNonHeapSize;
    private MutableCountStatistic objPendingCount;
    private MemoryUsage heapUsage;
    private MemoryUsage nonheapUsage;
    private MemoryMXBean bean;
    private static final String BYTE_UNITS = "monitor.stats.byte_units";
    private static final StringManager localStrMgr = StringManager.getManager(JVMMemoryStatsImpl.class);

    public JVMMemoryStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getMemoryMXBean();
        this.heapUsage = this.bean.getHeapMemoryUsage();
        this.nonheapUsage = this.bean.getNonHeapMemoryUsage();
        this.initializeStatistics();
    }

    private void initializeStatistics() {
        String bytes_str = localStrMgr.getString(BYTE_UNITS);
        CountStatisticImpl c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.initial_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.initial_heap_size_desc"));
        this.initHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.max_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.max_heap_size_desc"));
        this.maxHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.used_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.used_heap_size_desc"));
        this.usedHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.committed_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.committed_heap_size_desc"));
        this.commitHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.initial_non_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.initial_non_heap_size_desc"));
        this.initNonHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.max_non_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.max_non_heap_size_desc"));
        this.maxNonHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.used_non_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.used_non_heap_size_desc"));
        this.usedNonHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.committed_non_heap_size"), bytes_str, localStrMgr.getString("monitor.stats.committed_non_heap_size_desc"));
        this.commitNonHeapSize = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.objs_pending_serialization"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.objs_pending_serialization_desc"));
        this.objPendingCount = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getCommittedHeapSize() {
        this.commitHeapSize.setCount(this.heapUsage.getCommitted());
        return (CountStatistic)this.commitHeapSize.unmodifiableView();
    }

    public CountStatistic getCommittedNonHeapSize() {
        this.commitNonHeapSize.setCount(this.nonheapUsage.getCommitted());
        return (CountStatistic)this.commitNonHeapSize.unmodifiableView();
    }

    public CountStatistic getInitHeapSize() {
        this.initHeapSize.setCount(this.heapUsage.getInit());
        return (CountStatistic)this.initHeapSize.unmodifiableView();
    }

    public CountStatistic getInitNonHeapSize() {
        this.initNonHeapSize.setCount(this.nonheapUsage.getCommitted());
        return (CountStatistic)this.initNonHeapSize.unmodifiableView();
    }

    public CountStatistic getMaxHeapSize() {
        this.maxHeapSize.setCount(this.heapUsage.getMax());
        return (CountStatistic)this.maxHeapSize.unmodifiableView();
    }

    public CountStatistic getMaxNonHeapSize() {
        this.maxNonHeapSize.setCount(this.nonheapUsage.getInit());
        return (CountStatistic)this.maxNonHeapSize.unmodifiableView();
    }

    public CountStatistic getObjectPendingFinalizationCount() {
        this.objPendingCount.setCount(this.bean.getObjectPendingFinalizationCount());
        return (CountStatistic)this.objPendingCount.unmodifiableView();
    }

    public CountStatistic getUsedHeapSize() {
        this.usedHeapSize.setCount(this.heapUsage.getUsed());
        return (CountStatistic)this.usedHeapSize.unmodifiableView();
    }

    public CountStatistic getUsedNonHeapSize() {
        this.usedNonHeapSize.setCount(this.nonheapUsage.getUsed());
        return (CountStatistic)this.usedNonHeapSize.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }
}

