/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.wsmgmt.WebServiceEndpointEvent;
import com.sun.enterprise.admin.event.wsmgmt.WebServiceEndpointEventListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.lifecycle.AppServWSMonitorLifeCycleProvider;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceMgr;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;

public class WebServiceEndpointEventListenerImpl
implements WebServiceEndpointEventListener {
    public void handleDelete(WebServiceEndpointEvent event) throws AdminEventListenerException {
        try {
            ConfigBean bean = this.getWSEPBean(event, true);
            if (bean instanceof WebServiceEndpoint) {
                WebServiceEndpoint wsep = (WebServiceEndpoint)bean;
                String epName = wsep.getName();
                String appId = this.getApplicationId(wsep);
                MessageTraceMgr traceMgr = MessageTraceMgr.getInstance();
                traceMgr.disable(appId, epName);
                AppServWSMonitorLifeCycleProvider aplifeProv = new AppServWSMonitorLifeCycleProvider();
                aplifeProv.reconfigureMonitoring(wsep, appId, MonitoringLevel.instance(wsep.getMonitoring()), MonitoringLevel.instance("OFF"));
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException((Throwable)e);
        }
    }

    public void handleUpdate(WebServiceEndpointEvent event) throws AdminEventListenerException {
        try {
            ConfigBean bean = this.getWSEPBean(event, false);
            if (bean instanceof WebServiceEndpoint) {
                String endpointURI;
                WebServiceEndpoint wsep = (WebServiceEndpoint)bean;
                WebServiceEndpoint oWsep = (WebServiceEndpoint)this.getWSEPBean(event, true);
                String newMonitoring = wsep.getMonitoring();
                String oldMonitoring = oWsep.getMonitoring();
                int historySize = 25;
                String epName = wsep.getName();
                String hs = wsep.getMaxHistorySize();
                if (hs != null) {
                    historySize = Integer.parseInt(hs);
                }
                String appId = this.getApplicationId(wsep);
                MessageTraceMgr traceMgr = MessageTraceMgr.getInstance();
                if (newMonitoring != null && oldMonitoring != null && !newMonitoring.equals(oldMonitoring)) {
                    if ("HIGH".equalsIgnoreCase(newMonitoring)) {
                        traceMgr.enable(appId, epName, historySize);
                    } else if ("HIGH".equalsIgnoreCase(oldMonitoring)) {
                        traceMgr.disable(appId, epName);
                    }
                } else {
                    String oldHs = oWsep.getMaxHistorySize();
                    int oldHistorySize = 0;
                    if (oldHs != null) {
                        oldHistorySize = Integer.parseInt(oldHs);
                    }
                    if (historySize != oldHistorySize && "HIGH".equalsIgnoreCase(newMonitoring)) {
                        traceMgr.setMessageHistorySize(appId, epName, historySize);
                    }
                }
                AppServWSMonitorLifeCycleProvider aplifeProv = new AppServWSMonitorLifeCycleProvider();
                aplifeProv.reconfigureMonitoring(wsep, appId, MonitoringLevel.instance(oldMonitoring), MonitoringLevel.instance(newMonitoring));
                boolean jbiEnabledFlag = wsep.isJbiEnabled();
                boolean oldJbiEnabledSetting = oWsep.isJbiEnabled();
                if (jbiEnabledFlag != oldJbiEnabledSetting && (endpointURI = WebServiceMgrBackEnd.getManager().getEndpointURI(this.getApplicationId(wsep) + "#" + epName)) != null && ServiceEngineRtObjectFactory.getInstance().getFacade() != null) {
                    ServiceEngineRtObjectFactory.getInstance().getFacade().handleWebServiceEndpointEvent(endpointURI, jbiEnabledFlag);
                }
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException((Throwable)e);
        }
    }

    public void handleCreate(WebServiceEndpointEvent event) throws AdminEventListenerException {
        try {
            ConfigBean bean = this.getWSEPBean(event, false);
            if (bean instanceof WebServiceEndpoint) {
                String newMonitoring;
                WebServiceEndpoint wsep = (WebServiceEndpoint)bean;
                int historySize = 25;
                String epName = wsep.getName();
                String appId = this.getApplicationId(wsep);
                String hs = wsep.getMaxHistorySize();
                if (hs != null) {
                    historySize = Integer.parseInt(hs);
                }
                if ("HIGH".equalsIgnoreCase(newMonitoring = wsep.getMonitoring())) {
                    MessageTraceMgr traceMgr = MessageTraceMgr.getInstance();
                    traceMgr.enable(appId, epName, historySize);
                }
                AppServWSMonitorLifeCycleProvider aplifeProv = new AppServWSMonitorLifeCycleProvider();
                aplifeProv.reconfigureMonitoring(wsep, appId, MonitoringLevel.instance("OFF"), MonitoringLevel.instance(wsep.getMonitoring()));
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException((Throwable)e);
        }
    }

    private ConfigBean getWSEPBean(WebServiceEndpointEvent event, boolean old) throws ConfigException {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        ConfigBean bean = null;
        ConfigContext ctx = null;
        String xpath = event.getElementXPath();
        ctx = old ? event.getOldConfigContext() : event.getConfigContext();
        if (ctx != null) {
            bean = ctx.exactLookup(xpath);
        }
        return bean;
    }

    private String getApplicationId(WebServiceEndpoint bean) {
        String name = null;
        if (bean != null) {
            ConfigBean parent = (ConfigBean)bean.parent();
            if (parent instanceof J2eeApplication) {
                J2eeApplication app = (J2eeApplication)parent;
                name = app.getName();
            } else if (parent instanceof WebModule) {
                WebModule wm = (WebModule)parent;
                name = wm.getName();
            } else if (parent instanceof EjbModule) {
                EjbModule em = (EjbModule)parent;
                name = em.getName();
            }
        }
        return name;
    }
}

