/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public class VirtualServerTest
extends GenericValidator {
    public VirtualServerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        try {
            if (cce.getChoice().equals("ADD") || cce.getChoice().equals("VALIDATE")) {
                ConfigContext context = cce.getConfigContext();
                VirtualServer virtual = (VirtualServer)cce.getValidationTarget();
                Config config = (Config)((HttpService)cce.getClassObject()).parent();
                this.validateAttribute("http-listeners", virtual.getHttpListeners(), config, result);
                this.validateAttribute("hosts", virtual.getHosts(), config, result);
            } else if (cce.getChoice().equals("UPDATE")) {
                VirtualServer vs = (VirtualServer)cce.getClassObject();
                Config config = (Config)vs.parent().parent();
                String name = cce.getName();
                String value = (String)cce.getObject();
                this.validateAttribute(name, value, config, result);
                if (name.equals("state") && !value.equals("on")) {
                    this.checkAllRelatedHttpListenersAreDisabled(vs, result);
                }
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

    private Set getReferers(VirtualServer vs) throws ConfigException {
        Set listeners = this.getPeerListeners(vs);
        if (listeners.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<HttpListener> result = new HashSet<HttpListener>();
        for (HttpListener l : listeners) {
            if (!l.getDefaultVirtualServer().equals(vs.getId())) continue;
            result.add(l);
        }
        return result;
    }

    private Set getPeerListeners(VirtualServer vs) throws ConfigException {
        HttpService hs = (HttpService)vs.parent();
        if (null == hs) {
            return Collections.EMPTY_SET;
        }
        HashSet<HttpListener> result = new HashSet<HttpListener>();
        result.addAll(Arrays.asList(hs.getHttpListener()));
        return result;
    }

    public void validateAttribute(String name, String value, Config config, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals("hosts")) {
            Vector address = this.tokens(value);
            for (int i = 0; i < address.size(); ++i) {
                try {
                    StaticTest.checkIPAddress((String)address.get(i));
                    continue;
                }
                catch (UnknownHostException u) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHostsAddress", "Invalid value for virtual server's ''{0}'' attribute. ''{1}'' is incorrect network address. ", new Object[]{name, (String)address.get(i)}));
                }
            }
        }
    }

    public Vector tokens(String value) {
        StringTokenizer token = new StringTokenizer(value, ",");
        Vector<String> test = new Vector<String>();
        while (token.hasMoreTokens()) {
            test.add(token.nextToken());
        }
        return test;
    }

    private final void checkAllRelatedHttpListenersAreDisabled(VirtualServer vs, Result result) throws ConfigException {
        for (HttpListener l : this.getReferers(vs)) {
            if (!l.isEnabled()) continue;
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".listenerEnabled", "Cannot disable the virtual server \"{0}\" because this is the default virtual server for the http listener \"{1}\".", new Object[]{vs.getId(), l.getId()}));
        }
    }

    private final VirtualServer getVirtualServer(ConfigContextEvent cce) throws ConfigException {
        return (VirtualServer)cce.getValidationTarget();
    }
}

