/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.Description;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.ObjectType;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.RefConfigReferent;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.helper.RefHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.OldPropertiesImpl;
import com.sun.enterprise.management.config.OldSystemPropertiesImpl;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldProperties;
import com.sun.enterprise.management.support.oldconfig.OldSystemProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXConfigImplBase
extends AMXImplBase
implements AMXConfig {
    private static final String CREATE = "create";
    private static final String CREATE_PREFIX = "create";
    private static final String REMOVE_PREFIX = "remove";
    private static final String CONFIG_SUFFIX = "Config";
    private static final String FACTORY_SUFFIX = "Factory";
    private static final Class[] STRING_SIG = new Class[]{String.class};
    private static final Set<String> CR_PREFIXES = GSetUtil.newUnmodifiableStringSet("create", "remove");
    private static final Class[] FACTORY_CONSTRUCTOR_SIG = new Class[]{ConfigFactoryCallback.class};

    protected AMXConfigImplBase(Delegate delegate) {
        super(delegate);
    }

    protected boolean supportsProperties() {
        return PropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    protected boolean supportsSystemProperties() {
        return SystemPropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    protected final void checkPropertiesAccessSupport() {
        if (this.getDelegate() != null) {
            boolean delegateHasProperties = this.delegateSupportsProperties();
            if (delegateHasProperties != this.supportsProperties()) {
                String msg = this.getJ2EEType() + ": " + "delegateSupportsProperties=" + delegateHasProperties + ", but supportsProperties=" + this.supportsProperties();
                this.logWarning(msg);
                throw new Error(msg);
            }
        } else if (this.supportsProperties()) {
            String msg = this.getJ2EEType() + ": " + "AMX interface supports properties, but has no delegate";
            this.logSevere(msg);
            throw new Error(msg);
        }
    }

    private boolean delegateSupportsSystemProperties() {
        boolean supports = true;
        OldSystemProperties old = this.getOldSystemProperties();
        try {
            AttributeList props = old.getSystemProperties();
            supports = true;
        }
        catch (Exception e) {
            supports = false;
        }
        return supports;
    }

    private boolean delegateSupportsProperties() {
        boolean supports = true;
        OldProperties old = this.getOldProperties();
        try {
            AttributeList props = old.getProperties();
            supports = true;
        }
        catch (Exception e) {
            supports = false;
        }
        return supports;
    }

    protected final void checkSystemPropertiesAccessSupport() {
        if (this.getDelegate() != null) {
            boolean delegateSupports = this.delegateSupportsSystemProperties();
            if (delegateSupports != this.supportsSystemProperties()) {
                String msg = this.getJ2EEType() + ": " + "delegateSupportsSystemProperties=" + delegateSupports + ", but supportsSystemProperties=" + this.supportsSystemProperties();
                this.logWarning(msg);
                throw new Error(msg);
            }
        } else if (this.supportsSystemProperties()) {
            String msg = this.getJ2EEType() + ": " + "AMX interface supports system properties, but has no delegate";
            this.logSevere(msg);
            throw new Error(msg);
        }
    }

    protected final void checkInterfaceSupport(Class<?> theInterface, String attributeToCheck) {
        boolean supported;
        boolean delegateSupports;
        if (this.getDelegate() != null && (delegateSupports = this.getDelegate().supportsAttribute(attributeToCheck)) != (supported = theInterface.isAssignableFrom(this.getInterface()))) {
            String msg = "ERROR: " + this.getJ2EEType() + ": " + "AMX interface does not match Delegate capabilities for " + "interface " + theInterface.getName() + ", " + "delegate support = " + delegateSupports + ", AMX support = " + supported;
            this.logSevere(msg);
            throw new Error(msg);
        }
    }

    @Override
    protected final Set<String> getSuperfluousMethods() {
        Method[] methods;
        Set<String> items = super.getSuperfluousMethods();
        for (Method m : methods = this.getClass().getMethods()) {
            String name = m.getName();
            if (!this.isConfigFactoryGetter(name) && !this.isRemoveConfig(name) && !this.isCreateConfig(name) || m.getParameterTypes().length > 1) continue;
            items.add(name);
        }
        return items;
    }

    @Override
    protected final void implCheck() {
        super.implCheck();
        if (!BootUtil.getInstance().getOffline()) {
            this.checkPropertiesAccessSupport();
            this.checkSystemPropertiesAccessSupport();
        }
        this.checkInterfaceSupport(Description.class, "Description");
        this.checkInterfaceSupport(ObjectType.class, "ObjectType");
        this.checkInterfaceSupport(Enabled.class, "Enabled");
    }

    private static void validatePropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Illegal property name: " + StringUtil.quote(propertyName));
        }
    }

    protected OldSystemProperties getOldSystemProperties() {
        if (!this.haveDelegate()) {
            String msg = "system properties not supported (no delegate) by " + AMXConfigImplBase.quote(this.getObjectName());
            throw new IllegalArgumentException(msg);
        }
        return new OldSystemPropertiesImpl(this.getDelegate());
    }

    public Map<String, String> getSystemProperties() {
        AttributeList props = this.getOldSystemProperties().getSystemProperties();
        Map<String, String> result = JMXUtil.attributeListToStringMap(props);
        return result;
    }

    public String[] getSystemPropertyNames() {
        Set<String> names = this.getSystemProperties().keySet();
        return GSetUtil.toStringArray(names);
    }

    public String getSystemPropertyValue(String propertyName) {
        return this.getOldSystemProperties().getSystemPropertyValue(propertyName);
    }

    public final void setSystemPropertyValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("" + null);
        }
        Attribute attr = new Attribute(propertyName, propertyValue);
        this.getOldSystemProperties().setSystemProperty(attr);
    }

    public final boolean existsSystemProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        return GSetUtil.newSet(this.getSystemPropertyNames()).contains(propertyName);
    }

    public final void removeSystemProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.getOldSystemProperties().setSystemProperty(new Attribute(propertyName, null));
    }

    public final void createSystemProperty(String propertyName, String propertyValue) {
        this.setSystemPropertyValue(propertyName, propertyValue);
    }

    protected OldProperties getOldProperties() {
        if (!this.haveDelegate()) {
            String msg = "properties not supported (no delegate) by " + AMXConfigImplBase.quote(this.getObjectName());
            throw new IllegalArgumentException(msg);
        }
        return new OldPropertiesImpl(this.getDelegate());
    }

    public Map<String, String> getProperties() {
        AttributeList props = this.getOldProperties().getProperties();
        return JMXUtil.attributeListToStringMap(props);
    }

    public String[] getPropertyNames() {
        Set<String> names = this.getProperties().keySet();
        return GSetUtil.toStringArray(names);
    }

    public String getPropertyValue(String propertyName) {
        return this.getOldProperties().getPropertyValue(propertyName);
    }

    public final void setPropertyValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("null");
        }
        Attribute attr = new Attribute(propertyName, propertyValue);
        this.getOldProperties().setProperty(attr);
    }

    public final boolean existsProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        return GSetUtil.newSet(this.getPropertyNames()).contains(propertyName);
    }

    public final void removeProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.getOldProperties().setProperty(new Attribute(propertyName, null));
    }

    public final void createProperty(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.setPropertyValue(propertyName, propertyValue);
    }

    @Override
    public final String getGroup() {
        return "configuration";
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        String description = "";
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo attributeChange = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{attributeChange};
        MBeanNotificationInfo[] allInfos = JMXUtil.mergeMBeanNotificationInfos(superInfos, selfInfos);
        return allInfos;
    }

    private String getSimpleInterfaceName(AMX amx) {
        String fullInterfaceName = Util.getExtra(amx).getInterfaceName();
        String interfaceName = ClassUtil.stripPackageName(fullInterfaceName);
        return interfaceName;
    }

    protected void preRemove(ObjectName objectName) {
        AMXConfig amxConfig = this.getProxy(objectName, AMXConfig.class);
        if (amxConfig instanceof RefConfigReferent) {
            this.debug("*** Removing all references to ", objectName);
            Set failures = RefHelper.removeAllRefsTo((RefConfigReferent)((Object)amxConfig), true);
            if (failures.size() != 0) {
                this.debug((Object)("FAILURE removing references to " + objectName + ": " + CollectionUtil.toString(Util.toObjectNames(failures))));
            }
        } else {
            this.debug("*** not a RefConfigReferent: ", objectName);
        }
    }

    protected ObjectName preRemove(Map<String, ObjectName> items, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        ObjectName objectName = items.get(name);
        if (objectName == null) {
            throw new IllegalArgumentException("Item not found: " + name);
        }
        this.preRemove(objectName);
        return objectName;
    }

    protected final boolean removeConfigWithFactory(ObjectName objectName) {
        Object factory = null;
        boolean attempted = false;
        try {
            AMXConfig amxConfig = this.getProxy(objectName, AMXConfig.class);
            String interfaceName = this.getSimpleInterfaceName(amxConfig);
            this.debug((Object)("removeConfigWithFactory: " + objectName));
            factory = this.createConfigFactory(interfaceName);
        }
        catch (Exception e) {
            this.debug((Object)ExceptionUtil.toString(e));
        }
        if (factory != null) {
            attempted = true;
            try {
                Method m = factory.getClass().getMethod(REMOVE_PREFIX, null);
                if (m != null) {
                    m.invoke(factory, (Object[])null);
                }
            }
            catch (NoSuchMethodException e) {
                ((ConfigFactory)factory).remove(objectName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return attempted;
    }

    protected final void removeConfigWithMethod(ObjectName objectName) {
        AMXConfig amxConfig = this.getProxy(objectName, AMXConfig.class);
        String interfaceName = this.getSimpleInterfaceName(amxConfig);
        if (!interfaceName.endsWith(CONFIG_SUFFIX)) {
            throw new IllegalArgumentException("Interface doesn't end in Config: " + interfaceName);
        }
        String operationName = REMOVE_PREFIX + interfaceName;
        this.debug("removing config generically by calling ", operationName, "()");
        try {
            Method m = this.getClass().getDeclaredMethod(operationName, STRING_SIG);
            m.invoke((Object)this, amxConfig.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void removeConfig(String j2eeType, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map<String, ObjectName> items = this.getContaineeObjectNameMap(j2eeType);
        ObjectName objectName = this.preRemove(items, name);
        if (!this.removeConfigWithFactory(objectName)) {
            this.debug((Object)"removeConfigWithFactory failed, using removeConfigWithMethod");
            this.removeConfigWithMethod(objectName);
        }
    }

    protected void removeRefConfig(String j2eeType, String name) {
        this.removeConfig(j2eeType, name);
    }

    private boolean isRemoveConfig(String operationName) {
        return operationName.startsWith(REMOVE_PREFIX) && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isRemoveConfig(String operationName, Object[] args, String[] types) {
        boolean isRemove;
        int numArgs = args == null ? 0 : args.length;
        boolean bl = isRemove = numArgs <= 1 && this.isRemoveConfig(operationName);
        if (isRemove && numArgs == 1) {
            isRemove = types[0].equals(String.class.getName());
        }
        return isRemove;
    }

    private boolean isCreateConfig(String operationName) {
        return operationName.startsWith("create") && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isConfigFactoryGetter(String operationName, Object[] args, String[] types) {
        int numArgs = args == null ? 0 : args.length;
        return numArgs == 0 && this.isConfigFactoryGetter(operationName);
    }

    private boolean isConfigFactoryGetter(String operationName) {
        return operationName.startsWith("get") && operationName.endsWith(FACTORY_SUFFIX) && !operationName.equals("getProxyFactory");
    }

    protected ObjectName createConfig(String simpleInterfaceName, Object[] args, String[] types) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        ObjectName result = null;
        Class[] sig = ClassUtil.signatureFromClassnames(types);
        ConfigFactory factory = this.createConfigFactory(simpleInterfaceName);
        if (factory == null) {
            String createMethodName = "create" + simpleInterfaceName;
            Method m = this.getClass().getMethod(createMethodName, sig);
            if (m == null) {
                throw new RuntimeException("Can't find ConfigFactory for " + simpleInterfaceName);
            }
        } else {
            Method createMethod = factory.getClass().getDeclaredMethod("create", sig);
            if (createMethod != null) {
                result = (ObjectName)createMethod.invoke((Object)factory, args);
            } else {
                String msg = "Can't find method create in factory " + factory.getClass().getName();
                throw new NoSuchMethodException(msg);
            }
        }
        return result;
    }

    protected String operationNameToSimpleClassname(String operationName) {
        return StringUtil.findAndStripPrefix(CR_PREFIXES, operationName);
    }

    @Override
    protected String operationNameToJ2EEType(String operationName) {
        String j2eeType = null;
        j2eeType = this.isRemoveConfig(operationName) || this.isCreateConfig(operationName) ? "X-" + this.operationNameToSimpleClassname(operationName) : super.operationNameToJ2EEType(operationName);
        return j2eeType;
    }

    protected void removeConfig(String operationName) {
        String j2eeType = this.operationNameToJ2EEType(operationName);
        ObjectName objectName = this.getContaineeObjectName(j2eeType);
        if (objectName == null) {
            throw new RuntimeException(new InstanceNotFoundException(j2eeType));
        }
        this.preRemove(objectName);
        String simpleInterfaceName = operationName.substring(REMOVE_PREFIX.length(), operationName.length());
        this.createConfigFactory(simpleInterfaceName).remove(objectName);
    }

    protected void removeConfig(String operationName, Object[] args, String[] types) throws InvocationTargetException {
        String name = (String)args[0];
        String simpleInterfaceName = operationName.substring(REMOVE_PREFIX.length(), operationName.length());
        Set containees = this.getFactoryContainer().getContaineeSet();
        ObjectName objectName = null;
        for (AMX containee : containees) {
            if (!containee.getName().equals(name)) continue;
            this.debug((Object)("removeConfig: found name match: " + Util.getObjectName(containee)));
            if (this.getSimpleInterfaceName(containee).equals(simpleInterfaceName)) {
                objectName = Util.getObjectName(containee);
                break;
            }
            this.debug(this.getSimpleInterfaceName(containee), " != ", simpleInterfaceName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Not found: " + name);
        }
        AMX amx = this.getProxy(objectName, AMX.class);
        this.removeConfig(amx.getJ2EEType(), amx.getName());
    }

    protected String getFactoryPackage() {
        return this.getClass().getPackage().getName();
    }

    protected ConfigFactory createConfigFactory(String simpleClassname) {
        ConfigFactory factory = null;
        try {
            String classname = this.getFactoryPackage() + "." + simpleClassname + FACTORY_SUFFIX;
            Class factoryClass = ClassUtil.getClassFromName(classname);
            Constructor constructor = factoryClass.getConstructor(FACTORY_CONSTRUCTOR_SIG);
            if (constructor == null) {
                throw new RuntimeException("No ConfigFactory found for " + classname);
            }
            factory = (ConfigFactory)constructor.newInstance(this);
        }
        catch (Exception e) {
            this.debug((Object)ExceptionUtil.toString(e));
            throw new RuntimeException(e);
        }
        return factory;
    }

    @Override
    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        if (this.isConfigFactoryGetter(operationName, args, types) && ConfigFactoryCallback.class.isAssignableFrom(this.getClass())) {
            this.debug((Object)("looking for factory denoted by " + operationName));
            result = this.createConfigFactory(operationName);
            if (result == null) {
                this.debug((Object)("FAILED TO FIND factory denoted by " + operationName));
                result = super.invokeManually(operationName, args, types);
            }
        } else if (this.isRemoveConfig(operationName, args, types)) {
            try {
                if (numArgs == 0) {
                    this.removeConfig(operationName);
                }
                this.removeConfig(operationName, args, types);
            }
            catch (InvocationTargetException e) {
                throw new MBeanException(e);
            }
        } else if (this.isCreateConfig(operationName)) {
            String simpleInterfaceName = operationName.substring("create".length(), operationName.length());
            try {
                result = this.createConfig(simpleInterfaceName, args, types);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        } else {
            result = super.invokeManually(operationName, args, types);
        }
        return result;
    }

    public String getConfigName() {
        return this.getKeyProperty("X-ConfigConfig");
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigCreated", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigRemoved", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }
}

