/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.ServerRefConfigCR;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldCreateRemoveServerRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerRefConfigFactory
extends ConfigFactory {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("DisableTimeoutInMinutes", "LBEnabled", "Enabled");

    public ServerRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "ref");
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    private OldCreateRemoveServerRef getOldCreateRemoveServerRef() {
        ServerRefConfigCR fc = (ServerRefConfigCR)((Object)this.getFactoryContainer());
        String name = Util.asAMX(fc).getName();
        OldCreateRemoveServerRef result = null;
        if (fc instanceof ClusterConfig) {
            result = this.getOldConfigProxies().getOldClusterMBean(name);
        } else if (fc instanceof LBConfig) {
            result = this.getOldConfigProxies().getOldLbConfig(name);
        }
        return result;
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.getOldCreateRemoveServerRef().createServerRef(translatedAttrs);
    }

    public ObjectName create(String referencedServerName, Map<String, String> optional) {
        String[] requiredParams = new String[]{};
        Map<String, String> params = this.initParams(referencedServerName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(referencedServerName, params);
        return amxName;
    }

    public ObjectName create(String referencedServerName, String disableTimeoutInMinutes, boolean lbEnabled, boolean enabled) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("DisableTimeoutInMinutes", disableTimeoutInMinutes);
        optionalParams.put("LBEnabled", Boolean.toString(lbEnabled));
        optionalParams.put("Enabled", Boolean.toString(enabled));
        return this.create(referencedServerName, optionalParams);
    }

    @Override
    public void removeByName(String referencedServerName) {
        this.getOldCreateRemoveServerRef().removeServerRefByRef(referencedServerName);
    }
}

