/*
 * Decompiled with CFR 0.152.
 */
package applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Clock2
extends Applet
implements Runnable {
    Thread timer;
    int lastxs;
    int lastys;
    int lastxm;
    int lastym;
    int lastxh;
    int lastyh;
    SimpleDateFormat formatter;
    String lastdate;
    Font clockFaceFont;
    Date currentDate;
    Color handColor;
    Color numberColor;

    public void init() {
        this.lastyh = 0;
        this.lastxh = 0;
        this.lastym = 0;
        this.lastxm = 0;
        this.lastys = 0;
        this.lastxs = 0;
        this.formatter = new SimpleDateFormat("EEE MMM dd hh:mm:ss yyyy", Locale.getDefault());
        this.currentDate = new Date();
        this.lastdate = this.formatter.format(this.currentDate);
        this.clockFaceFont = new Font("Serif", 0, 14);
        this.handColor = Color.blue;
        this.numberColor = Color.darkGray;
        try {
            this.setBackground(new Color(Integer.parseInt(this.getParameter("bgcolor"), 16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.handColor = new Color(Integer.parseInt(this.getParameter("fgcolor1"), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.numberColor = new Color(Integer.parseInt(this.getParameter("fgcolor2"), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resize(300, 300);
    }

    public void plotpoints(int n, int n2, int n3, int n4, Graphics graphics) {
        graphics.drawLine(n + n3, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n4, n2 + n3, n + n4, n2 + n3);
        graphics.drawLine(n + n4, n2 - n3, n + n4, n2 - n3);
        graphics.drawLine(n + n3, n2 - n4, n + n3, n2 - n4);
        graphics.drawLine(n - n3, n2 - n4, n - n3, n2 - n4);
        graphics.drawLine(n - n4, n2 - n3, n - n4, n2 - n3);
        graphics.drawLine(n - n4, n2 + n3, n - n4, n2 + n3);
        graphics.drawLine(n - n3, n2 + n4, n - n3, n2 + n4);
    }

    public void circle(int n, int n2, int n3, Graphics graphics) {
        int n4 = 0;
        int n5 = n3;
        float f = 1 - n3;
        this.plotpoints(n, n2, n4, n5, graphics);
        while (n5 > n4) {
            if (f < 0.0f) {
                f = f + (float)(2 * n4) + 3.0f;
                ++n4;
            } else {
                f = f + (float)(2 * (n4 - n5)) + 5.0f;
                ++n4;
                --n5;
            }
            this.plotpoints(n, n2, n4, n5, graphics);
        }
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 10;
        int n3 = 10;
        this.currentDate = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("s", Locale.getDefault());
        try {
            n = Integer.parseInt(simpleDateFormat.format(this.currentDate));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        simpleDateFormat.applyPattern("m");
        try {
            n2 = Integer.parseInt(simpleDateFormat.format(this.currentDate));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 10;
        }
        simpleDateFormat.applyPattern("h");
        try {
            n3 = Integer.parseInt(simpleDateFormat.format(this.currentDate));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 10;
        }
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        String string = simpleDateFormat.format(this.currentDate);
        int n4 = 80;
        int n5 = 55;
        int n6 = (int)(Math.cos((float)n * 3.14f / 30.0f - 1.57f) * 45.0 + (double)n4);
        int n7 = (int)(Math.sin((float)n * 3.14f / 30.0f - 1.57f) * 45.0 + (double)n5);
        int n8 = (int)(Math.cos((float)n2 * 3.14f / 30.0f - 1.57f) * 40.0 + (double)n4);
        int n9 = (int)(Math.sin((float)n2 * 3.14f / 30.0f - 1.57f) * 40.0 + (double)n5);
        int n10 = (int)(Math.cos((float)(n3 * 30 + n2 / 2) * 3.14f / 180.0f - 1.57f) * 30.0 + (double)n4);
        int n11 = (int)(Math.sin((float)(n3 * 30 + n2 / 2) * 3.14f / 180.0f - 1.57f) * 30.0 + (double)n5);
        graphics.setFont(this.clockFaceFont);
        graphics.setColor(this.handColor);
        this.circle(n4, n5, 50, graphics);
        graphics.setColor(this.numberColor);
        graphics.drawString("9", n4 - 45, n5 + 3);
        graphics.drawString("3", n4 + 40, n5 + 3);
        graphics.drawString("12", n4 - 5, n5 - 37);
        graphics.drawString("6", n4 - 3, n5 + 45);
        graphics.setColor(this.getBackground());
        if (n6 != this.lastxs || n7 != this.lastys) {
            graphics.drawLine(n4, n5, this.lastxs, this.lastys);
            graphics.drawString(this.lastdate, 5, 125);
        }
        if (n8 != this.lastxm || n9 != this.lastym) {
            graphics.drawLine(n4, n5 - 1, this.lastxm, this.lastym);
            graphics.drawLine(n4 - 1, n5, this.lastxm, this.lastym);
        }
        if (n10 != this.lastxh || n11 != this.lastyh) {
            graphics.drawLine(n4, n5 - 1, this.lastxh, this.lastyh);
            graphics.drawLine(n4 - 1, n5, this.lastxh, this.lastyh);
        }
        graphics.setColor(this.numberColor);
        graphics.drawString("", 5, 125);
        graphics.drawString(string, 5, 125);
        graphics.drawLine(n4, n5, n6, n7);
        graphics.setColor(this.handColor);
        graphics.drawLine(n4, n5 - 1, n8, n9);
        graphics.drawLine(n4 - 1, n5, n8, n9);
        graphics.drawLine(n4, n5 - 1, n10, n11);
        graphics.drawLine(n4 - 1, n5, n10, n11);
        this.lastxs = n6;
        this.lastys = n7;
        this.lastxm = n8;
        this.lastym = n9;
        this.lastxh = n10;
        this.lastyh = n11;
        this.lastdate = string;
        this.currentDate = null;
    }

    public void start() {
        this.timer = new Thread((Runnable)this);
        this.timer.start();
    }

    public void stop() {
        this.timer = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.timer == thread) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getAppletInfo() {
        return "Title: A Clock \nAuthor: Rachel Gollub, 1995 \nAn analog clock.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"bgcolor", "hexadecimal RGB number", "The background color. Default is the color of your browser."}, {"fgcolor1", "hexadecimal RGB number", "The color of the hands and dial. Default is blue."}, {"fgcolor2", "hexadecimal RGB number", "The color of the seconds hand and numbers. Default is dark gray."}};
        return stringArray;
    }
}

