/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.ClassInfo;
import com.sun.corba.ee.impl.codegen.Field;
import com.sun.corba.ee.impl.codegen.MethodInfo;
import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.impl.codegen.NodeBase;
import com.sun.corba.ee.spi.codegen.Signature;
import com.sun.corba.ee.spi.codegen.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassInfoBase
extends NodeBase
implements ClassInfo {
    protected int modifiers;
    protected Type thisType;
    private boolean initComplete;
    private int hashValue;
    private boolean hashIsCached;
    protected boolean isInterface;
    protected Type superType;
    protected List<Type> impls;
    protected Map<String, Field> fields;
    protected Map<String, Set<MethodInfo>> methodInfoByName;

    public ClassInfoBase(Node parent, int modifiers, Type thisType) {
        super(parent);
        this.modifiers = modifiers;
        this.thisType = thisType;
        this.initComplete = false;
        this.hashValue = 0;
        this.hashIsCached = false;
    }

    private void checkComplete() {
        if (!this.initComplete) {
            throw new IllegalStateException("ClassInfoBase initialization is not complete");
        }
    }

    private void checkReinitialize() {
        if (this.initComplete) {
            throw new IllegalStateException("ClassInfoBase cannot be reinitialized");
        }
    }

    protected void initializeInterface(List<Type> exts, Map<String, Field> fields) {
        this.checkReinitialize();
        this.isInterface = true;
        this.superType = null;
        this.impls = exts;
        this.fields = fields;
        this.methodInfoByName = new HashMap<String, Set<MethodInfo>>();
        this.initComplete = true;
    }

    protected void initializeInterface(List<Type> exts) {
        this.initializeInterface(exts, new HashMap<String, Field>());
    }

    protected void initializeClass(Type superType, List<Type> impls, Map<String, Field> fields) {
        this.checkReinitialize();
        this.isInterface = false;
        this.superType = superType;
        this.impls = impls;
        this.fields = fields;
        this.methodInfoByName = new HashMap<String, Set<MethodInfo>>();
        this.initComplete = true;
    }

    protected void initializeClass(Type superType, List<Type> impls) {
        this.initializeClass(superType, impls, new HashMap<String, Field>());
    }

    protected void addMethodInfo(MethodInfo minfo) {
        Set<MethodInfo> minfos = this.methodInfoByName.get(minfo.name());
        if (minfos == null) {
            minfos = new HashSet<MethodInfo>();
            this.methodInfoByName.put(minfo.name(), minfos);
        }
        minfos.add(minfo);
    }

    @Override
    public boolean isInterface() {
        this.checkComplete();
        return this.isInterface;
    }

    @Override
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    public String name() {
        return this.thisType.name();
    }

    @Override
    public Type thisType() {
        return this.thisType;
    }

    @Override
    public Type superType() {
        this.checkComplete();
        return this.superType;
    }

    @Override
    public List<Type> impls() {
        this.checkComplete();
        return this.impls;
    }

    @Override
    public Map<String, Field> fields() {
        this.checkComplete();
        return this.fields;
    }

    @Override
    public Map<String, Set<MethodInfo>> methodInfoByName() {
        return this.methodInfoByName;
    }

    public boolean equals(Object obj) {
        HashSet<MethodInfo> otherCinfo;
        this.checkComplete();
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)ClassInfo.class.cast(obj);
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!this.thisType().equals(other.thisType())) {
            return false;
        }
        if (this.isInterface() != other.isInterface()) {
            return false;
        }
        if (this.modifiers() != other.modifiers()) {
            return false;
        }
        if (!this.name().equals(other.name())) {
            return false;
        }
        if (this.superType() == null ? other.superType() != null : !this.superType().equals(other.superType())) {
            return false;
        }
        if (!((Object)this.impls()).equals(other.impls())) {
            return false;
        }
        if (!((Object)this.fields().entrySet()).equals(other.fields().entrySet())) {
            return false;
        }
        if (!((Object)this.methodInfoByName()).equals(other.methodInfoByName())) {
            return false;
        }
        HashSet<MethodInfo> cinfo = new HashSet<MethodInfo>(this.constructorInfo());
        return ((Object)cinfo).equals(otherCinfo = new HashSet<MethodInfo>(other.constructorInfo()));
    }

    public String toString() {
        this.checkComplete();
        String className = this.getClass().getName();
        int lindex = className.lastIndexOf(46);
        if (lindex >= 0) {
            className = className.substring(lindex + 1);
        }
        return className + "[" + this.name() + "]";
    }

    synchronized void clearHashCode() {
        this.hashIsCached = false;
        this.hashValue = 0;
    }

    public synchronized int hashCode() {
        this.checkComplete();
        if (!this.hashIsCached) {
            this.hashValue ^= this.thisType().hashCode();
            this.hashValue ^= this.isInterface() ? 0 : 1;
            this.hashValue ^= this.modifiers();
            if (this.superType() != null) {
                this.hashValue ^= this.superType().hashCode();
            }
            this.hashValue ^= ((Object)this.impls()).hashCode();
            this.hashValue ^= ((Object)this.fields()).hashCode();
            this.hashValue ^= ((Object)this.methodInfoByName()).hashCode();
            this.hashValue ^= ((Object)this.constructorInfo()).hashCode();
            this.hashIsCached = true;
        }
        return this.hashValue;
    }

    private MethodInfo findMethodInfo(Signature sig, Set<MethodInfo> minfos) {
        if (minfos != null) {
            for (MethodInfo minfo : minfos) {
                if (!sig.equals(minfo.signature())) continue;
                return minfo;
            }
        }
        return null;
    }

    @Override
    public MethodInfo findMethodInfo(String name, Signature sig) {
        MethodInfo result = null;
        try {
            ClassInfo current = this;
            while (current != null) {
                Set<MethodInfo> minfos = current.methodInfoByName().get(name);
                result = this.findMethodInfo(sig, minfos);
                if (result != null) {
                    return result;
                }
                if (current.superType() == null) {
                    current = null;
                    continue;
                }
                current = current.superType().classInfo();
            }
            for (Type type : this.impls) {
                result = type.classInfo().findMethodInfo(name, sig);
                if (result == null) continue;
                return result;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        return result;
    }

    @Override
    public boolean isSubclass(ClassInfo info) {
        try {
            if (info.equals(this.superType().classInfo())) {
                return true;
            }
            if (this.impls().contains(info.thisType())) {
                return true;
            }
            if (info.superType().classInfo().isSubclass(info)) {
                return true;
            }
            for (Type t : info.impls()) {
                if (!t.classInfo().isSubclass(info)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException exc) {
            return false;
        }
        return false;
    }
}

