/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.AssignmentStatement;
import com.sun.corba.ee.impl.codegen.Attribute;
import com.sun.corba.ee.impl.codegen.BlockStatement;
import com.sun.corba.ee.impl.codegen.CaseBranch;
import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.impl.codegen.DefinitionStatement;
import com.sun.corba.ee.impl.codegen.Field;
import com.sun.corba.ee.impl.codegen.IfStatement;
import com.sun.corba.ee.impl.codegen.MethodGenerator;
import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.impl.codegen.Printer;
import com.sun.corba.ee.impl.codegen.ReturnStatement;
import com.sun.corba.ee.impl.codegen.Statement;
import com.sun.corba.ee.impl.codegen.SwitchStatement;
import com.sun.corba.ee.impl.codegen.ThrowStatement;
import com.sun.corba.ee.impl.codegen.TreeWalker;
import com.sun.corba.ee.impl.codegen.TreeWalkerContext;
import com.sun.corba.ee.impl.codegen.TryStatement;
import com.sun.corba.ee.impl.codegen.Variable;
import com.sun.corba.ee.impl.codegen.WhileStatement;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Type;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static void close(Node node) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){
            private Variable savedVariable = null;

            public void visitBlockStatement(BlockStatement arg) {
                for (Statement stmt : arg.body()) {
                    if (!(stmt instanceof DefinitionStatement)) continue;
                    DefinitionStatement ds = (DefinitionStatement)DefinitionStatement.class.cast(stmt);
                    ds.var().close();
                }
            }

            public void visitMethodGenerator(MethodGenerator arg) {
                for (Variable var : arg.arguments()) {
                    var.close();
                }
            }
        };
        context.push(visitor);
        node.accept(visitor);
    }

    public static void checkScope(Expression expr) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){

            public boolean preVariable(Variable arg) {
                if (!arg.isAvailable()) {
                    throw new IllegalStateException(arg + " is no longer in scope");
                }
                return false;
            }
        };
        context.push(visitor);
        expr.accept(visitor);
    }

    private static void displayAttributes(Node node, Printer pr) {
        Set<Attribute<?>> attrs = Attribute.getAttributes(node);
        for (Attribute<?> attr : attrs) {
            String typeName = attr.type().getName();
            int lastIndex = typeName.lastIndexOf(46);
            if (lastIndex >= 0) {
                typeName = typeName.substring(lastIndex + 1);
            }
            Object obj = attr.get(node);
            String value = attr.get(node).toString();
            pr.nl().p("|__:").p(attr.name()).p(":").p(typeName).p("=").p(value);
            if (!(obj instanceof Node)) continue;
            pr.in();
            Util.displayAttributes((Node)Node.class.cast(obj), pr);
            pr.out();
        }
    }

    public static void display(Node node, final PrintStream pw) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){
            final Printer pr;
            {
                super(x0);
                this.pr = new Printer(pw, 2, '.');
            }

            private boolean done(Node node) {
                Util.displayAttributes(node, this.pr);
                this.pr.in();
                return true;
            }

            public boolean preNode(Node arg) {
                this.pr.nl().p("Node[").p(arg.toString()).p("]");
                return this.done(arg);
            }

            public void postNode(Node arg) {
                this.pr.out();
            }

            public boolean preClassGenerator(ClassGenerator arg) {
                this.pr.nl().p("ClassGenerator[").p(Modifier.toString(arg.modifiers())).p(" ").p(arg.isInterface() ? "interface" : "class").p(" ").p(arg.name()).p("]");
                return this.done(arg);
            }

            public boolean preMethodGenerator(MethodGenerator arg) {
                this.pr.nl().p("MethodGenerator[").p(Modifier.toString(arg.modifiers())).p(" ").p(arg.returnType().name()).p(" ").p(arg.name()).p("]");
                return this.done(arg);
            }

            public boolean preType(Type arg) {
                this.pr.nl().p(arg.name());
                return this.done(arg);
            }

            public boolean preThrowStatement(ThrowStatement arg) {
                this.pr.nl();
                this.pr.nl().p("ThrowStatement");
                return this.done(arg);
            }

            public boolean preAssignmentStatement(AssignmentStatement arg) {
                this.pr.nl().p("AssignmentStatement");
                return this.done(arg);
            }

            public boolean preBlockStatement(BlockStatement arg) {
                this.pr.nl().p("BlockStatement");
                return this.done(arg);
            }

            public boolean preCaseBranch(CaseBranch arg) {
                this.pr.nl().p("CaseBranch[").p(Integer.toString(arg.label())).p("]");
                return this.done(arg);
            }

            public boolean preDefinitionStatement(DefinitionStatement arg) {
                this.pr.nl().p("DefinitionStatement");
                return this.done(arg);
            }

            public boolean preIfStatement(IfStatement arg) {
                this.pr.nl().p("IfStatement");
                return this.done(arg);
            }

            public void ifStatementBeforeTruePart(IfStatement arg) {
                this.pr.out().nl().p("IfStatement:true").in();
            }

            public boolean ifStatementBeforeFalsePart(IfStatement arg) {
                this.pr.out().nl().p("IfStatement:false").in();
                return true;
            }

            public boolean preReturnStatement(ReturnStatement arg) {
                this.pr.nl().p("ReturnStatement");
                return this.done(arg);
            }

            public boolean preSwitchStatement(SwitchStatement arg) {
                this.pr.nl().p("SwitchStatement");
                return this.done(arg);
            }

            public boolean preTryStatement(TryStatement arg) {
                this.pr.nl().p("TryStatement");
                return this.done(arg);
            }

            public void tryStatementBeforeBlock(TryStatement arg, Type type, Variable var, BlockStatement block) {
                this.pr.out().nl().p("TryStatement:catch[").p("type=").p(type.name()).p(",var=").p(var.ident()).p("]").in();
                var.accept(this);
            }

            public boolean tryStatementBeforeFinalPart(TryStatement arg) {
                this.pr.out().nl().p("TryStatement:finally").in();
                return true;
            }

            public boolean preWhileStatement(WhileStatement arg) {
                this.pr.nl().p("WhileStatement");
                return this.done(arg);
            }

            public boolean preExpression(Expression arg) {
                this.pr.nl().p(arg.toString());
                return this.done(arg);
            }

            public boolean preField(Field arg) {
                this.pr.nl().p(arg.toString());
                return this.done(arg);
            }
        };
        context.push(visitor);
        node.accept(visitor);
    }
}

