/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb;

import com.sun.ejb.base.sfsb.AbstractFileStoreManager;
import com.sun.ejb.base.sfsb.SimpleKeyGenerator;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.spi.container.ContainerService;
import com.sun.ejb.spi.sfsb.SFSBUUIDUtil;
import java.util.logging.Level;

public class PersistentFileStoreManager
extends AbstractFileStoreManager {
    private SFSBUUIDUtil uuidGenerator;

    protected void onInitialization() {
        try {
            this.uuidGenerator = new SimpleKeyGenerator();
            if (this.baseDir.isDirectory()) {
                String[] fileNames = this.baseDir.list();
                _logger.log(Level.FINE, this.storeManagerName + "; removing: " + fileNames.length + " sessions");
                this.removeExpiredPassivatedSessions(fileNames);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_persistmgr_oninit_failed", new Object[]{this.storeManagerName});
            _logger.log(Level.WARNING, "ejb.sfsb_persistmgr_oninit_failed_exception", ex);
        }
    }

    public SFSBUUIDUtil getUUIDUtil() {
        return this.uuidGenerator;
    }

    public void shutdown() {
        super.shutdown();
    }

    private void removeExpiredPassivatedSessions(String[] fileNames) {
        if (fileNames.length > 0) {
            AsyncFileRemovalTask task = new AsyncFileRemovalTask(this, fileNames);
            try {
                ContainerService service = ContainerFactoryImpl.getContainerService();
                service.scheduleWork(super.getClassLoader(), task);
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, this.storeManagerName + ": Cannot execute file removal aynchronously", th);
                task.run();
            }
        }
    }

    private static class AsyncFileRemovalTask
    implements Runnable {
        AbstractFileStoreManager storeManager;
        String[] fileNames;

        AsyncFileRemovalTask(AbstractFileStoreManager manager, String[] fileNames) {
            this.storeManager = manager;
            this.fileNames = fileNames;
        }

        public void run() {
            try {
                int sz = this.fileNames.length;
                for (int i = 0; i < sz; ++i) {
                    this.storeManager.remove(this.fileNames[i]);
                }
            }
            catch (Exception ex) {
                AbstractFileStoreManager._logger.log(Level.FINE, "Error while removing expired file during startup", ex);
            }
        }
    }
}

