/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public class TimerWrapper
implements Timer,
IndirectlySerializable {
    private TimerPrimaryKey timerId_;
    private EJBTimerService timerService_;

    TimerWrapper(TimerPrimaryKey timerId, EJBTimerService timerService) {
        this.timerId_ = timerId;
        this.timerService_ = timerService;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        TimerWrapper.checkCallPermission();
        try {
            this.timerService_.cancelTimer(this.timerId_);
        }
        catch (FinderException fe) {
            throw new NoSuchObjectLocalException("timer no longer exists", (Exception)((Object)fe));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException {
        Date nextTimeout = this.getNextTimeout();
        Date now = new Date();
        long timeRemaining = nextTimeout.getTime() - now.getTime();
        return timeRemaining > 0L ? timeRemaining : 0L;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException {
        Date nextTimeout;
        TimerWrapper.checkCallPermission();
        try {
            nextTimeout = this.timerService_.getNextTimeout(this.timerId_);
        }
        catch (FinderException fe) {
            throw new NoSuchObjectLocalException("timer no longer exists", (Exception)((Object)fe));
        }
        return nextTimeout;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException {
        Serializable info;
        TimerWrapper.checkCallPermission();
        try {
            info = this.timerService_.getInfo(this.timerId_);
        }
        catch (FinderException fe) {
            throw new NoSuchObjectLocalException("timer no longer exists", (Exception)((Object)fe));
        }
        return info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException {
        TimerWrapper.checkCallPermission();
        if (!this.timerService_.timerExists(this.timerId_)) {
            throw new NoSuchObjectLocalException("timer no longer exists");
        }
        return new TimerHandleImpl(this.timerId_);
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof TimerWrapper) {
            TimerWrapper other = (TimerWrapper)o;
            equal = other.timerId_.equals(this.timerId_);
        }
        return equal;
    }

    public int hashCode() {
        return this.timerId_.hashCode();
    }

    public String toString() {
        return "Timer " + this.timerId_;
    }

    private static void checkCallPermission() throws IllegalStateException {
        boolean allowed = false;
        ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
        EJBTimerService timerService = cf.getEJBTimerService();
        if (timerService == null) {
            throw new IllegalStateException("EJBTimerService is not available");
        }
        try {
            InvocationManager invManager = Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            if (inv == null) {
                throw new IllegalStateException("Invocation cannot be null");
            }
            int invType = inv.getInvocationType();
            if (invType == 1) {
                if (inv instanceof Invocation) {
                    ComponentContext context = ((Invocation)inv).context;
                    context.checkTimerServiceMethodAccess();
                    allowed = true;
                } else {
                    allowed = false;
                }
            } else if (invType == 0) {
                throw new IllegalStateException("Web tier access to EJB timers through local interfaces is not portable");
            }
        }
        catch (InvocationException ie) {
            IllegalStateException ise = new IllegalStateException("Operation not allowed");
            ise.initCause(ie);
            throw ise;
        }
        if (!allowed) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializedTimerWrapper(this.timerId_);
    }

    private static class TimerHandleImpl
    implements TimerHandle {
        private TimerPrimaryKey timerId_;

        public TimerHandleImpl(TimerPrimaryKey timerId) {
            this.timerId_ = timerId;
        }

        public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            TimerWrapper timer = null;
            Switch theSwitch = Switch.getSwitch();
            if (theSwitch == null) {
                throw new IllegalStateException("Attempt to use EJB timer from outside a container");
            }
            TimerWrapper.checkCallPermission();
            timer = TimerHandleImpl.getTimerInternal(this.timerId_);
            return timer;
        }

        public static TimerWrapper getTimerInternal(TimerPrimaryKey timerId) throws NoSuchObjectLocalException, EJBException {
            TimerWrapper timer = null;
            ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
            EJBTimerService timerService = cf.getEJBTimerService();
            if (timerService != null) {
                if (!timerService.timerExists(timerId)) {
                    throw new NoSuchObjectLocalException("timer is no longer active");
                }
            } else {
                throw new EJBException("EJB Timer Service not available");
            }
            timer = new TimerWrapper(timerId, timerService);
            return timer;
        }
    }

    public static class SerializedTimerWrapper
    implements SerializableObjectFactory {
        private TimerPrimaryKey timerId_;

        SerializedTimerWrapper() {
        }

        SerializedTimerWrapper(TimerPrimaryKey timerId) {
            this.timerId_ = timerId;
        }

        public Object createObject() throws EJBException {
            ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
            EJBTimerService timerService = cf.getEJBTimerService();
            TimerWrapper timer = new TimerWrapper(this.timerId_, timerService);
            return timer;
        }
    }
}

