/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.meta.MBeanMetaConstants;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanInfo;

public class MBeanHelper
implements MBeanMetaConstants {
    protected static Logger _sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    protected static StringManager _localStrings = StringManager.getManager(BaseAdminMBean.class);
    public static Object INVOKE_ERROR_SIGNAL_OBJECT = new Object();

    public static Object getDescriptorFieldValue(ModelMBeanInfo info, String name) throws MBeanException {
        Descriptor descr = info.getMBeanDescriptor();
        return descr.getFieldValue(name);
    }

    public static String[] getLocation(ModelMBeanInfo info) throws MBeanException {
        return (String[])MBeanHelper.getDescriptorFieldValue(info, "namingLocation");
    }

    public static String getXPathPattern(ModelMBeanInfo info) throws MBeanException {
        return (String)MBeanHelper.getDescriptorFieldValue(info, "xpath");
    }

    private static Class getAttributeClass(String signature) throws Exception {
        if (signature.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (signature.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (signature.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (signature.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (signature.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (signature.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (signature.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (signature.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(signature);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Class.forName(signature);
    }

    public static String[] getParamTypesFromOperationInfo(MBeanOperationInfo opInfo) {
        MBeanParameterInfo[] params = opInfo.getSignature();
        if (params == null) {
            return new String[0];
        }
        ArrayList<String> signature = new ArrayList<String>();
        for (int i = 0; i < params.length; ++i) {
            signature.add(params[i].getType());
        }
        return signature.toArray(new String[signature.size()]);
    }

    public static Class[] getSignatureFromOperationInfo(MBeanOperationInfo opInfo) throws Exception {
        MBeanParameterInfo[] params = opInfo.getSignature();
        if (params == null) {
            return new Class[0];
        }
        ArrayList<Class> signature = new ArrayList<Class>();
        for (int i = 0; i < params.length; ++i) {
            signature.add(MBeanHelper.getAttributeClass(params[i].getType()));
        }
        return signature.toArray(new Class[signature.size()]);
    }

    public static MBeanOperationInfo findMatchingOperationInfo(MBeanInfo mbeanInfo, String name, String[] signature) {
        MBeanOperationInfo[] opInfos = mbeanInfo.getOperations();
        if (opInfos == null) {
            return null;
        }
        for (int i = 0; i < opInfos.length; ++i) {
            String[] sign;
            if (!name.equals(opInfos[i].getName()) || !MBeanHelper.isSignaturesEqual(sign = MBeanHelper.getParamTypesFromOperationInfo(opInfos[i]), signature)) continue;
            return opInfos[i];
        }
        return null;
    }

    public static MBeanAttributeInfo findMatchingAttributeInfo(MBeanInfo mbeanInfo, String name) {
        MBeanAttributeInfo[] attrInfos = mbeanInfo.getAttributes();
        if (attrInfos == null) {
            return null;
        }
        for (int i = 0; i < attrInfos.length; ++i) {
            if (!name.equals(attrInfos[i].getName())) continue;
            return attrInfos[i];
        }
        return null;
    }

    public static Object invokeOperationInBean(MBeanOperationInfo opInfo, Object bean, Object[] params) throws Exception {
        return MBeanHelper.invokeOperationInBean(opInfo.getName(), opInfo, bean, params);
    }

    public static Object invokeOperationInBean(String opName, MBeanOperationInfo opInfo, Object bean, Object[] params) throws Exception {
        Method method;
        block3: {
            method = null;
            try {
                method = MBeanHelper.findMatchingOperationMethod(opName, opInfo, bean);
            }
            catch (Exception e) {
                if (!(e instanceof SecurityException)) break block3;
                _sLogger.log(Level.FINEST, "invokeOperationInBean() failed", e);
            }
        }
        if (method == null) {
            return INVOKE_ERROR_SIGNAL_OBJECT;
        }
        return method.invoke(bean, params);
    }

    public static Method findMatchingOperationMethod(String opName, MBeanOperationInfo opInfo, Object bean) throws Exception {
        Class[] signature = MBeanHelper.getSignatureFromOperationInfo(opInfo);
        return bean.getClass().getMethod(opName, signature);
    }

    private static boolean isSignaturesEqual(String[] sign, String[] signature) {
        if (!(signature != null && signature.length != 0 || sign != null && sign.length != 0)) {
            return true;
        }
        if (signature == null && sign != null || signature != null && sign == null) {
            return false;
        }
        if (signature.length != sign.length) {
            return false;
        }
        boolean bMatch = true;
        for (int j = 0; j < sign.length; ++j) {
            if (sign[j].equals(signature[j])) continue;
            bMatch = false;
            break;
        }
        return bMatch;
    }

    public static MBeanException extractAndWrapTargetException(Exception e, String wrapMsg) {
        while (e instanceof InvocationTargetException || e instanceof MBeanException) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof Exception) {
                    e = (Exception)t;
                    continue;
                }
                e = new Exception(t.getMessage());
                continue;
            }
            if (!(e instanceof MBeanException)) continue;
            e = ((MBeanException)e).getTargetException();
        }
        String msg = e.getMessage();
        String targetMsgPref = _localStrings.getString("admin.server.core.mbean.target_exception_prefix");
        if (msg != null) {
            return new MBeanException(e, wrapMsg + "\n" + targetMsgPref + ": " + e.getMessage());
        }
        return new MBeanException(e, wrapMsg);
    }
}

