/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.util.SOMLocalStringsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class InitConfFileBean {
    public static final String INITCONF_SECURITY_ATTRIBUTE = "Security";
    public static final String INITCONF_VALUE_ON = "on";
    public static final String INITCONF_VALUE_OFF = "off";
    private List storage = Collections.synchronizedList(new LinkedList());
    private List init_storage = Collections.synchronizedList(new LinkedList());
    private int position = 0;
    private int init_position = 0;
    private Hashtable index = new Hashtable();
    private Hashtable init_index = new Hashtable();
    private String mag_file;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(InitConfFileBean.class);

    public void initialise(String instanceName, boolean bBackupFile) throws IOException {
        InstanceEnvironment environ = new InstanceEnvironment(instanceName);
        String confFile = environ.getInitFilePath();
        this.initialize(confFile);
    }

    private void initialize(String confFile) throws IOException {
        this.mag_file = confFile;
        this.storage = Collections.synchronizedList(new LinkedList());
        this.index = new Hashtable();
        this.position = 0;
        this.init_storage = Collections.synchronizedList(new LinkedList());
        this.init_index = new Hashtable();
        this.init_position = 0;
        this.readConfig(confFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig(String fileName) throws IOException {
        File inputFile = new File(fileName);
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        String inLine = null;
        int spaceIndex = 0;
        while ((inLine = in.readLine()) != null) {
            if (inLine.length() <= 2) continue;
            spaceIndex = inLine.indexOf(" ");
            if (spaceIndex == -1 && !inLine.startsWith("Init")) {
                String msg = localizedStrMgr.getString("admin.common.wrong_filename_format");
                throw new IOException(msg);
            }
            String key = !inLine.startsWith("Init") ? inLine.substring(0, spaceIndex) : "Init";
            if (!key.equals("Init")) {
                Hashtable<String, String> temp = new Hashtable<String, String>();
                temp.put(key, inLine.substring(spaceIndex + 1));
                List list = this.storage;
                synchronized (list) {
                    this.storage.add(temp);
                }
                this.index.put(key, new Integer(this.position));
                ++this.position;
                continue;
            }
            String tempString = "";
            if (spaceIndex != -1) {
                tempString = inLine.substring(spaceIndex + 1);
            }
            Hashtable<String, String> temp = new Hashtable<String, String>();
            while (inLine != null) {
                in.mark(500);
                inLine = in.readLine();
                if (inLine == null) continue;
                if (inLine.startsWith("\t") || inLine.startsWith(" ")) {
                    if (inLine.startsWith("\t")) {
                        inLine.replace('\t', ' ');
                    }
                    tempString = tempString + inLine;
                    continue;
                }
                in.reset();
                break;
            }
            temp.put(key, tempString);
            List list = this.init_storage;
            synchronized (list) {
                this.init_storage.add(temp);
            }
            this.init_index.put(key, new Integer(this.position));
            ++this.init_position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfig(String fileName) throws IOException {
        String temp_value;
        String temp_val;
        String temp_key;
        Enumeration e;
        Hashtable temp_store;
        ListIterator storageIter;
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        List list = this.storage;
        synchronized (list) {
            storageIter = this.storage.listIterator(0);
            while (storageIter.hasNext()) {
                temp_store = (Hashtable)storageIter.next();
                e = temp_store.keys();
                while (e.hasMoreElements()) {
                    temp_key = (String)e.nextElement();
                    temp_val = (String)temp_store.get(temp_key);
                    temp_value = temp_key + " " + temp_val;
                    if (temp_val == null || temp_val.trim().equals("")) continue;
                    out.println(temp_value);
                }
                out.flush();
            }
            out.println();
        }
        list = this.init_storage;
        synchronized (list) {
            storageIter = this.init_storage.listIterator(0);
            while (storageIter.hasNext()) {
                temp_store = (Hashtable)storageIter.next();
                e = temp_store.keys();
                while (e.hasMoreElements()) {
                    temp_key = (String)e.nextElement();
                    temp_val = (String)temp_store.get(temp_key);
                    temp_value = temp_key + " " + temp_val;
                    if (temp_val == null || temp_val.trim().equals("")) continue;
                    out.println(temp_value);
                }
                out.flush();
            }
        }
        out.close();
    }

    public void dump() throws IOException {
        this.writeConfig(this.mag_file);
    }

    private int searchIndex(String varName) {
        int indexHash = -1;
        Object o = this.index.get(varName);
        if (o != null) {
            indexHash = (Integer)this.index.get(varName);
        }
        return indexHash;
    }

    private synchronized void remake_index(Hashtable table) {
        int in_size = 0;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            table.put(e.nextElement(), new Integer(in_size));
            ++in_size;
        }
    }

    private synchronized void syncIndex(String varName, int mode) {
        switch (mode) {
            case 0: {
                if (!this.index.containsKey(varName)) break;
                this.index.remove(varName);
                this.remake_index(this.index);
                break;
            }
            default: {
                if (this.index.containsKey(varName)) break;
                this.index.put(varName, new Integer(this.storage.size() - 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_mag_var(String varName) {
        int iterIndex = this.searchIndex(varName);
        String retVal = "";
        if (iterIndex != -1) {
            List list = this.storage;
            synchronized (list) {
                retVal = (String)((Hashtable)this.storage.get(iterIndex)).get(varName);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_mag_var(String varName, String value) {
        int iterIndex = this.searchIndex(varName);
        Hashtable<String, String> temp = new Hashtable<String, String>();
        temp.put(varName, value);
        if (iterIndex != -1) {
            List list = this.storage;
            synchronized (list) {
                this.storage.set(iterIndex, temp);
            }
        }
        List list = this.storage;
        synchronized (list) {
            this.storage.add(temp);
            this.syncIndex(varName, 1);
        }
    }

    public static void main(String[] args) throws IOException {
    }

    public String isSelected(String varName, String val) {
        String value = this.get_mag_var(varName);
        if (value.equals(val)) {
            return "SELECTED";
        }
        return "";
    }
}

