/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueSupport;
import java.util.List;

public final class DottedNameForValue {
    protected final DottedName mDottedName;
    protected DottedName mPrefix;
    protected String mValueName;

    public DottedNameForValue(DottedName dottedName) {
        this.mDottedName = dottedName;
        this.mValueName = null;
        this.mPrefix = this.init();
    }

    private DottedName init() {
        List parts = this.mDottedName.getParts();
        int numParts = parts.size();
        if (numParts == 0) {
            String msg = DottedNameStrings.getString("NoValueNameSpecified");
            throw new IllegalArgumentException(msg + " = " + this.mDottedName);
        }
        String lastPart = (String)parts.get(numParts - 1);
        int numPrefixParts = 0;
        PrefixedValueSupport prop_support = new PrefixedValueSupport(null);
        String dottedName = DottedName.toString(this.mDottedName.getDomain(), this.mDottedName.getScope(), this.mDottedName.getParts(), false);
        boolean isPrefixed = prop_support.isPrefixedValueDottedName(dottedName);
        if (isPrefixed) {
            this.mValueName = prop_support.getPrefixedValueName(dottedName, true);
            numPrefixParts = numParts - 2;
        } else {
            this.mValueName = lastPart;
            numPrefixParts = numParts - 1;
        }
        return DottedNameFactory.getInstance().get(DottedName.toString(this.mDottedName, numPrefixParts));
    }

    public DottedName getPrefix() {
        return this.mPrefix;
    }

    public String getValueName() {
        assert (this.mValueName != null);
        return this.mValueName;
    }

    public String toString() {
        return this.mDottedName.toString();
    }
}

