/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.util.ArrayConversion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DottedNameServerInfoImpl
implements DottedNameServerInfo {
    final MBeanServerConnection mConn;

    public DottedNameServerInfoImpl(MBeanServerConnection conn) {
        this.mConn = conn;
    }

    ObjectName getControllerObjectName() {
        return ObjectNames.getControllerObjectName();
    }

    ObjectName getConfigsObjectName() throws MalformedObjectNameException {
        return new ObjectName("com.sun.appserv:type=configs,category=config");
    }

    ObjectName getServerObjectName(String serverName) {
        return ObjectNames.getServerObjectName(serverName);
    }

    Set _getConfigNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, MalformedObjectNameException, AttributeNotFoundException {
        ObjectName[] configObjectNames = (ObjectName[])this.mConn.invoke(this.getConfigsObjectName(), "getConfig", null, null);
        HashSet<String> configNames = new HashSet<String>();
        for (int i = 0; i < configObjectNames.length; ++i) {
            String name = (String)this.mConn.getAttribute(configObjectNames[i], "name");
            configNames.add(name);
        }
        return configNames;
    }

    public Set getConfigNames() throws DottedNameServerInfo.UnavailableException {
        Set namesSet = null;
        try {
            namesSet = this._getConfigNames();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return namesSet;
    }

    protected Set _getServerNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        MyController controller = MBeanServerInvocationHandler.newProxyInstance(this.mConn, this.getControllerObjectName(), MyController.class, false);
        Object[] names = controller.listServerInstances();
        return ArrayConversion.toSet(names);
    }

    public Set getServerNames() throws DottedNameServerInfo.UnavailableException {
        Set namesSet = null;
        try {
            namesSet = this._getServerNames();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return namesSet;
    }

    public String getConfigNameForServer(String serverName) throws DottedNameServerInfo.UnavailableException {
        ObjectName serverObjectName = this.getServerObjectName(serverName);
        if (serverObjectName == null) {
            throw new DottedNameServerInfo.UnavailableException(serverObjectName.toString());
        }
        String configName = null;
        try {
            configName = (String)this.mConn.getAttribute(serverObjectName, "config_ref");
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e);
        }
        return configName;
    }

    public String[] getServerNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        Iterator iter = this.getServerNames().iterator();
        ArrayList<String> namesOut = new ArrayList<String>();
        while (iter.hasNext()) {
            String serverName = (String)iter.next();
            if (!configName.equals(this.getConfigNameForServer(serverName))) continue;
            namesOut.add(serverName);
        }
        String[] namesOutArray = new String[namesOut.size()];
        namesOut.toArray(namesOutArray);
        return namesOutArray;
    }

    private static interface MyController {
        public String[] listServerInstances();
    }
}

